/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.curl;

import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.lib.curl.Scanner;
import com.caucho.util.Base64;
import com.caucho.util.RandomUtil;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Authentication {
    public static String getAuthorization(String user, String pass, String requestMethod, String uri, String header) {
        if (header.startsWith("Digest")) {
            return Authentication.digest(user, pass, requestMethod, uri, header);
        }
        return Authentication.basic(user, pass);
    }

    public static String basic(String user, String pass) {
        StringBuilder sb = new StringBuilder();
        sb.append(user);
        sb.append(':');
        sb.append(pass);
        return Authentication.basic(sb.toString());
    }

    public static String basic(String usernamePassword) {
        StringBuilder sb = new StringBuilder();
        sb.append("Basic ");
        sb.append(Base64.encode(usernamePassword));
        return sb.toString();
    }

    public static String digest(String user, String pass, String requestMethod, String uri, String header) {
        String key;
        StringBuilder sb = new StringBuilder();
        sb.append("Digest ");
        sb.append("username=\"");
        sb.append(user);
        Scanner scanner = new Scanner(header);
        String realm = "";
        String nonce = "";
        String qop = "";
        String opaque = null;
        String algorithm = null;
        while ((key = scanner.readKey()) != null) {
            String value = scanner.readValue();
            if (key.equals("realm")) {
                realm = value;
                continue;
            }
            if (key.equals("nonce")) {
                nonce = value;
                continue;
            }
            if (key.equals("qop")) {
                qop = value;
                continue;
            }
            if (key.equals("opaque")) {
                opaque = value;
                continue;
            }
            if (!key.equals("algorithm")) continue;
            algorithm = value;
        }
        scanner.close();
        sb.append("\", realm=\"");
        sb.append(realm);
        sb.append("\", nonce=\"");
        sb.append(nonce);
        sb.append("\", uri=\"");
        sb.append(uri);
        sb.append("\", qop=\"");
        sb.append("auth");
        String cnonce = Base64.encode(String.valueOf(RandomUtil.getRandomLong()));
        sb.append("\", cnonce=\"");
        sb.append(cnonce);
        String nc = "00000001";
        sb.append("\", nc=\"");
        sb.append(nc);
        if (opaque != null) {
            sb.append("\", opaque=\"");
            sb.append(opaque);
        }
        if (algorithm != null) {
            sb.append("\", algorithm=\"");
            sb.append(algorithm);
        } else {
            algorithm = "MD5";
        }
        sb.append("\", response=\"");
        Authentication.appendResponse(sb, user, realm, pass, requestMethod, uri, nonce, nc, cnonce, qop, algorithm);
        sb.append('\"');
        return sb.toString();
    }

    private static void appendResponse(StringBuilder sb, String user, String realm, String pass, String requestMethod, String uri, String nonce, String nc, String cnonce, String qop, String algorithm) {
        MessageDigest resultDigest = null;
        MessageDigest scratchDigest = null;
        try {
            resultDigest = MessageDigest.getInstance(algorithm);
            scratchDigest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new QuercusModuleException(e);
        }
        Authentication.md5(scratchDigest, user);
        scratchDigest.update((byte)58);
        Authentication.md5(scratchDigest, realm);
        scratchDigest.update((byte)58);
        Authentication.md5(scratchDigest, pass);
        Authentication.update(resultDigest, scratchDigest.digest());
        resultDigest.update((byte)58);
        Authentication.md5(resultDigest, nonce);
        resultDigest.update((byte)58);
        Authentication.md5(resultDigest, nc);
        resultDigest.update((byte)58);
        Authentication.md5(resultDigest, cnonce);
        resultDigest.update((byte)58);
        Authentication.md5(resultDigest, qop);
        resultDigest.update((byte)58);
        scratchDigest.reset();
        Authentication.md5(scratchDigest, requestMethod);
        scratchDigest.update((byte)58);
        Authentication.md5(scratchDigest, uri);
        Authentication.update(resultDigest, scratchDigest.digest());
        Authentication.appendHex(sb, resultDigest.digest());
    }

    private static void md5(MessageDigest md, String string) {
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            md.update((byte)string.charAt(i));
        }
    }

    private static void update(MessageDigest resultDigest, byte[] digest) {
        for (int i = 0; i < digest.length; ++i) {
            int d1 = digest[i] >> 4 & 0xF;
            int d2 = digest[i] & 0xF;
            resultDigest.update((byte)Authentication.toHexChar(d1));
            resultDigest.update((byte)Authentication.toHexChar(d2));
        }
    }

    private static void appendHex(StringBuilder sb, byte[] digest) {
        for (int i = 0; i < digest.length; ++i) {
            int d1 = digest[i] >> 4 & 0xF;
            int d2 = digest[i] & 0xF;
            sb.append(Authentication.toHexChar(d1));
            sb.append(Authentication.toHexChar(d2));
        }
    }

    private static char toHexChar(int d) {
        if ((d &= 0xF) < 10) {
            return (char)(d + 48);
        }
        return (char)(d - 10 + 97);
    }
}

