/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.curl;

import com.caucho.quercus.lib.curl.Authentication;
import com.caucho.quercus.lib.curl.CurlResource;
import com.caucho.quercus.lib.curl.HttpsConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;

public class CurlHttpConnection {
    private URLConnection _conn;
    private HttpURLConnection _httpConn;
    private URL _url;
    private String _username;
    private String _password;
    private URL _proxyURL;
    private String _proxyUsername;
    private String _proxyPassword;
    private String _proxyType;
    private int _responseCode;
    private boolean _hadSentAuthorization = false;
    private boolean _hadSentProxyAuthorization = false;
    private String _authorization;
    private String _proxyAuthorization;

    protected CurlHttpConnection(URL url, String username, String password) throws IOException {
        this._url = url;
        this._username = username;
        this._password = password;
    }

    public CurlHttpConnection(URL url, String username, String password, URL proxyURL, String proxyUsername, String proxyPassword, String proxyType) throws IOException {
        this._url = url;
        this._proxyURL = proxyURL;
        this._proxyType = proxyType;
        this._username = username;
        this._password = password;
        this._proxyUsername = proxyUsername;
        this._proxyPassword = proxyPassword;
    }

    protected void init(CurlResource curl) throws IOException {
        Proxy proxy = this.getProxy();
        if (proxy != null) {
            this.setConnection(this._url.openConnection(proxy));
        } else {
            this.setConnection(this._url.openConnection());
        }
    }

    public static final CurlHttpConnection createConnection(URL url, String username, String password, CurlResource curl, URL proxyURL, String proxyUsername, String proxyPassword, String proxyType) throws IOException {
        CurlHttpConnection conn;
        if (url.getProtocol().equals("https")) {
            HttpsConnection secureConn = new HttpsConnection(url, username, password);
            conn = secureConn;
        } else {
            conn = new CurlHttpConnection(url, username, password);
        }
        conn._proxyURL = proxyURL;
        conn._proxyUsername = proxyUsername;
        conn._proxyPassword = proxyPassword;
        conn._proxyType = proxyType;
        conn.init(curl);
        return conn;
    }

    public static final CurlHttpConnection createConnection(URL url, String username, String password, CurlResource curl) throws IOException {
        CurlHttpConnection conn;
        if (url.getProtocol().equals("https")) {
            HttpsConnection secureConn = new HttpsConnection(url, username, password);
            conn = secureConn;
        } else {
            conn = new CurlHttpConnection(url, username, password);
        }
        conn.init(curl);
        return conn;
    }

    public void setConnectTimeout(int time) {
        this._conn.setConnectTimeout(time);
    }

    public void setDoOutput(boolean doOutput) {
        this._conn.setDoOutput(doOutput);
    }

    public void setInstanceFollowRedirects(boolean isToFollowRedirects) {
        this.getHttpConnection().setInstanceFollowRedirects(isToFollowRedirects);
    }

    public void setReadTimeout(int time) {
        this.getConnection().setReadTimeout(time);
    }

    public void setRequestMethod(String method) throws ProtocolException {
        this.getHttpConnection().setRequestMethod(method);
    }

    public String getRequestProperty(String key) {
        return this._conn.getRequestProperty(key);
    }

    public void setRequestProperty(String key, String value) {
        this._conn.setRequestProperty(key, value);
    }

    protected final Proxy getProxy() {
        if (this._proxyURL == null || this._proxyURL.getPort() < 0) {
            return null;
        }
        InetSocketAddress address = new InetSocketAddress(this._proxyURL.getHost(), this._proxyURL.getPort());
        return new Proxy(Proxy.Type.valueOf(this._proxyType), address);
    }

    protected final URL getURL() {
        return this._url;
    }

    protected final URLConnection getConnection() {
        return this._conn;
    }

    protected final HttpURLConnection getHttpConnection() {
        if (this._httpConn == null) {
            throw new ClassCastException(this._conn + " is not a HttpURLConnection");
        }
        return this._httpConn;
    }

    protected final void setConnection(URLConnection conn) {
        this._conn = conn;
        if (conn instanceof HttpURLConnection) {
            this._httpConn = (HttpURLConnection)conn;
        }
    }

    public void connect(CurlResource curl) throws ConnectException, ProtocolException, SocketTimeoutException, IOException {
        this.authenticate();
        this._conn.connect();
    }

    public void authenticate() throws ConnectException, ProtocolException, SocketTimeoutException, IOException {
        if (this._username != null || this._proxyUsername != null) {
            this.authenticateImpl();
        }
        if (this._proxyAuthorization != null) {
            this._conn.setRequestProperty("Proxy-Authorization", this._proxyAuthorization);
        }
        if (this._authorization != null) {
            this._conn.setRequestProperty("Authorization", this._authorization);
        }
    }

    public void authenticateImpl() throws ConnectException, ProtocolException, SocketTimeoutException, IOException {
        Proxy proxy = Proxy.NO_PROXY;
        if (this._proxyURL != null) {
            InetSocketAddress address = new InetSocketAddress(this._proxyURL.getHost(), this._proxyURL.getPort());
            proxy = new Proxy(Proxy.Type.valueOf(this._proxyType), address);
        }
        HttpURLConnection headConn = (HttpURLConnection)this._url.openConnection(proxy);
        headConn.setRequestMethod("HEAD");
        if (this._proxyAuthorization != null) {
            headConn.setRequestProperty("Proxy-Authorization", this._proxyAuthorization);
        }
        if (this._authorization != null) {
            headConn.setRequestProperty("Authorization", this._authorization);
        }
        headConn.connect();
        int responseCode = headConn.getResponseCode();
        if (responseCode == 407 && this._proxyAuthorization == null) {
            String header = headConn.getHeaderField("Proxy-Authenticate");
            this._proxyAuthorization = this.getAuthorization(this._url, this.getHttpConnection().getRequestMethod(), header, "Proxy-Authorization", this._proxyUsername, this._proxyPassword);
            this.authenticateImpl();
        } else if (responseCode == 401 && this._authorization == null) {
            String header = headConn.getHeaderField("WWW-Authenticate");
            this._authorization = this.getAuthorization(this._url, this.getHttpConnection().getRequestMethod(), header, "Authorization", this._username, this._password);
            this.authenticateImpl();
        }
        headConn.disconnect();
    }

    private final String getAuthorization(URL url, String requestMethod, String header, String clientField, String username, String password) throws ConnectException, SocketTimeoutException, IOException {
        if (username == null || password == null) {
            return "";
        }
        String uri = url.getFile();
        if (uri.length() == 0) {
            uri = "/";
        }
        String auth = Authentication.getAuthorization(username, password, requestMethod, uri, header);
        return auth;
    }

    public int getContentLength() {
        return this._conn.getContentLength();
    }

    public InputStream getErrorStream() {
        return this.getHttpConnection().getErrorStream();
    }

    public String getHeaderField(String key) {
        return this._conn.getHeaderField(key);
    }

    public String getHeaderField(int i) {
        return this._conn.getHeaderField(i);
    }

    public String getHeaderFieldKey(int i) {
        return this._conn.getHeaderFieldKey(i);
    }

    public InputStream getInputStream() throws IOException {
        return this._conn.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this._conn.getOutputStream();
    }

    public int getResponseCode() throws IOException {
        return this.getHttpConnection().getResponseCode();
    }

    public String getResponseMessage() throws IOException {
        return this.getHttpConnection().getResponseMessage();
    }

    public void disconnect() {
        this.close();
    }

    public void close() {
        if (this._httpConn != null) {
            this._httpConn.disconnect();
        }
    }
}

