/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.db;

import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.db.MysqliResult;
import com.caucho.util.L10N;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JdbcResultResource {
    private static final Logger log = Logger.getLogger(JdbcResultResource.class.getName());
    private static final L10N L = new L10N(JdbcResultResource.class);
    public static final int FETCH_ASSOC = 1;
    public static final int FETCH_NUM = 2;
    public static final int FETCH_BOTH = 3;
    public static final String INTEGER = "int";
    public static final String BLOB = "blob";
    public static final String STRING = "string";
    public static final String DATE = "date";
    public static final String DATETIME = "datetime";
    public static final String REAL = "real";
    public static final String TIME = "time";
    public static final String TIMESTAMP = "timestamp";
    public static final String UNKNOWN = "unknown";
    public static final String YEAR = "year";
    protected static final int COLUMN_CASE_NATURAL = 0;
    protected static final int COLUMN_CASE_UPPER = 1;
    protected static final int COLUMN_CASE_LOWER = 2;
    protected ResultSet _rs;
    private boolean _isValid;
    private int _fieldOffset;
    protected ResultSetMetaData _metaData;
    private Value[] _columnNames;
    private int _columnCase = 0;
    private int _affectedRows;

    public JdbcResultResource(ResultSet rs) {
        this._rs = rs;
    }

    public JdbcResultResource(ResultSet rs, int columnCase) {
        this._rs = rs;
        this._columnCase = columnCase;
    }

    public JdbcResultResource(ResultSetMetaData metaData) {
        this._metaData = metaData;
    }

    public JdbcResultResource(ResultSetMetaData metaData, int columnCase) {
        this._metaData = metaData;
        this._columnCase = columnCase;
    }

    public void close() {
        try {
            ResultSet rs = this._rs;
            this._rs = null;
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    protected Value fetchArray(Env env, int type) {
        return this.fetchArray(env, type, true);
    }

    protected Value fetchArray(Env env, int type, boolean isOrderIndexBeforeName) {
        try {
            if (this._rs == null) {
                return NullValue.NULL;
            }
            if (this._rs.next()) {
                int i;
                this._isValid = true;
                ArrayValueImpl array = new ArrayValueImpl();
                ResultSetMetaData md = this.getMetaData();
                int count = md.getColumnCount();
                if ((type & 1) != 0) {
                    this._columnNames = new Value[count];
                    for (i = 0; i < count; ++i) {
                        String columnName = this.getColumnLabel(md, i + 1);
                        this._columnNames[i] = env.createString(columnName);
                    }
                }
                for (i = 0; i < count; ++i) {
                    Value value = this.getColumnValue(env, i + 1);
                    if (isOrderIndexBeforeName) {
                        if ((type & 2) != 0) {
                            array.put(LongValue.create(i), value);
                        }
                        if ((type & 1) == 0) continue;
                        array.put(this._columnNames[i], value);
                        continue;
                    }
                    if ((type & 1) != 0) {
                        array.put(this._columnNames[i], value);
                    }
                    if ((type & 2) == 0) continue;
                    array.put(LongValue.create(i), value);
                }
                return array;
            }
            return NullValue.NULL;
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            return NullValue.NULL;
        }
    }

    public Value fetchAssoc(Env env) {
        return this.fetchArray(env, 1, true);
    }

    public Value fetchBoth(Env env, boolean isOrderIndexBeforeName) {
        return this.fetchArray(env, 3, isOrderIndexBeforeName);
    }

    public Value fetchNum(Env env) {
        return this.fetchArray(env, 2, false);
    }

    public Value fetchField(Env env, int maxLength, String tableName, String type) {
        if (this._rs == null) {
            return BooleanValue.FALSE;
        }
        ObjectValue result = env.createObject();
        try {
            if (!this._isValid) {
                this._isValid = true;
                this._rs.next();
            }
            result.putField(env, "name", (Value)env.createString(this._rs.getString(1)));
            result.putField(env, "table", (Value)env.createString(tableName));
            result.putField(env, "max_length", (Value)LongValue.create(maxLength));
            if (!this.isInResultString(4, "YES")) {
                result.putField(env, "not_null", (Value)LongValue.ONE);
            } else {
                result.putField(env, "not_null", (Value)LongValue.ZERO);
            }
            if (this.isInResultString(5, "PRI")) {
                result.putField(env, "primary_key", (Value)LongValue.ONE);
            } else {
                result.putField(env, "primary_key", (Value)LongValue.ZERO);
            }
            if (this.isInResultString(5, "MUL")) {
                result.putField(env, "multiple_key", (Value)LongValue.ONE);
            } else {
                result.putField(env, "multiple_key", (Value)LongValue.ZERO);
            }
            if (this.isInResultString(2, INTEGER) || this.isInResultString(2, REAL)) {
                result.putField(env, "numeric", (Value)LongValue.ONE);
            } else {
                result.putField(env, "numeric", (Value)LongValue.ZERO);
            }
            if (this.isInResultString(2, BLOB)) {
                result.putField(env, BLOB, (Value)LongValue.ONE);
            } else {
                result.putField(env, BLOB, (Value)LongValue.ZERO);
            }
            result.putField(env, "type", (Value)env.createString(type));
            if (this.isInResultString(2, "unsigned")) {
                result.putField(env, "unsigned", (Value)LongValue.ONE);
            } else {
                result.putField(env, "unsigned", (Value)LongValue.ZERO);
            }
            if (this.isInResultString(2, "zerofill")) {
                result.putField(env, "zerofill", (Value)LongValue.ONE);
            } else {
                result.putField(env, "zerofill", (Value)LongValue.ZERO);
            }
            return result;
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            return BooleanValue.FALSE;
        }
    }

    protected Value fetchObject(Env env, String className, Value[] args) {
        if (this._rs == null) {
            return NullValue.NULL;
        }
        try {
            if (this._rs.next()) {
                Value result;
                this._isValid = true;
                if (className != null) {
                    QuercusClass cls = env.findClass(className);
                    if (args == null) {
                        args = Value.NULL_ARGS;
                    }
                    result = cls.callNew(env, args);
                } else {
                    result = env.createObject();
                }
                ResultSetMetaData md = this.getMetaData();
                int count = md.getColumnCount();
                for (int i = 0; i < count; ++i) {
                    String name = this.getColumnLabel(md, i + 1);
                    Value value = this.getColumnValue(env, i + 1);
                    result.putField(env, name, value);
                }
                return result;
            }
            return NullValue.NULL;
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            return NullValue.NULL;
        }
    }

    protected Value fetchRow(Env env) {
        return this.fetchArray(env, 2, true);
    }

    protected Value fetchBound(Env env, Value[] vars) {
        if (this._rs == null) {
            return NullValue.NULL;
        }
        try {
            if (this._rs.next()) {
                int size = vars.length;
                for (int i = 0; i < size; ++i) {
                    Value value = this.getColumnValue(env, i + 1);
                    vars[i].set(value);
                }
                return BooleanValue.TRUE;
            }
            return NullValue.NULL;
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            return BooleanValue.FALSE;
        }
    }

    public int getAffectedRows() {
        return this._affectedRows;
    }

    protected boolean next() throws SQLException {
        if (this._rs == null) {
            return false;
        }
        return this._rs.next();
    }

    protected int getColumnNumber(Value fieldNameOrNumber, int base) throws SQLException {
        int fieldNumber = -1;
        if (fieldNameOrNumber != null && fieldNameOrNumber.isLongConvertible()) {
            fieldNumber = fieldNameOrNumber.toInt() - base;
        }
        if (fieldNumber < 0) {
            fieldNumber = this.getColumnNumber(fieldNameOrNumber.toString());
        }
        return fieldNumber;
    }

    protected int getColumnNumber(String colName) throws SQLException {
        return this.getColumnNumber(colName, this.getMetaData());
    }

    private int getColumnNumber(String colName, ResultSetMetaData md) throws SQLException {
        int numColumns = md.getColumnCount();
        if (colName.indexOf(46) == -1) {
            for (int i = 1; i <= numColumns; ++i) {
                if (!colName.equals(this.getColumnLabel(md, i))) continue;
                return i - 1;
            }
            return -1;
        }
        for (int i = 1; i <= numColumns; ++i) {
            if (!colName.equals(md.getTableName(i) + '.' + md.getColumnLabel(i))) continue;
            return i - 1;
        }
        return -1;
    }

    protected Value getColumnValue(Env env, int column) throws SQLException {
        int type = this.getMetaData().getColumnType(column);
        return this.getColumnValue(env, column, type);
    }

    protected Value getColumnValue(Env env, int column, int type) throws SQLException {
        ResultSet rs = this._rs;
        try {
            switch (type) {
                case 0: {
                    return NullValue.NULL;
                }
                case -7: {
                    String typeName = this.getMetaData().getColumnTypeName(column);
                    if (!typeName.equals("bool")) {
                        String value = rs.getString(column);
                        if (rs.wasNull()) {
                            return NullValue.NULL;
                        }
                        return env.createString(value);
                    }
                }
                case 16: {
                    boolean b = rs.getBoolean(column);
                    if (rs.wasNull()) {
                        return NullValue.NULL;
                    }
                    return env.createString(b ? "t" : "f");
                }
                case -6: 
                case -5: 
                case 4: 
                case 5: {
                    long value = rs.getLong(column);
                    if (rs.wasNull()) {
                        return NullValue.NULL;
                    }
                    return env.createString(value);
                }
                case 7: 
                case 8: {
                    double value = rs.getDouble(column);
                    if (rs.wasNull()) {
                        return NullValue.NULL;
                    }
                    if (this.getMetaData().isCurrency(column)) {
                        StringValue sb = env.createUnicodeBuilder();
                        sb.append("$");
                        return sb.append(value);
                    }
                    if (value == 0.0) {
                        StringValue sb = env.createUnicodeBuilder();
                        return sb.append("0");
                    }
                    StringValue sb = env.createUnicodeBuilder();
                    return sb.append(value);
                }
                case 2004: {
                    return this.getBlobValue(env, rs, this.getMetaData(), column);
                }
                case 2005: {
                    return this.getClobValue(env, rs, this.getMetaData(), column);
                }
                case -4: 
                case -3: 
                case -2: {
                    StringValue bb = env.createBinaryBuilder();
                    InputStream is = rs.getBinaryStream(column);
                    if (is == null) {
                        return NullValue.NULL;
                    }
                    try {
                        bb.appendReadAll(is, 0x3FFFFFFFFFFFFFFFL);
                    }
                    catch (RuntimeException e) {
                        log.log(Level.WARNING, e.toString(), e);
                        return NullValue.NULL;
                    }
                    return bb;
                }
                case -1: 
                case 12: {
                    if (env.isUnicodeSemantics()) {
                        return this.getUnicodeColumnString(env, rs, this.getMetaData(), column);
                    }
                    if (this instanceof MysqliResult) {
                        StringValue bb = env.createBinaryBuilder();
                        InputStream is = rs.getBinaryStream(column);
                        if (is == null) {
                            return NullValue.NULL;
                        }
                        try {
                            bb.appendReadAll(is, 0x3FFFFFFFFFFFFFFFL);
                        }
                        catch (RuntimeException e) {
                            log.log(Level.WARNING, e.toString(), e);
                            return NullValue.NULL;
                        }
                        return bb;
                    }
                    String strValue = rs.getString(column);
                    if (strValue == null) {
                        return NullValue.NULL;
                    }
                    return env.createString(strValue);
                }
                case 92: {
                    return this.getColumnTime(env, rs, column);
                }
                case 93: {
                    return this.getColumnTimestamp(env, rs, column);
                }
                case 91: {
                    return this.getColumnDate(env, rs, column);
                }
            }
            String strValue = rs.getString(column);
            if (strValue == null) {
                return NullValue.NULL;
            }
            return env.createString(strValue);
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
            return NullValue.NULL;
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            return NullValue.NULL;
        }
    }

    protected Value getBlobValue(Env env, ResultSet rs, ResultSetMetaData metaData, int column) throws SQLException {
        return this.getColumnString(env, rs, metaData, column);
    }

    protected Value getClobValue(Env env, ResultSet rs, ResultSetMetaData metaData, int column) throws SQLException {
        return this.getColumnString(env, rs, metaData, column);
    }

    protected Value getUnicodeColumnString(Env env, ResultSet rs, ResultSetMetaData md, int column) throws IOException, SQLException {
        Reader reader = rs.getCharacterStream(column);
        if (reader == null) {
            return NullValue.NULL;
        }
        StringValue bb = env.createUnicodeBuilder();
        bb.append(reader);
        return bb;
    }

    protected Value getColumnString(Env env, ResultSet rs, ResultSetMetaData md, int column) throws SQLException {
        byte[] bytes = rs.getBytes(column);
        if (bytes == null) {
            return NullValue.NULL;
        }
        StringValue bb = env.createUnicodeBuilder();
        bb.append(bytes);
        return bb;
    }

    protected Value getColumnTime(Env env, ResultSet rs, int column) throws SQLException {
        Time time = rs.getTime(column);
        if (time == null) {
            return NullValue.NULL;
        }
        return env.createString(String.valueOf(time));
    }

    protected Value getColumnDate(Env env, ResultSet rs, int column) throws SQLException {
        Date date = rs.getDate(column);
        if (date == null) {
            return NullValue.NULL;
        }
        return env.createString(String.valueOf(date));
    }

    protected Value getColumnTimestamp(Env env, ResultSet rs, int column) throws SQLException {
        try {
            Timestamp timestamp = rs.getTimestamp(column);
            if (timestamp == null) {
                return NullValue.NULL;
            }
            String time = String.valueOf(timestamp);
            if (time.endsWith(".0")) {
                time = time.substring(0, time.length() - 2);
            }
            return env.createString(time);
        }
        catch (SQLException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, e.toString(), e);
            }
            return env.createString("0000-00-00 00:00:00");
        }
    }

    public Value getFieldCatalog(Env env, int fieldOffset) {
        try {
            ResultSetMetaData md = this.getMetaData();
            if (md.getColumnCount() <= fieldOffset || fieldOffset < 0) {
                return BooleanValue.FALSE;
            }
            return env.createString(md.getCatalogName(fieldOffset + 1));
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            return BooleanValue.FALSE;
        }
    }

    public int getFieldCount() {
        try {
            if (this.getMetaData() != null) {
                return this.getMetaData().getColumnCount();
            }
            return -1;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean isValidFieldOffset(int fieldOffset) {
        try {
            ResultSetMetaData md = this.getMetaData();
            return fieldOffset >= 0 && md.getColumnCount() > fieldOffset;
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
    }

    protected boolean isInResultString(int columnIndex, String substring) throws SQLException {
        String resultString = this._rs.getString(columnIndex);
        if (resultString == null) {
            return false;
        }
        int index = resultString.indexOf(substring);
        return index != -1;
    }

    public Value getFieldLength(Env env, int fieldOffset) {
        try {
            ResultSetMetaData md = this.getMetaData();
            if (md.getColumnCount() <= fieldOffset || fieldOffset < 0) {
                env.invalidArgument("field", fieldOffset);
                return BooleanValue.FALSE;
            }
            return LongValue.create(md.getPrecision(fieldOffset + 1));
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            return BooleanValue.FALSE;
        }
    }

    public Value getFieldName(Env env, int fieldOffset) {
        try {
            ResultSetMetaData md = this.getMetaData();
            if (md.getColumnCount() <= fieldOffset || fieldOffset < 0) {
                env.invalidArgument("field", fieldOffset);
                return BooleanValue.FALSE;
            }
            return env.createString(this.getColumnLabel(md, fieldOffset + 1));
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return BooleanValue.FALSE;
        }
    }

    public Value getFieldNameAlias(Env env, int fieldOffset) {
        try {
            ResultSetMetaData md = this.getMetaData();
            if (md.getColumnCount() <= fieldOffset || fieldOffset < 0) {
                return BooleanValue.FALSE;
            }
            return env.createString(this.getColumnLabel(md, fieldOffset + 1));
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return BooleanValue.FALSE;
        }
    }

    public Value getFieldNotNull(Env env, int fieldOffset) {
        try {
            ResultSetMetaData md = this.getMetaData();
            if (md.getColumnCount() <= fieldOffset || fieldOffset < 0) {
                env.invalidArgument("field", fieldOffset);
                return BooleanValue.FALSE;
            }
            if (md.isNullable(fieldOffset + 1) == 0) {
                return LongValue.ONE;
            }
            return LongValue.ZERO;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return BooleanValue.FALSE;
        }
    }

    public int getFieldOffset() {
        return this._fieldOffset;
    }

    public Value getFieldScale(int fieldOffset) {
        try {
            ResultSetMetaData md = this.getMetaData();
            if (md.getColumnCount() <= fieldOffset || fieldOffset < 0) {
                return BooleanValue.FALSE;
            }
            return LongValue.create(md.getScale(fieldOffset + 1));
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            return BooleanValue.FALSE;
        }
    }

    public Value getFieldTable(Env env, int fieldOffset) {
        try {
            ResultSetMetaData md = this.getMetaData();
            if (md.getColumnCount() <= fieldOffset || fieldOffset < 0) {
                env.invalidArgument("field", fieldOffset);
                return BooleanValue.FALSE;
            }
            String tableName = md.getTableName(fieldOffset + 1);
            if (tableName == null || tableName.equals("")) {
                return BooleanValue.FALSE;
            }
            return env.createString(tableName);
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            return BooleanValue.FALSE;
        }
    }

    public Value getFieldSchema(Env env, int fieldOffset) {
        try {
            ResultSetMetaData md = this.getMetaData();
            if (md.getColumnCount() <= fieldOffset || fieldOffset < 0) {
                env.invalidArgument("schema", fieldOffset);
                return BooleanValue.FALSE;
            }
            String tableName = md.getSchemaName(fieldOffset + 1);
            if (tableName == null || tableName.equals("")) {
                return BooleanValue.FALSE;
            }
            return env.createString(tableName);
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            return BooleanValue.FALSE;
        }
    }

    public Value getFieldType(Env env, int fieldOffset) {
        try {
            ResultSetMetaData md = this.getMetaData();
            if (md.getColumnCount() <= fieldOffset || fieldOffset < 0) {
                env.invalidArgument("field", fieldOffset);
                return BooleanValue.FALSE;
            }
            int jdbcType = md.getColumnType(fieldOffset + 1);
            return env.createString(this.getFieldType(fieldOffset, jdbcType));
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return BooleanValue.FALSE;
        }
    }

    protected String getFieldType(int fieldOffset, int jdbcType) {
        switch (jdbcType) {
            case -7: 
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return INTEGER;
            }
            case -4: 
            case -1: {
                return BLOB;
            }
            case -3: 
            case -2: 
            case 1: 
            case 12: {
                return STRING;
            }
            case 92: {
                return TIME;
            }
            case 91: {
                return DATE;
            }
            case 93: {
                return DATETIME;
            }
            case 3: 
            case 7: 
            case 8: {
                return REAL;
            }
        }
        return UNKNOWN;
    }

    protected Value getJdbcType(int fieldOffset) {
        try {
            ResultSetMetaData md = this.getMetaData();
            return LongValue.create(md.getColumnType(fieldOffset + 1));
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return BooleanValue.FALSE;
        }
    }

    public Value getLengths() {
        ArrayValueImpl result;
        ArrayValueImpl array = new ArrayValueImpl();
        try {
            ResultSetMetaData md = this.getMetaData();
            int numColumns = md.getColumnCount();
            for (int i = 1; i <= numColumns; ++i) {
                ((ArrayValue)array).put(LongValue.create(this._rs.getObject(i).toString().length()));
            }
            result = array;
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            return BooleanValue.FALSE;
        }
        return result;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (this._metaData != null) {
            return this._metaData;
        }
        if (this._metaData == null && this._rs != null) {
            this._metaData = this._rs.getMetaData();
        }
        return this._metaData;
    }

    public Value getNumFields() {
        try {
            Value result = NullValue.NULL;
            ResultSetMetaData md = this.getMetaData();
            int count = md.getColumnCount();
            if (count != 0) {
                result = LongValue.create(count);
            }
            return result;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return NullValue.NULL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumRows() {
        int n;
        block13: {
            int currentRow;
            ResultSet rs;
            block11: {
                rs = this._rs;
                if (rs == null) {
                    return -1;
                }
                currentRow = rs.getRow();
                try {
                    rs.last();
                    n = rs.getRow();
                    if (currentRow != 0) break block11;
                }
                catch (Exception e) {
                    int n2;
                    block14: {
                        block12: {
                            try {
                                log.log(Level.FINE, e.toString(), e);
                                n2 = -1;
                                if (currentRow != 0) break block12;
                            }
                            catch (Throwable throwable) {
                                try {
                                    if (currentRow == 0) {
                                        rs.beforeFirst();
                                    } else {
                                        rs.absolute(currentRow);
                                    }
                                    throw throwable;
                                }
                                catch (SQLException e2) {
                                    log.log(Level.FINE, e2.toString(), e2);
                                    return -1;
                                }
                            }
                            rs.beforeFirst();
                            break block14;
                        }
                        rs.absolute(currentRow);
                    }
                    return n2;
                }
                rs.beforeFirst();
                break block13;
            }
            rs.absolute(currentRow);
        }
        return n;
    }

    public Value getResultField(Env env, int row, Value field) {
        try {
            ResultSetMetaData md = this.getMetaData();
            int colNumber = field.isNumberConvertible() ? field.toInt() : this.getColumnNumber(field.toString(), md);
            if (colNumber < 0 || colNumber >= md.getColumnCount()) {
                env.invalidArgument("field", field);
                return BooleanValue.FALSE;
            }
            int currentRow = this._rs.getRow();
            if (row < 0 || !this._rs.absolute(row + 1) || this._rs.isAfterLast()) {
                if (currentRow > 0) {
                    this._rs.absolute(currentRow);
                } else {
                    this._rs.beforeFirst();
                }
                env.invalidArgument("row", row);
                return BooleanValue.FALSE;
            }
            return this.getColumnValue(env, colNumber + 1);
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            return BooleanValue.FALSE;
        }
    }

    protected String getColumnLabel(int index) throws SQLException {
        return this.getColumnLabel(this._rs.getMetaData(), index);
    }

    private String getColumnLabel(ResultSetMetaData md, int index) throws SQLException {
        String name = md.getColumnLabel(index);
        switch (this._columnCase) {
            case 2: {
                return name.toLowerCase();
            }
            case 1: {
                return name.toUpperCase();
            }
        }
        return name;
    }

    public ResultSet getResultSet() {
        return this._rs;
    }

    public boolean seek(Env env, int rowNumber) {
        return this.setRowNumber(rowNumber);
    }

    public void setAffectedRows(int affectedRows) {
        this._affectedRows = affectedRows;
    }

    public boolean setFieldOffset(int fieldOffset) {
        this._fieldOffset = fieldOffset;
        return fieldOffset >= 0 && fieldOffset < this.getNumFields().toInt();
    }

    public boolean setRowNumber(int rowNumber) {
        int numRows = this.getNumRows();
        if (numRows <= rowNumber || rowNumber < 0) {
            return false;
        }
        try {
            if (rowNumber == 0) {
                this._rs.beforeFirst();
            } else {
                this._rs.absolute(rowNumber);
            }
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
        return true;
    }

    public String toString() {
        if (this._rs != null) {
            return this.getClass().getSimpleName() + "[" + this._rs.getClass().getSimpleName() + "]";
        }
        return this.getClass().getSimpleName() + "[]";
    }

    public JdbcResultResource validateResult() {
        return this;
    }
}

