/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.db;

public class SqlParseToken {
    private String _query;
    private String _token;
    private int _start;
    private int _end;
    private char _firstChar;

    public void init() {
        this._query = null;
        this._token = null;
        this._start = -1;
        this._end = -1;
        this._firstChar = '\u0000';
    }

    public void assign(String query, int start, int end) {
        this._query = query;
        this._token = null;
        this._start = start;
        this._end = end;
        this._firstChar = query.charAt(start);
    }

    public boolean matchesFirstChar(char upper, char lower) {
        return this._firstChar == upper || this._firstChar == lower;
    }

    public char getFirstChar() {
        return this._firstChar;
    }

    public int getEnd() {
        return this._end;
    }

    public boolean matchesToken(String token) {
        if (this._token == null) {
            this._token = this._query.substring(this._start, this._end);
        }
        return this._token.equalsIgnoreCase(token);
    }

    public String toString() {
        if (this._token == null) {
            this._token = this._query.substring(this._start, this._end);
        }
        return this._token;
    }

    public String toUnquotedString() {
        String tok = this.toString();
        if (tok.length() >= 2 && tok.charAt(0) == '`' && tok.charAt(tok.length() - 1) == '`') {
            tok = tok.substring(1, tok.length() - 1);
        }
        return tok;
    }
}

