/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.dom;

import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.lib.dom.DOMAttr;
import com.caucho.quercus.lib.dom.DOMException;
import com.caucho.quercus.lib.dom.DOMImplementation;
import com.caucho.quercus.lib.dom.DOMNode;
import com.caucho.quercus.lib.dom.DOMNodeList;
import com.caucho.quercus.lib.dom.DOMTypeInfo;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOMElement
extends DOMNode<Element> {
    public static DOMElement __construct(Env env, String name, @Optional String textContent, @Optional String namespace) {
        DOMElement element = namespace != null && namespace.length() > 0 ? DOMElement.getImpl(env).createElement(name, namespace) : DOMElement.getImpl(env).createElement(name);
        if (textContent != null && textContent.length() > 0) {
            element.setTextContent(textContent);
        }
        return element;
    }

    DOMElement(DOMImplementation impl, Element node) {
        super(impl, node);
    }

    @Override
    public CharSequence getNodeValue(Env env) throws DOMException {
        return this.getTextContent(env);
    }

    public String getAttribute(String name) {
        return ((Element)this._delegate).getAttribute(name);
    }

    public String getAttributeNS(String namespaceURI, String localName) throws DOMException {
        try {
            return ((Element)this._delegate).getAttributeNS(namespaceURI, localName);
        }
        catch (org.w3c.dom.DOMException ex) {
            throw this.wrap(ex);
        }
    }

    public DOMAttr getAttributeNode(String name) {
        return (DOMAttr)this.wrap(((Element)this._delegate).getAttributeNode(name));
    }

    public DOMAttr getAttributeNodeNS(String namespaceURI, String localName) throws DOMException {
        try {
            return (DOMAttr)this.wrap(((Element)this._delegate).getAttributeNodeNS(namespaceURI, localName));
        }
        catch (org.w3c.dom.DOMException ex) {
            throw this.wrap(ex);
        }
    }

    public DOMNodeList getElementsByTagName(String name) {
        return (DOMNodeList)this.wrap(((Element)this._delegate).getElementsByTagName(name));
    }

    public DOMNodeList getElementsByTagNameNS(String namespaceURI, String localName) throws DOMException {
        try {
            return (DOMNodeList)this.wrap(((Element)this._delegate).getElementsByTagNameNS(namespaceURI, localName));
        }
        catch (org.w3c.dom.DOMException ex) {
            throw this.wrap(ex);
        }
    }

    public DOMTypeInfo getSchemaTypeInfo() {
        return (DOMTypeInfo)this.wrap(((Element)this._delegate).getSchemaTypeInfo());
    }

    public String getTagName() {
        return ((Element)this._delegate).getTagName();
    }

    public boolean hasAttribute(String name) {
        return ((Element)this._delegate).hasAttribute(name);
    }

    public boolean hasAttributeNS(String namespaceURI, String localName) throws DOMException {
        try {
            return ((Element)this._delegate).hasAttributeNS(namespaceURI, localName);
        }
        catch (org.w3c.dom.DOMException ex) {
            throw this.wrap(ex);
        }
    }

    public void removeAttribute(String name) throws DOMException {
        try {
            ((Element)this._delegate).removeAttribute(name);
        }
        catch (org.w3c.dom.DOMException ex) {
            throw this.wrap(ex);
        }
    }

    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        try {
            ((Element)this._delegate).removeAttributeNS(namespaceURI, localName);
        }
        catch (org.w3c.dom.DOMException ex) {
            throw this.wrap(ex);
        }
    }

    public DOMAttr removeAttributeNode(DOMAttr oldAttr) throws DOMException {
        try {
            return (DOMAttr)this.wrap(((Element)this._delegate).removeAttributeNode((Attr)oldAttr._delegate));
        }
        catch (org.w3c.dom.DOMException ex) {
            throw this.wrap(ex);
        }
    }

    public void setAttribute(String name, String value) throws DOMException {
        try {
            ((Element)this._delegate).setAttribute(name, value);
        }
        catch (org.w3c.dom.DOMException ex) {
            throw this.wrap(ex);
        }
    }

    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        try {
            ((Element)this._delegate).setAttributeNS(namespaceURI, qualifiedName, value);
        }
        catch (org.w3c.dom.DOMException ex) {
            throw this.wrap(ex);
        }
    }

    public DOMAttr setAttributeNode(DOMAttr newAttr) throws DOMException {
        try {
            return (DOMAttr)this.wrap(((Element)this._delegate).setAttributeNode((Attr)newAttr._delegate));
        }
        catch (org.w3c.dom.DOMException ex) {
            throw this.wrap(ex);
        }
    }

    public DOMAttr setAttributeNodeNS(DOMAttr newAttr) throws DOMException {
        try {
            return (DOMAttr)this.wrap(((Element)this._delegate).setAttributeNodeNS((Attr)newAttr._delegate));
        }
        catch (org.w3c.dom.DOMException ex) {
            throw this.wrap(ex);
        }
    }

    public void setIdAttribute(String name, boolean isId) throws DOMException {
        try {
            ((Element)this._delegate).setIdAttribute(name, isId);
        }
        catch (org.w3c.dom.DOMException ex) {
            throw this.wrap(ex);
        }
    }

    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
        try {
            ((Element)this._delegate).setIdAttributeNS(namespaceURI, localName, isId);
        }
        catch (org.w3c.dom.DOMException ex) {
            throw this.wrap(ex);
        }
    }

    public void setIdAttributeNode(DOMAttr idAttr, boolean isId) throws DOMException {
        try {
            ((Element)this._delegate).setIdAttributeNode((Attr)idAttr._delegate, isId);
        }
        catch (org.w3c.dom.DOMException ex) {
            throw this.wrap(ex);
        }
    }

    @Override
    public void setNodeValue(String nodeValue) throws DOMException {
        if (nodeValue == null) {
            nodeValue = "";
        }
        this.setTextContent(nodeValue);
    }
}

