/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.file;

import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.file.BinaryInput;
import com.caucho.quercus.lib.file.BinaryOutput;
import com.caucho.quercus.lib.file.LineReader;
import com.caucho.vfs.TempBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractBinaryInputOutput
implements BinaryInput,
BinaryOutput {
    private static final Logger log = Logger.getLogger(AbstractBinaryInputOutput.class.getName());
    protected final Env _env;
    protected final LineReader _lineReader;
    private InputStream _is;
    private OutputStream _os;
    protected boolean _isTimeout;
    protected boolean _isEOF;

    protected AbstractBinaryInputOutput(Env env) {
        this._env = env;
        this._lineReader = new LineReader(env);
    }

    public void init(InputStream is, OutputStream os) {
        this._is = is;
        this._os = os;
    }

    public InputStream getInputStream() {
        return this._is;
    }

    public BinaryInput openCopy() throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public abstract void unread() throws IOException;

    public int getAvailable() throws IOException {
        if (this._is != null) {
            return this._is.available();
        }
        return -1;
    }

    public int read() throws IOException {
        try {
            if (this._is != null) {
                int c = this._is.read();
                if (c < 0) {
                    this._isEOF = true;
                }
                return c;
            }
            return -1;
        }
        catch (IOException e) {
            this._isTimeout = true;
            this._isEOF = true;
            log.log(Level.FINER, e.toString(), e);
            return -1;
        }
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        try {
            if (this._is != null) {
                int c = this._is.read(buffer, offset, length);
                if (c < 0) {
                    this._isEOF = true;
                }
                return c;
            }
            return -1;
        }
        catch (IOException e) {
            this._isTimeout = true;
            this._isEOF = true;
            log.log(Level.FINER, e.toString(), e);
            return -1;
        }
    }

    public StringValue read(int length) throws IOException {
        if (this._is == null) {
            return null;
        }
        StringValue bb = this._env.createBinaryBuilder();
        if (bb.appendRead(this._is, (long)length) > 0) {
            return bb;
        }
        return null;
    }

    public StringValue readLine(long length) throws IOException {
        try {
            StringValue line = this._lineReader.readLine(this._env, this, length);
            return line;
        }
        catch (IOException e) {
            this._isTimeout = true;
            this._isEOF = true;
            log.log(Level.FINER, e.toString(), e);
            return this._env.getEmptyString();
        }
    }

    public boolean readOptionalLinefeed() throws IOException {
        if (this._is == null) {
            return false;
        }
        int ch = this.read();
        if (ch == 10) {
            return true;
        }
        this.unread();
        return false;
    }

    public StringValue appendTo(StringValue builder) throws IOException {
        if (this._is != null) {
            return builder.append(this._is);
        }
        return builder;
    }

    public boolean isEOF() {
        return this._is == null || this._isEOF;
    }

    public boolean isTimeout() {
        return this._isTimeout;
    }

    public abstract long getPosition();

    public abstract boolean setPosition(long var1);

    public long seek(long offset, int whence) {
        long position;
        switch (whence) {
            case 1: {
                position = this.getPosition() + offset;
                break;
            }
            case 2: {
                position = this.getPosition();
                break;
            }
            default: {
                position = offset;
            }
        }
        if (!this.setPosition(position)) {
            return -1L;
        }
        return position;
    }

    public Value stat() {
        return BooleanValue.FALSE;
    }

    public void closeRead() {
        try {
            InputStream is = this._is;
            this._is = null;
            if (is != null) {
                is.close();
            }
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public OutputStream getOutputStream() {
        return this._os;
    }

    public void write(int ch) throws IOException {
        this._os.write(ch);
    }

    public void write(byte[] buffer, int offset, int length) throws IOException {
        this._os.write(buffer, offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(InputStream is, int length) throws IOException {
        int writeLength = 0;
        TempBuffer tb = TempBuffer.allocate();
        byte[] buffer = tb.getBuffer();
        try {
            while (length > 0) {
                int sublen = length < buffer.length ? length : buffer.length;
                if ((sublen = is.read(buffer, 0, sublen)) < 0) break;
                this.write(buffer, 0, sublen);
                writeLength += sublen;
                length -= sublen;
            }
            int n = writeLength;
            return n;
        }
        finally {
            TempBuffer.free(tb);
        }
    }

    public void print(char v) throws IOException {
        this.write((byte)v);
    }

    public void print(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.print(s.charAt(i));
        }
    }

    public void flush() throws IOException {
        this._os.flush();
    }

    public void closeWrite() {
        try {
            OutputStream os = this._os;
            this._os = null;
            if (os != null) {
                os.close();
            }
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public void close() {
        this.closeRead();
        this.closeWrite();
    }

    public Object toJavaObject() {
        return this;
    }

    public void setTimeout(long timeout) {
    }

    public String getResourceType() {
        return "stream";
    }

    protected Env getEnv() {
        return this._env;
    }

    public String toString() {
        if (this._is != null) {
            return this.getClass().getSimpleName() + "[]";
        }
        return this.getClass().getSimpleName() + "[closed]";
    }
}

