/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.file;

import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.StringBuilderValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnicodeBuilderValue;
import com.caucho.quercus.env.UnsetValue;
import com.caucho.quercus.env.Value;
import com.caucho.vfs.ReadStream;
import java.io.IOException;

public class IniParser {
    public static ArrayValue parse(Env env, ReadStream is, boolean isProcessSections) throws IOException {
        int ch;
        ArrayValueImpl top;
        ArrayValueImpl section = top = new ArrayValueImpl();
        while ((ch = IniParser.skipWhitespaces(is)) >= 0) {
            if (ch == 59) {
                IniParser.skipToNewline(is);
                continue;
            }
            if (ch == 35) {
                IniParser.skipToNewline(is);
                continue;
            }
            if (ch == 91) {
                StringValue key = IniParser.parseBracketKey(env, is);
                if (!isProcessSections) continue;
                section = new ArrayValueImpl();
                top.put(key, section);
                continue;
            }
            is.unread();
            IniParser.parseIniLine(env, is, section);
        }
        return top;
    }

    private static StringValue parseBracketKey(Env env, ReadStream is) throws IOException {
        StringValue sb = env.createStringBuilder();
        int ch = IniParser.skipSpacesAndTabs(is);
        int quoteChar = -1;
        if (ch == 34 || ch == 39) {
            quoteChar = ch;
            ch = is.read();
        }
        while (ch >= 0 && ch != quoteChar && (ch != 93 || quoteChar >= 0)) {
            if (ch == 13 || ch == 10) {
                throw new IOException("expected ']' but saw end of line");
            }
            sb.append((char)ch);
            ch = is.read();
        }
        if (ch == quoteChar) {
            ch = is.read();
            while (ch >= 0 && ch != 93) {
                ch = is.read();
            }
        }
        return sb;
    }

    private static void parseIniLine(Env env, ReadStream is, ArrayValue section) throws IOException {
        StringValue name = IniParser.parseIniName(env, is);
        StringValue key = null;
        int ch = IniParser.skipSpacesAndTabs(is);
        if (ch == 91) {
            key = IniParser.parseBracketKey(env, is);
            ch = IniParser.skipSpacesAndTabs(is);
        }
        if (ch != 61) {
            throw new IOException("expected '=', but saw '" + (char)ch + "' (" + ch + ")");
        }
        Value value = IniParser.parseIniValue(env, is);
        if (key != null) {
            Value array = section.get(name);
            if (array == UnsetValue.UNSET) {
                array = new ArrayValueImpl();
                section.put(name, array);
            }
            array.put(key, value);
        } else {
            section.put(name, value);
        }
    }

    private static StringValue parseIniName(Env env, ReadStream is) throws IOException {
        int len;
        StringValue sb = env.createStringBuilder();
        int ch = IniParser.skipSpacesAndTabs(is);
        int quoteChar = -1;
        if (ch == 34 || ch == 39) {
            quoteChar = ch;
            ch = is.read();
        }
        while (ch >= 0 && ch != quoteChar && ch != 13 && ch != 10 && (quoteChar >= 0 || IniParser.isValidIniKeyChar(ch))) {
            sb.append((char)ch);
            ch = is.read();
        }
        if (ch == quoteChar) {
            ch = is.read();
            while (ch >= 0 && ch != 93) {
                ch = is.read();
            }
        }
        is.unread();
        for (len = sb.length(); len > 0 && Character.isWhitespace(ch = (int)sb.charAt(len - 1)); --len) {
        }
        if (len != sb.length()) {
            if (sb instanceof StringBuilderValue) {
                ((StringBuilderValue)sb).setLength(len);
            } else {
                ((UnicodeBuilderValue)sb).setLength(len);
            }
        }
        return sb;
    }

    private static Value parseIniValue(Env env, ReadStream is) throws IOException {
        int ch = IniParser.skipSpacesAndTabs(is);
        if (ch == 13 || ch == 10) {
            return NullValue.NULL;
        }
        if (ch == 34 || ch == 39) {
            int quoteChar = ch;
            StringValue sb = env.createStringBuilder();
            ch = is.read();
            while (ch >= 0 && ch != quoteChar) {
                sb.append((char)ch);
                ch = is.read();
            }
            IniParser.skipToNewline(is);
            return sb;
        }
        StringBuilder sb = new StringBuilder();
        while (ch >= 0 && ch != 13 && ch != 10) {
            if (ch == 59) {
                IniParser.skipToNewline(is);
                break;
            }
            if (ch == 36) {
                int peek = is.read();
                if (peek == 123) {
                    StringBuilder var = new StringBuilder();
                    ch = is.read();
                    while (ch >= 0 && ch != 13 && ch != 10 && ch != 125) {
                        var.append((char)ch);
                        ch = is.read();
                    }
                    StringValue value = env.getIni(var.toString());
                    if (value != null) {
                        sb.append((Object)value);
                    }
                } else {
                    sb.append('$');
                    is.unread();
                }
            } else {
                if (ch == 34) {
                    StringValue result = env.createStringBuilder();
                    String value = sb.toString().trim();
                    result.append(IniParser.getIniConstant(env, value));
                    ch = is.read();
                    while (ch >= 0 && ch != 34) {
                        result.append((char)ch);
                        ch = is.read();
                    }
                    IniParser.skipToNewline(is);
                    return result;
                }
                sb.append((char)ch);
            }
            ch = is.read();
        }
        String value = sb.toString().trim();
        return IniParser.getIniConstant(env, value);
    }

    private static Value getIniConstant(Env env, String value) {
        if (value.equalsIgnoreCase("null")) {
            return env.getEmptyString();
        }
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes")) {
            return env.createString("1");
        }
        if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("no")) {
            return env.getEmptyString();
        }
        if (env.isDefined(value)) {
            return env.getConstant(value);
        }
        return env.createString(value);
    }

    private static boolean isValidIniKeyChar(int ch) {
        return ch > 0 && ch != 61 && ch != 59 && ch != 123 && ch != 125 && ch != 124 && ch != 38 && ch != 126 && ch != 33 && ch != 91 && ch != 40 && ch != 41 && ch != 34;
    }

    private static int skipWhitespaces(ReadStream is) throws IOException {
        int ch = is.read();
        while (Character.isWhitespace(ch)) {
            ch = is.read();
        }
        return ch;
    }

    private static int skipSpacesAndTabs(ReadStream is) throws IOException {
        int ch;
        while ((ch = is.read()) == 32 || ch == 9) {
        }
        return ch;
    }

    private static int skipToNewline(ReadStream is) throws IOException {
        int ch;
        while ((ch = is.read()) >= 0 && ch != 13 && ch != 10) {
        }
        return ch;
    }
}

