/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.gae;

import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.lib.gae.GaeUser;
import com.google.appengine.api.users.User;
import com.google.appengine.api.users.UserService;
import com.google.appengine.api.users.UserServiceFactory;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GaeUserService {
    private static final UserService USER_SERVICE = UserServiceFactory.getUserService();

    protected static UserService getUserService() {
        return USER_SERVICE;
    }

    public static String createLoginURL(String destinationUrl, @Optional String authDomain, @Optional String federatedIdentity, @Optional Set<String> attributesRequest) {
        return GaeUserService.getUserService().createLoginURL(destinationUrl, authDomain, federatedIdentity, attributesRequest);
    }

    public static String createLogoutURL(String destinationUrl, @Optional String authDomain) {
        return GaeUserService.getUserService().createLogoutURL(destinationUrl, authDomain);
    }

    public static GaeUser getCurrentUser() {
        User user = GaeUserService.getUserService().getCurrentUser();
        if (user == null) {
            return null;
        }
        return new GaeUser(user);
    }

    public static boolean isUserAdmin() {
        try {
            return GaeUserService.getUserService().isUserAdmin();
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    public static boolean isUserLoggedIn() {
        return GaeUserService.getUserService().isUserLoggedIn();
    }
}

