/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.i18n;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.lib.i18n.Decoder;
import com.caucho.quercus.lib.i18n.Encoder;
import com.caucho.quercus.lib.i18n.GenericDecoder;
import com.caucho.quercus.lib.i18n.Utf8Decoder;
import com.caucho.quercus.lib.i18n.Utf8Encoder;

public class UnicodeUtility {
    public static StringValue utf8Clean(Env env, StringValue str, String replacement, boolean isIgnore) {
        StringValue sb = str.createStringBuilder();
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char ch3;
            char ch2;
            char ch = str.charAt(i);
            if (ch <= '\u007f') {
                sb.append(ch);
                continue;
            }
            if ('\u00c2' <= ch && ch <= '\u00df') {
                if (i + 1 < len && '\u0080' <= (ch2 = str.charAt(i + 1)) && ch2 <= '\u00bf') {
                    ++i;
                    sb.append(ch);
                    sb.append(ch2);
                    continue;
                }
                if (isIgnore) continue;
                if (replacement != null) {
                    sb.append(replacement);
                    continue;
                }
                return sb;
            }
            if ('\u00e0' <= ch && ch <= '\u00ef') {
                if (i + 2 < len && '\u0080' <= (ch2 = str.charAt(i + 1)) && ch2 <= '\u00bf' && '\u0080' <= (ch3 = str.charAt(i + 2)) && ch3 <= '\u00bf') {
                    i += 2;
                    sb.append(ch);
                    sb.append(ch2);
                    sb.append(ch3);
                    continue;
                }
                if (isIgnore) continue;
                if (replacement != null) {
                    sb.append(replacement);
                    continue;
                }
                return sb;
            }
            if ('\u00f0' <= ch && ch <= '\u00f4') {
                char ch4;
                if (i + 3 < len && '\u0080' <= (ch2 = str.charAt(i + 1)) && ch2 <= '\u00bf' && '\u0080' <= (ch3 = str.charAt(i + 2)) && ch3 <= '\u00bf' && '\u0080' <= (ch4 = str.charAt(i + 3)) && ch4 <= '\u00bf') {
                    i += 3;
                    sb.append(ch);
                    sb.append(ch2);
                    sb.append(ch3);
                    sb.append(ch4);
                    continue;
                }
                if (isIgnore) continue;
                if (replacement != null) {
                    sb.append(replacement);
                    continue;
                }
                return sb;
            }
            if (isIgnore) continue;
            if (replacement != null) {
                sb.append(replacement);
                continue;
            }
            return sb;
        }
        return sb;
    }

    public static CharSequence decode(Env env, StringValue str, String charset) {
        return UnicodeUtility.decode(env, str, charset, null, false);
    }

    public static CharSequence decode(Env env, StringValue str, String charset, String replacement, boolean isIgnoreErrors) {
        Decoder decoder = Decoder.create(charset);
        decoder.setReplacement(replacement);
        decoder.setIgnoreErrors(isIgnoreErrors);
        return decoder.decode(env, str);
    }

    public static StringValue encode(Env env, CharSequence str, String charset) {
        return UnicodeUtility.encode(env, str, charset, null, false);
    }

    public static StringValue encode(Env env, CharSequence str, String charset, String replacement, boolean isIgnoreErrors) {
        Encoder encoder = Encoder.create(charset);
        encoder.setReplacement(replacement);
        encoder.setIgnoreErrors(isIgnoreErrors);
        StringValue sb = env.createBinaryBuilder();
        return encoder.encode(sb, str);
    }

    public static StringValue decodeEncode(Env env, StringValue str, String inCharset, String outCharset, String replacement, boolean isIgnoreErrors) {
        boolean isStartUtf8 = false;
        boolean isEndUtf8 = false;
        if (inCharset.equalsIgnoreCase("utf8") || inCharset.equalsIgnoreCase("utf-8")) {
            isStartUtf8 = true;
        }
        if (outCharset.equalsIgnoreCase("utf8") || outCharset.equalsIgnoreCase("utf-8")) {
            isEndUtf8 = true;
        }
        if (isStartUtf8 && isEndUtf8) {
            return UnicodeUtility.utf8Clean(env, str, null, isIgnoreErrors);
        }
        Decoder decoder = isStartUtf8 ? new Utf8Decoder(inCharset) : new GenericDecoder(inCharset);
        decoder.setIgnoreErrors(isIgnoreErrors);
        CharSequence unicodeStr = decoder.decode(env, str);
        Encoder encoder = isEndUtf8 ? new Utf8Encoder() : Encoder.create(outCharset);
        encoder.setIgnoreErrors(isIgnoreErrors);
        StringValue sb = env.createBinaryBuilder();
        return encoder.encode(sb, unicodeStr);
    }
}

