/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.simplexml;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.Value;

public abstract class IteratorIndex {
    public static IteratorIndex create(int index) {
        return new IntIteratorIndex(index);
    }

    public static IteratorIndex create(String index) {
        return new StringIteratorIndex(index);
    }

    public abstract Value toValue(Env var1, String var2);

    public static class StringIteratorIndex
    extends IteratorIndex {
        private String _index;

        public StringIteratorIndex(String index) {
            this._index = index;
        }

        public Value toValue(Env env, String encoding) {
            return env.createString(this._index);
        }
    }

    public static class IntIteratorIndex
    extends IteratorIndex {
        private int _index;

        public IntIteratorIndex(int index) {
            this._index = index;
        }

        public Value toValue(Env env, String encoding) {
            return LongValue.create(this._index);
        }
    }
}

