/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.simplexml;

import com.caucho.util.L10N;
import java.io.StringReader;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DefaultHandler2;

public class SimpleHandler
extends DefaultHandler2 {
    private static final Logger log = Logger.getLogger(SimpleHandler.class.getName());
    private static final L10N L = new L10N(SimpleHandler.class);
    private HashMap<String, String> _entityMap = new HashMap();
    private StringBuilder _sb = new StringBuilder();
    private final DOMImplementation _impl;
    private Document _doc;
    private Node _node;
    private String _entityName;

    public SimpleHandler(DOMImplementation impl) {
        this._impl = impl;
    }

    public Document getDocument() {
        return this._doc;
    }

    public void startDocument() {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, this.getClass().getSimpleName() + ".startDocument0");
        }
        this._doc = this._impl.createDocument(null, null, null);
        this._node = this._doc;
    }

    public void endDocument() {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, this.getClass().getSimpleName() + ".endDocument0");
        }
    }

    public void processingInstruction(String target, String data) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, this.getClass().getSimpleName() + ".processingInstruction0: " + target + " . " + data);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, this.getClass().getSimpleName() + ".characters0: " + new String(ch, start, length));
        }
        if (this._entityName != null) {
            String entityName = this._entityName;
            this.appendText();
            EntityReference ref = this.getDocument().createEntityReference(entityName);
            this._node.appendChild(ref);
        } else {
            this._sb.append(ch, start, length);
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        this.appendText();
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, this.getClass().getSimpleName() + ".startElement0: " + uri + " . " + localName + " . " + qName);
        }
        Element e = this.getDocument().createElementNS(uri, qName);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, this.getClass().getSimpleName() + ".startElement1: " + e.getNamespaceURI());
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            String attrName = attributes.getQName(i);
            String attrValue = attributes.getValue(i);
            e.setAttribute(attrName, attrValue);
            if (!log.isLoggable(Level.FINE)) continue;
            log.log(Level.FINE, this.getClass().getSimpleName() + ".startElement2: " + attrName + " . " + attrValue);
        }
        this._node.appendChild(e);
        this._node = e;
    }

    public void endElement(String uri, String localName, String qName) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, this.getClass().getSimpleName() + ".endElement0: " + uri + " . " + localName + " . " + qName);
        }
        this.appendText();
        this._node = this._node.getParentNode();
    }

    private void appendText() {
        this._entityName = null;
        if (this._sb.length() > 0) {
            String str = this._sb.toString();
            this._sb.setLength(0);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "SimpleHandler.appendText0: " + str + " . " + str.length());
            }
            Text text = this.getDocument().createTextNode(str);
            this._node.appendChild(text);
        }
    }

    public void elementDecl(String name, String model) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, this.getClass().getSimpleName() + ".elementDecl0: " + name + " . " + model);
        }
    }

    public void attributeDecl(String eName, String aName, String type, String mode, String value) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, this.getClass().getSimpleName() + ".attributeDecl0: " + eName + " . " + aName + " . " + type + " . " + mode + " . " + value);
        }
        ((Element)this._node).setAttribute(aName, value);
    }

    public void notationDecl(String name, String publicId, String systemId) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, this.getClass().getSimpleName() + ".notationDecl0: " + name + " . " + publicId + " . " + systemId);
        }
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, this.getClass().getSimpleName() + ".unparsedEntityDecl0: " + name + " . " + publicId + " . " + systemId + " . " + notationName);
        }
    }

    public void internalEntityDecl(String name, String value) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, this.getClass().getSimpleName() + ".internalEntityDecl0: " + name + " . " + value);
        }
        this._entityMap.put(name, value);
    }

    public void externalEntityDecl(String name, String publicId, String systemId) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, this.getClass().getSimpleName() + ".externalEntityDecl0: " + name + " . " + publicId + " . " + systemId);
        }
    }

    public void comment(char[] ch, int start, int length) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, this.getClass().getSimpleName() + ".comment0: " + new String(ch, start, length));
        }
        this.appendText();
        String str = new String(ch, start, length);
        Comment comment = this.getDocument().createComment(str);
        this._node.appendChild(comment);
    }

    public void startCDATA() {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, this.getClass().getSimpleName() + ".startCDATA0");
        }
    }

    public void endCDATA() {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, this.getClass().getSimpleName() + ".endCDATA0");
        }
    }

    public void startDTD(String name, String publicId, String systemId) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, this.getClass().getSimpleName() + ".startDTD0: " + name + " . " + publicId + " . " + systemId);
        }
        DocumentType type = this._impl.createDocumentType(name, publicId, systemId);
        this.getDocument().appendChild(type);
    }

    public void endDTD() {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, this.getClass().getSimpleName() + ".endDTD0");
        }
    }

    public void startEntity(String name) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, this.getClass().getSimpleName() + ".startEntity0: " + name);
        }
        this._entityName = name;
    }

    public void endEntity(String name) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, this.getClass().getSimpleName() + ".endEntity0: " + name);
        }
    }

    public InputSource getExternalSubset(String name, String baseURI) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, this.getClass().getSimpleName() + ".getExternalSubset0: " + name + " . " + baseURI);
        }
        return null;
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, this.getClass().getSimpleName() + ".resolveEntity0: " + publicId + " . " + systemId);
        }
        InputSource is = new InputSource(new StringReader(""));
        return is;
    }

    public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, this.getClass().getSimpleName() + ".resolveEntity1: " + name + " . " + publicId + " . " + baseURI + " . " + systemId);
        }
        InputSource is = new InputSource(new StringReader(""));
        return is;
    }

    public void skippedEntity(String name) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, this.getClass().getSimpleName() + ".skippedEntity0: " + name);
        }
        EntityReference ref = this.getDocument().createEntityReference(name);
        this._node.appendChild(ref);
    }

    public void warning(SAXParseException e) throws SAXException {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, this.getClass().getSimpleName() + ".warning0: " + e);
        }
    }

    public void error(SAXParseException e) throws SAXException {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, this.getClass().getSimpleName() + ".error0: " + e);
        }
    }

    public void fatalError(SAXParseException e) throws SAXException {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, this.getClass().getSimpleName() + ".fatalError0: " + e);
        }
    }
}

