/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.spl;

import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.lib.spl.FilesystemIterator;
import com.caucho.quercus.lib.spl.RecursiveIterator;
import com.caucho.quercus.lib.spl.SplFileInfo;
import com.caucho.vfs.Path;

public class RecursiveDirectoryIterator
extends FilesystemIterator
implements RecursiveIterator {
    public RecursiveDirectoryIterator(Env env, StringValue fileName, @Optional(value="-1") int flags) {
        super(env, fileName, flags);
    }

    protected RecursiveDirectoryIterator(Path parent, Path path, String fileName, int flags) {
        super(parent, path, fileName, flags);
    }

    public boolean hasChildren(Env env) {
        SplFileInfo current = this.getCurrent(env);
        if (current == null) {
            return false;
        }
        String fileName = current.getFilename(env);
        if (".".equals(fileName) || "..".equals(fileName)) {
            return false;
        }
        return current.isDir(env);
    }

    public RecursiveDirectoryIterator getChildren(Env env) {
        SplFileInfo info = this.getCurrent(env);
        return new RecursiveDirectoryIterator(info.getRawParent(), info.getRawPath(), info.getFilename(env), this.getFlags());
    }
}

