/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.spl;

import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.ConstStringValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.spl.Iterator;
import com.caucho.quercus.lib.spl.OuterIterator;
import com.caucho.quercus.lib.spl.RecursiveIterator;
import com.caucho.quercus.lib.spl.Traversable;
import java.util.ArrayList;

public class RecursiveIteratorIterator
implements OuterIterator,
Traversable,
Iterator {
    public static final int LEAVES_ONLY = 0;
    public static final int SELF_FIRST = 1;
    public static final int CHILD_FIRST = 2;
    public static final int CATCH_GET_CHILD = 16;
    private final ArrayList<RecursiveIterator> _iterStack;
    private final int _mode;

    public RecursiveIteratorIterator(Env env, Value value, @Optional int mode, @Optional int flags) {
        RecursiveIterator iter = RecursiveIteratorProxy.create(value);
        this._iterStack = new ArrayList();
        this._iterStack.add(iter);
        this._mode = mode;
    }

    public RecursiveIterator getInnerIterator() {
        int i = this._iterStack.size() - 1;
        return this._iterStack.get(i);
    }

    public boolean valid(Env env) {
        return this.getInnerIterator().valid(env);
    }

    public Value current(Env env) {
        return this.getInnerIterator().current(env);
    }

    public Value key(Env env) {
        return this.getInnerIterator().key(env);
    }

    public void next(Env env) {
        RecursiveIterator currentIter = this.getInnerIterator();
        currentIter.next(env);
        if (!currentIter.valid(env) && this._iterStack.size() > 1) {
            this._iterStack.remove(this._iterStack.size() - 1);
            this.next(env);
            return;
        }
        if (currentIter.hasChildren(env)) {
            RecursiveIterator recursiveIter = currentIter.getChildren(env);
            this._iterStack.add(recursiveIter);
        }
    }

    public void rewind(Env env) {
        for (int i = this._iterStack.size() - 1; i > 0; --i) {
            this._iterStack.remove(i);
        }
        this._iterStack.get(0).rewind(env);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._iterStack + "]";
    }

    static class RecursiveIteratorProxy
    implements RecursiveIterator {
        private final Value _obj;
        private static final StringValue HAS_CHILDREN = new ConstStringValue("hasChildren");
        private static final StringValue GET_CHILDREN = new ConstStringValue("getChildren");
        private static final StringValue VALID = new ConstStringValue("valid");
        private static final StringValue CURRENT = new ConstStringValue("current");
        private static final StringValue KEY = new ConstStringValue("key");
        private static final StringValue NEXT = new ConstStringValue("next");
        private static final StringValue REWIND = new ConstStringValue("rewind");

        RecursiveIteratorProxy(Value obj) {
            this._obj = obj;
        }

        public static RecursiveIterator create(Value value) {
            Object obj = value.toJavaObject();
            if (obj instanceof RecursiveIterator) {
                return (RecursiveIterator)obj;
            }
            return new RecursiveIteratorProxy(value);
        }

        public boolean hasChildren(Env env) {
            return this._obj.callMethod(env, HAS_CHILDREN).toBoolean();
        }

        public RecursiveIterator getChildren(Env env) {
            Value result = this._obj.callMethod(env, GET_CHILDREN);
            return RecursiveIteratorProxy.create(result);
        }

        public boolean valid(Env env) {
            return this._obj.callMethod(env, VALID).toBoolean();
        }

        public Value current(Env env) {
            return this._obj.callMethod(env, CURRENT);
        }

        public Value key(Env env) {
            return this._obj.callMethod(env, KEY);
        }

        public void next(Env env) {
            this._obj.callMethod(env, NEXT);
        }

        public void rewind(Env env) {
            this._obj.callMethod(env, REWIND);
        }
    }
}

