/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.string;

import com.caucho.quercus.QuercusException;
import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.annotation.Expect;
import com.caucho.quercus.annotation.NotNull;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.Reference;
import com.caucho.quercus.annotation.UsesSymbolTable;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.DefaultValue;
import com.caucho.quercus.env.DoubleValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LocaleInfo;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.QuercusLocale;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnexpectedValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.lib.file.BinaryOutput;
import com.caucho.quercus.lib.file.FileModule;
import com.caucho.quercus.lib.string.Crypt;
import com.caucho.quercus.lib.string.StringUtility;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.util.CharBuffer;
import com.caucho.util.FreeList;
import com.caucho.util.IntSet;
import com.caucho.util.L10N;
import com.caucho.util.RandomUtil;
import com.caucho.vfs.ByteToChar;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.TempBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Currency;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringModule
extends AbstractQuercusModule {
    private static final Logger log = Logger.getLogger(StringModule.class.getName());
    private static final L10N L = new L10N(StringModule.class);
    public static final int CRYPT_SALT_LENGTH = 2;
    public static final int CRYPT_STD_DES = 0;
    public static final int CRYPT_EXT_DES = 0;
    public static final int CRYPT_MD5 = 0;
    public static final int CRYPT_BLOWFISH = 0;
    public static final int CHAR_MAX = 1;
    public static final int LC_CTYPE = 1;
    public static final int LC_NUMERIC = 2;
    public static final int LC_TIME = 3;
    public static final int LC_COLLATE = 4;
    public static final int LC_MONETARY = 5;
    public static final int LC_ALL = 6;
    public static final int LC_MESSAGES = 7;
    public static final int STR_PAD_LEFT = 1;
    public static final int STR_PAD_RIGHT = 0;
    public static final int STR_PAD_BOTH = 2;
    private static final DecimalFormatSymbols DEFAULT_DECIMAL_FORMAT_SYMBOLS;
    private static final BigInteger BIG_TEN;
    private static final BigInteger BIG_2_64;
    private static final FreeList<MessageDigest> _md5FreeList;
    private static final boolean[] TRIM_WHITESPACE;
    private static final char[] SOUNDEX_VALUES;

    public static StringValue addcslashes(Env env, StringValue source, String characters) {
        if (characters == null) {
            characters = "";
        }
        boolean[] bitmap = StringModule.parseCharsetBitmap(env, characters);
        int length = source.length();
        StringValue sb = source.createStringBuilder(length * 5 / 4);
        block9: for (int i = 0; i < length; ++i) {
            char ch = source.charAt(i);
            if (ch >= '\u0100' || !bitmap[ch]) {
                sb.append(ch);
                continue;
            }
            switch (ch) {
                case '\u0007': {
                    sb.append("\\a");
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\u000b': {
                    sb.append("\\v");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    if (ch < ' ' || ch >= '\u007f') {
                        sb.append("\\");
                        sb.append((char)(48 + (ch >> 6 & 7)));
                        sb.append((char)(48 + (ch >> 3 & 7)));
                        sb.append((char)(48 + (ch & 7)));
                        continue block9;
                    }
                    sb.append("\\");
                    sb.append(ch);
                }
            }
        }
        return sb;
    }

    private static boolean[] parseCharsetBitmap(Env env, String charset) {
        boolean[] bitmap = new boolean[256];
        int length = charset.length();
        for (int i = 0; i < length; ++i) {
            char ch = charset.charAt(i);
            if (ch >= '\u0100') continue;
            bitmap[ch] = true;
            if (length <= i + 3 || charset.charAt(i + 1) != '.' || charset.charAt(i + 2) != '.') continue;
            char last = charset.charAt(i + 3);
            if (last < ch) {
                env.warning(L.l("character set range is invalid: {0}..{1}", ch, (int)last));
                continue;
            }
            i += 3;
            while (ch <= last) {
                bitmap[ch] = true;
                ch = (char)(ch + '\u0001');
            }
        }
        return bitmap;
    }

    public static StringValue addslashes(StringValue source) {
        StringValue sb = source.createStringBuilder(source.length() * 5 / 4);
        int length = source.length();
        block6: for (int i = 0; i < length; ++i) {
            char ch = source.charAt(i);
            switch (ch) {
                case '\u0000': {
                    sb.append("\\0");
                    continue block6;
                }
                case '\'': {
                    sb.append("\\'");
                    continue block6;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block6;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block6;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb;
    }

    public static StringValue bin2hex(Env env, InputStream is) {
        try {
            int ch;
            StringValue sb = env.createUnicodeBuilder();
            while ((ch = is.read()) >= 0) {
                int d = ch >> 4 & 0xF;
                if (d < 10) {
                    sb.append((char)(d + 48));
                } else {
                    sb.append((char)(d + 97 - 10));
                }
                d = ch & 0xF;
                if (d < 10) {
                    sb.append((char)(d + 48));
                    continue;
                }
                sb.append((char)(d + 97 - 10));
            }
            return sb;
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public static StringValue chop(Env env, StringValue str, @Optional String charset) {
        return StringModule.rtrim(env, str, charset);
    }

    public static StringValue chr(Env env, long value) {
        if (!env.isUnicodeSemantics()) {
            value &= 0xFFL;
        }
        StringValue sb = env.createUnicodeBuilder();
        sb.append((char)value);
        return sb;
    }

    public static String chunk_split(String body, @Optional(value="76") int chunkLen, @Optional(value="\"\\r\\n\"") String end) {
        if (body == null) {
            body = "";
        }
        if (end == null) {
            end = "";
        }
        if (chunkLen < 1) {
            throw new IllegalArgumentException(L.l("bad value {0}", chunkLen));
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i + chunkLen <= body.length()) {
            sb.append(body.substring(i, i + chunkLen));
            sb.append(end);
            i += chunkLen;
        }
        if (i < body.length()) {
            sb.append(body.substring(i));
            sb.append(end);
        }
        return sb.toString();
    }

    public static String convert_cyr_string(Env env, String str, String from, String to) {
        env.stub("convert_cyr_string");
        return str;
    }

    public static Value convert_uudecode(Env env, StringValue source) {
        try {
            char ch1;
            int length = source.length();
            if (length == 0) {
                return BooleanValue.FALSE;
            }
            ByteToChar byteToChar = env.getByteToChar();
            int i = 0;
            while (i < length && (ch1 = source.charAt(i++)) != '`' && ch1 != ' ') {
                if (ch1 < ' ' || '_' < ch1) continue;
                for (int sublen = ch1 - 32; sublen > 0; sublen -= 3) {
                    int code = (source.charAt(i++) - 32 & 0x3F) << 18;
                    code += (source.charAt(i++) - 32 & 0x3F) << 12;
                    code += (source.charAt(i++) - 32 & 0x3F) << 6;
                    byteToChar.addByte((code += source.charAt(i++) - 32 & 0x3F) >> 16);
                    if (sublen > 1) {
                        byteToChar.addByte(code >> 8);
                    }
                    if (sublen <= 2) continue;
                    byteToChar.addByte(code);
                }
            }
            return env.createString(byteToChar.getConvertedString());
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public static Value convert_uuencode(StringValue source) {
        if (source.length() == 0) {
            return BooleanValue.FALSE;
        }
        StringValue result = source.createStringBuilder();
        int i = 0;
        int length = source.length();
        while (i < length) {
            int sublen = length - i;
            if (45 < sublen) {
                sublen = 45;
            }
            result.append((char)(sublen + 32));
            int end = i + sublen;
            while (i < end) {
                int code = source.charAt(i++) << 16;
                if (i < length) {
                    code += source.charAt(i++) << 8;
                }
                if (i < length) {
                    code += source.charAt(i++);
                }
                result.append(StringModule.toUUChar(code >> 18 & 0x3F));
                result.append(StringModule.toUUChar(code >> 12 & 0x3F));
                result.append(StringModule.toUUChar(code >> 6 & 0x3F));
                result.append(StringModule.toUUChar(code & 0x3F));
            }
            result.append('\n');
        }
        result.append('`');
        result.append('\n');
        return result;
    }

    public static Value count_chars(StringValue data, @Optional(value="0") int mode) {
        int[] count = new int[256];
        int length = data.length();
        for (int i = 0; i < length; ++i) {
            int n = data.charAt(i) & 0xFF;
            count[n] = count[n] + 1;
        }
        switch (mode) {
            case 0: {
                ArrayValueImpl result = new ArrayValueImpl();
                for (int i = 0; i < count.length; ++i) {
                    result.put(LongValue.create(i), LongValue.create(count[i]));
                }
                return result;
            }
            case 1: {
                ArrayValueImpl result = new ArrayValueImpl();
                for (int i = 0; i < count.length; ++i) {
                    if (count[i] <= 0) continue;
                    result.put(LongValue.create(i), LongValue.create(count[i]));
                }
                return result;
            }
            case 2: {
                ArrayValueImpl result = new ArrayValueImpl();
                for (int i = 0; i < count.length; ++i) {
                    if (count[i] != 0) continue;
                    result.put(LongValue.create(i), LongValue.create(count[i]));
                }
                return result;
            }
            case 3: {
                StringValue sb = data.createStringBuilder();
                for (int i = 0; i < count.length; ++i) {
                    if (count[i] <= 0) continue;
                    sb.append((char)i);
                }
                return sb;
            }
            case 4: {
                StringValue sb = data.createStringBuilder();
                for (int i = 0; i < count.length; ++i) {
                    if (count[i] != 0) continue;
                    sb.append((char)i);
                }
                return sb;
            }
        }
        return BooleanValue.FALSE;
    }

    public static long crc32(StringValue str) {
        return str.getCrc32Value();
    }

    public static String crypt(String string, @Optional String salt) {
        if (string == null) {
            string = "";
        }
        if (salt == null || salt.equals("")) {
            salt = "" + Crypt.resultToChar(RandomUtil.nextInt(64)) + Crypt.resultToChar(RandomUtil.nextInt(64));
        }
        return Crypt.crypt(string, salt);
    }

    public static Value explode(Env env, StringValue separator, StringValue string, @Optional(value="0x7fffffff") long limit) {
        if (separator.length() == 0) {
            env.warning(L.l("Delimiter is empty"));
            return BooleanValue.FALSE;
        }
        int head = 0;
        ArrayValueImpl array = new ArrayValueImpl();
        int separatorLength = separator.length();
        int stringLength = string.length();
        long ulimit = limit >= 0L ? limit : Integer.MAX_VALUE;
        for (int i = 0; i < stringLength && ulimit > (long)(((ArrayValue)array).getSize() + 1); ++i) {
            if (!string.regionMatches(i, separator, 0, separatorLength)) continue;
            StringValue chunk = string.substring(head, i);
            array.append(chunk);
            head = i + separatorLength;
            i = head - 1;
        }
        StringValue chunk = string.substring(head);
        array.append(chunk);
        while (((ArrayValue)array).getSize() > 0 && limit++ < 0L) {
            ((ArrayValue)array).pop(env);
        }
        return array;
    }

    public static Value fprintf(Env env, @NotNull BinaryOutput os, StringValue format, Value[] args) {
        Value value = StringModule.sprintf(env, format, args);
        return FileModule.fwrite(env, os, value.toInputStream(), Integer.MAX_VALUE);
    }

    public static StringValue hex2bin(Env env, StringValue s) {
        StringValue sb = env.createBinaryBuilder();
        int len = s.length();
        int i = 0;
        while (i + 1 < len) {
            int d1 = StringModule.hexDigit(s.charAt(i));
            int d2 = StringModule.hexDigit(s.charAt(i + 1));
            int d = d1 * 16 + d2;
            sb.append((char)d);
            i += 2;
        }
        return sb;
    }

    private static int hexDigit(int c) {
        if (48 <= c && c <= 57) {
            return c - 48;
        }
        if (97 <= c && c <= 102) {
            return c - 97 + 10;
        }
        if (65 <= c && c <= 70) {
            return c - 65 + 10;
        }
        return 0;
    }

    public static Value implode(Env env, Value glueV, @Optional Value piecesV) {
        StringValue glue;
        ArrayValue pieces;
        if (piecesV.isArray() && glueV.isArray() || glueV.isArray()) {
            pieces = glueV.toArrayValue(env);
            glue = piecesV.toStringValue(env);
        } else if (piecesV.isArray()) {
            pieces = piecesV.toArrayValue(env);
            glue = glueV.toStringValue(env);
        } else {
            env.warning(L.l("neither argument to implode is an array: {0}, {1}", (Object)glueV.getClass().getName(), (Object)piecesV.getClass().getName()));
            return NullValue.NULL;
        }
        StringValue sb = glue.createStringBuilder();
        boolean isFirst = true;
        Iterator<Value> iter = pieces.getValueIterator(env);
        while (iter.hasNext()) {
            if (!isFirst) {
                sb = sb.append(glue);
            }
            isFirst = false;
            sb = sb.append(iter.next());
        }
        return sb;
    }

    public static Value join(Env env, Value glueV, Value piecesV) {
        return StringModule.implode(env, glueV, piecesV);
    }

    public static ArrayValue localeconv(Env env) {
        ArrayValueImpl array = new ArrayValueImpl();
        QuercusLocale money = env.getLocaleInfo().getMonetary();
        Locale locale = money.getLocale();
        DecimalFormatSymbols decimal = new DecimalFormatSymbols(locale);
        Currency currency = NumberFormat.getInstance(locale).getCurrency();
        array.put(env.createString("decimal_point"), env.createString(decimal.getDecimalSeparator()));
        array.put(env.createString("thousands_sep"), env.createString(decimal.getGroupingSeparator()));
        array.put(env.createString("int_curr_symbol"), env.createString(decimal.getInternationalCurrencySymbol()));
        array.put(env.createString("currency_symbol"), env.createString(decimal.getCurrencySymbol()));
        array.put(env.createString("mon_decimal_point"), env.createString(decimal.getMonetaryDecimalSeparator()));
        array.put(env.createString("mon_thousands_sep"), env.createString(decimal.getGroupingSeparator()));
        array.put(env.createString("positive_sign"), env.getEmptyString());
        array.put(env.createString("negative_sign"), env.createString(decimal.getMinusSign()));
        array.put(env.createString("int_frac_digits"), LongValue.create(currency.getDefaultFractionDigits()));
        array.put(env.createString("frac_digits"), LongValue.create(currency.getDefaultFractionDigits()));
        return array;
    }

    public static StringValue ltrim(Env env, StringValue string, @Optional String characters) {
        if (characters == null) {
            characters = "";
        }
        boolean[] trim = characters.equals("") ? TRIM_WHITESPACE : StringModule.parseCharsetBitmap(env, characters);
        for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            if (ch < '\u0100' && trim[ch]) continue;
            if (i == 0) {
                return string;
            }
            return string.substring(i);
        }
        return env.getEmptyString();
    }

    public static Value md5(Env env, InputStream is, @Optional boolean rawOutput) {
        TempBuffer tempBuffer = TempBuffer.allocate();
        try {
            int len;
            MessageDigest md = _md5FreeList.allocate();
            if (md == null) {
                md = MessageDigest.getInstance("MD5");
            }
            md.reset();
            byte[] buffer = tempBuffer.getBuffer();
            while ((len = is.read(buffer, 0, buffer.length)) >= 0) {
                md.update(buffer, 0, len);
            }
            byte[] digest = md.digest();
            _md5FreeList.free(md);
            Value value = StringModule.hashToValue(env, digest, rawOutput);
            return value;
        }
        catch (Exception e) {
            throw new QuercusModuleException(e);
        }
        finally {
            TempBuffer.free(tempBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Value md5_file(Env env, Path source, @Optional boolean rawOutput) {
        TempBuffer tempBuffer = TempBuffer.allocate();
        try {
            int len;
            MessageDigest md = MessageDigest.getInstance("MD5");
            ReadStream is = null;
            is = source.openRead();
            byte[] buffer = tempBuffer.getBuffer();
            while ((len = ((InputStream)is).read(buffer, 0, buffer.length)) >= 0) {
                md.update(buffer, 0, len);
            }
            byte[] digest = md.digest();
            Value value = StringModule.hashToValue(env, digest, rawOutput);
            try {
                if (is == null) return value;
                ((InputStream)is).close();
                return value;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return value;
            catch (IOException e) {
                log.log(Level.FINE, e.toString(), e);
                BooleanValue booleanValue = BooleanValue.FALSE;
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                TempBuffer.free(tempBuffer);
                return booleanValue;
                {
                    catch (Throwable throwable) {
                        try {
                            try {
                                if (is == null) throw throwable;
                                ((InputStream)is).close();
                                throw throwable;
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                        catch (Exception e2) {
                            throw new QuercusModuleException(e2);
                        }
                    }
                }
            }
        }
        finally {
            TempBuffer.free(tempBuffer);
        }
    }

    private static StringValue digestToString(Env env, byte[] digest) {
        StringValue sb = env.createUnicodeBuilder();
        for (int i = 0; i < digest.length; ++i) {
            int d1 = digest[i] >> 4 & 0xF;
            int d2 = digest[i] & 0xF;
            sb.append(StringModule.toHexChar(d1));
            sb.append(StringModule.toHexChar(d2));
        }
        return sb;
    }

    public static String metaphone(String string) {
        int index;
        if (string == null) {
            string = "";
        }
        int length = string.length();
        char ch = '\u0000';
        for (index = 0; index < length && ('A' > (ch = StringModule.toUpperCase(string.charAt(index))) || ch > 'Z'); ++index) {
        }
        if (index == length) {
            return "";
        }
        int lastIndex = length - 1;
        StringBuilder result = new StringBuilder(length);
        char nextCh = index < lastIndex ? StringModule.toUpperCase(string.charAt(index + 1)) : (char)'\u0000';
        block0 : switch (ch) {
            case 'A': {
                if (nextCh == 'E') {
                    result.append('E');
                    index += 2;
                    break;
                }
                result.append('A');
                ++index;
                break;
            }
            case 'E': 
            case 'I': 
            case 'O': 
            case 'U': {
                result.append(ch);
                ++index;
                break;
            }
            case 'G': 
            case 'K': 
            case 'P': {
                if (nextCh != 'N') break;
                result.append('N');
                index += 2;
                break;
            }
            case 'W': {
                if (nextCh == 'H' || nextCh == 'R') {
                    result.append(nextCh);
                    index += 2;
                    break;
                }
                switch (nextCh) {
                    case 'A': 
                    case 'E': 
                    case 'I': 
                    case 'O': 
                    case 'U': {
                        result.append('W');
                        index += 2;
                        break block0;
                    }
                }
                break;
            }
            case 'X': {
                result.append('S');
                ++index;
                break;
            }
        }
        while (index < length) {
            char prevCh = index > 0 ? StringModule.toUpperCase(string.charAt(index - 1)) : (char)'\u0000';
            ch = StringModule.toUpperCase(string.charAt(index));
            if (ch >= 'A' && ch <= 'Z' && (ch != prevCh || ch == 'C')) {
                nextCh = index + 1 < length ? StringModule.toUpperCase(string.charAt(index + 1)) : (char)'\u0000';
                char nextnextCh = index + 2 < length ? StringModule.toUpperCase(string.charAt(index + 2)) : (char)'\u0000';
                block10 : switch (ch) {
                    case 'B': {
                        if (prevCh == 'M') break;
                        result.append('B');
                        break;
                    }
                    case 'C': {
                        switch (nextCh) {
                            case 'E': 
                            case 'I': 
                            case 'Y': {
                                if (nextCh == 'I' && nextnextCh == 'A') {
                                    result.append('X');
                                    break;
                                }
                                if (prevCh == 'S') break;
                                result.append('S');
                                break;
                            }
                            default: {
                                if (nextCh == 'H') {
                                    result.append('X');
                                    ++index;
                                    break;
                                }
                                result.append('K');
                                break;
                            }
                        }
                        break;
                    }
                    case 'D': {
                        if (nextCh == 'G') {
                            switch (nextnextCh) {
                                case 'E': 
                                case 'I': 
                                case 'Y': {
                                    result.append('J');
                                    ++index;
                                    break block10;
                                }
                            }
                            result.append('T');
                            break;
                        }
                        result.append('T');
                        break;
                    }
                    case 'G': {
                        if (nextCh == 'H') {
                            boolean isSilent = false;
                            if (index - 3 >= 0) {
                                char prev3Ch = StringModule.toUpperCase(string.charAt(index - 3));
                                switch (prev3Ch) {
                                    case 'B': 
                                    case 'D': 
                                    case 'H': {
                                        isSilent = true;
                                        break;
                                    }
                                }
                            }
                            if (!isSilent && index - 4 >= 0) {
                                char prev4Ch = StringModule.toUpperCase(string.charAt(index - 4));
                                boolean bl = isSilent = prev4Ch == 'H';
                            }
                            if (isSilent) break;
                            result.append('F');
                            ++index;
                            break;
                        }
                        if (nextCh == 'N') {
                            char nextnextnextCh = index + 3 < length ? StringModule.toUpperCase(string.charAt(index + 3)) : (char)'\u0000';
                            if (nextnextCh < 'A' || nextnextCh > 'Z' || nextnextCh == 'E' && nextnextnextCh == 'D') break;
                            result.append('K');
                            break;
                        }
                        if (prevCh == 'G') {
                            result.append('K');
                            break;
                        }
                        switch (nextCh) {
                            case 'E': 
                            case 'I': 
                            case 'Y': {
                                result.append('J');
                                break block10;
                            }
                        }
                        result.append('K');
                        break;
                    }
                    case 'H': 
                    case 'W': 
                    case 'Y': {
                        switch (nextCh) {
                            case 'A': 
                            case 'E': 
                            case 'I': 
                            case 'O': 
                            case 'U': {
                                if (ch == 'H') {
                                    switch (prevCh) {
                                        case 'C': 
                                        case 'G': 
                                        case 'P': 
                                        case 'S': 
                                        case 'T': {
                                            break block10;
                                        }
                                    }
                                    result.append('H');
                                    break block10;
                                }
                                result.append(ch);
                                break block10;
                            }
                        }
                        break;
                    }
                    case 'K': {
                        if (prevCh == 'C') break;
                        result.append('K');
                        break;
                    }
                    case 'P': {
                        if (nextCh == 'H') {
                            result.append('F');
                            break;
                        }
                        result.append('P');
                        break;
                    }
                    case 'Q': {
                        result.append('K');
                        break;
                    }
                    case 'S': {
                        if (nextCh == 'I' && (nextnextCh == 'O' || nextnextCh == 'A')) {
                            result.append('X');
                            break;
                        }
                        if (nextCh == 'H') {
                            result.append('X');
                            ++index;
                            break;
                        }
                        result.append('S');
                        break;
                    }
                    case 'T': {
                        if (nextCh == 'I' && (nextnextCh == 'O' || nextnextCh == 'A')) {
                            result.append('X');
                            break;
                        }
                        if (nextCh == 'H') {
                            result.append('0');
                            ++index;
                            break;
                        }
                        result.append('T');
                        break;
                    }
                    case 'V': {
                        result.append('F');
                        break;
                    }
                    case 'X': {
                        result.append('K');
                        result.append('S');
                        break;
                    }
                    case 'Z': {
                        result.append('S');
                        break;
                    }
                    case 'F': 
                    case 'J': 
                    case 'L': 
                    case 'M': 
                    case 'N': 
                    case 'R': {
                        result.append(ch);
                        break;
                    }
                }
            }
            ++index;
        }
        return result.toString();
    }

    public static String money_format(Env env, String format, double value) {
        QuercusLocale monetary = env.getLocaleInfo().getMonetary();
        Locale locale = monetary.getLocale();
        return NumberFormat.getCurrencyInstance(locale).format(value);
    }

    public static String number_format(Env env, double value, @Optional int decimals, @Optional Value pointValue, @Optional Value groupValue) {
        DecimalFormatSymbols decimalFormatSymbols;
        String pattern;
        boolean isGroupDefault = groupValue instanceof DefaultValue;
        boolean isPointDefault = pointValue instanceof DefaultValue;
        if (!isPointDefault && isGroupDefault) {
            env.warning(L.l("wrong parameter count"));
            return null;
        }
        char point = '.';
        if (!pointValue.isNull()) {
            String pointString = pointValue.toString();
            point = pointString.length() == 0 ? (char)'\u0000' : (char)pointString.charAt(0);
        }
        char group = ',';
        if (!groupValue.isNull()) {
            String groupString = groupValue.toString();
            char c = group = groupString.length() == 0 ? (char)'\u0000' : (char)groupString.charAt(0);
        }
        if (decimals > 0) {
            StringBuilder patternBuilder = new StringBuilder(6 + decimals);
            patternBuilder.append(group == '\u0000' ? "###0." : "#,##0.");
            for (int i = 0; i < decimals; ++i) {
                patternBuilder.append('0');
            }
            pattern = patternBuilder.toString();
        } else {
            String string = pattern = group == '\u0000' ? "###0" : "#,##0";
        }
        if (point == '.' && group == ',') {
            decimalFormatSymbols = DEFAULT_DECIMAL_FORMAT_SYMBOLS;
        } else {
            decimalFormatSymbols = new DecimalFormatSymbols();
            decimalFormatSymbols.setDecimalSeparator(point);
            decimalFormatSymbols.setGroupingSeparator(group);
            decimalFormatSymbols.setZeroDigit('0');
        }
        DecimalFormat format = new DecimalFormat(pattern, decimalFormatSymbols);
        String result = format.format(value);
        if (point == '\u0000' && decimals > 0) {
            int i = result.lastIndexOf(point);
            return result.substring(0, i) + result.substring(i + 1, result.length());
        }
        return result;
    }

    public static long ord(StringValue string) {
        if (string.length() == 0) {
            return 0L;
        }
        return string.charAt(0);
    }

    @UsesSymbolTable
    public static Value parse_str(Env env, StringValue str, @Optional @Reference Value ref) {
        boolean isRef = ref instanceof Var;
        ArrayValue result = null;
        if (isRef) {
            result = new ArrayValueImpl();
            ref.set(result);
        } else if (ref instanceof ArrayValue) {
            result = (ArrayValue)ref;
            isRef = true;
        } else {
            result = new ArrayValueImpl();
        }
        return StringUtility.parseStr(env, str, result, isRef, env.getHttpInputEncoding(), false);
    }

    public static long print(Env env, Value value) {
        value.print(env);
        return 1L;
    }

    public static int printf(Env env, StringValue format, Value[] args) {
        Value str = StringModule.sprintf(env, format, args);
        str.print(env);
        return str.length();
    }

    public static String quoted_printable_decode(String str) {
        if (str == null) {
            str = "";
        }
        StringBuilder sb = new StringBuilder();
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            char ch = str.charAt(i);
            if ('!' <= ch && ch <= '<') {
                sb.append(ch);
                continue;
            }
            if ('>' <= ch && ch <= '~') {
                sb.append(ch);
                continue;
            }
            if (ch == ' ' || ch == '\t') {
                if (i + 1 < str.length() && (str.charAt(i + 1) == '\r' || str.charAt(i + 1) == '\n')) {
                    sb.append('=');
                    sb.append(StringModule.toUpperHexChar(ch >> 4));
                    sb.append(StringModule.toUpperHexChar(ch));
                    continue;
                }
                sb.append(ch);
                continue;
            }
            if (ch == '\r' || ch == '\n') {
                sb.append(ch);
                continue;
            }
            sb.append('=');
            sb.append(StringModule.toUpperHexChar(ch >> 4));
            sb.append(StringModule.toUpperHexChar(ch));
        }
        return sb.toString();
    }

    public static Value quotemeta(StringValue string) {
        int len = string.length();
        StringValue sb = string.createStringBuilder(len * 5 / 4);
        block3: for (int i = 0; i < len; ++i) {
            char ch = string.charAt(i);
            switch (ch) {
                case '$': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': {
                    sb.append("\\");
                    sb.append(ch);
                    continue block3;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb;
    }

    public static StringValue rtrim(Env env, StringValue string, @Optional String characters) {
        if (characters == null) {
            characters = "";
        }
        boolean[] trim = characters.equals("") ? TRIM_WHITESPACE : StringModule.parseCharsetBitmap(env, characters);
        for (int i = string.length() - 1; i >= 0; --i) {
            char ch = string.charAt(i);
            if (ch < '\u0100' && trim[ch]) continue;
            if (i == string.length()) {
                return string;
            }
            return string.substring(0, i + 1);
        }
        return env.getEmptyString();
    }

    public static Value setlocale(Env env, int category, Value localeArg, Value[] fallback) {
        LocaleInfo localeInfo = env.getLocaleInfo();
        if (localeArg instanceof ArrayValue) {
            for (Value value : ((ArrayValue)localeArg).values()) {
                QuercusLocale locale = StringModule.setLocale(localeInfo, category, value.toString());
                if (locale == null) continue;
                return env.createString(locale.toString());
            }
        } else {
            QuercusLocale locale = StringModule.setLocale(localeInfo, category, localeArg.toString());
            if (locale != null) {
                return env.createString(locale.toString());
            }
        }
        for (int i = 0; i < fallback.length; ++i) {
            QuercusLocale locale = StringModule.setLocale(localeInfo, category, fallback[i].toString());
            if (locale == null) continue;
            return env.createString(locale.toString());
        }
        return BooleanValue.FALSE;
    }

    private static QuercusLocale setLocale(LocaleInfo localeInfo, int category, String localeName) {
        QuercusLocale locale = StringModule.findLocale(localeName);
        if (locale == null) {
            return null;
        }
        switch (category) {
            case 6: {
                localeInfo.setAll(locale);
                return localeInfo.getMessages();
            }
            case 4: {
                localeInfo.setCollate(locale);
                return localeInfo.getCollate();
            }
            case 1: {
                localeInfo.setCtype(locale);
                return localeInfo.getCtype();
            }
            case 5: {
                localeInfo.setMonetary(locale);
                return localeInfo.getMonetary();
            }
            case 2: {
                localeInfo.setNumeric(locale);
                return localeInfo.getNumeric();
            }
            case 3: {
                localeInfo.setTime(locale);
                return localeInfo.getTime();
            }
            case 7: {
                localeInfo.setMessages(locale);
                return localeInfo.getMessages();
            }
        }
        return null;
    }

    private static QuercusLocale findLocale(String localeName) {
        Locale locale;
        String charset = null;
        String variant = null;
        CharBuffer sb = CharBuffer.allocate();
        int len = localeName.length();
        int i = 0;
        char ch = '\u0000';
        while (i < len && (ch = localeName.charAt(i++)) != '-' && ch != '_') {
            sb.append(ch);
        }
        String language = sb.toString();
        sb.clear();
        while (i < len && (ch = localeName.charAt(i)) != '.' && ch != '@') {
            sb.append(ch);
            ++i;
        }
        if (ch == '.') {
            ++i;
        }
        String country = sb.toString();
        sb.clear();
        while (i < len && (ch = localeName.charAt(i)) != '@') {
            sb.append(ch);
            ++i;
        }
        if (sb.length() > 0) {
            charset = sb.toString();
        }
        if (i + 1 < len) {
            variant = localeName.substring(i + 1);
        }
        if (StringModule.isValidLocale(locale = variant != null && !variant.equalsIgnoreCase("euro") ? new Locale(language, country, variant) : (country != null ? new Locale(language, country) : new Locale(language)))) {
            return new QuercusLocale(locale, charset);
        }
        return null;
    }

    private static boolean isValidLocale(Locale locale) {
        Locale[] validLocales = Locale.getAvailableLocales();
        for (int i = 0; i < validLocales.length; ++i) {
            if (!validLocales[i].equals(locale)) continue;
            return true;
        }
        return false;
    }

    public static Value sha1(Env env, InputStream is, @Optional boolean rawOutput) {
        TempBuffer tempBuffer = TempBuffer.allocate();
        try {
            int len;
            MessageDigest md = MessageDigest.getInstance("SHA1");
            byte[] buffer = tempBuffer.getBuffer();
            while ((len = is.read(buffer, 0, buffer.length)) >= 0) {
                md.update(buffer, 0, len);
            }
            byte[] digest = md.digest();
            Value value = StringModule.hashToValue(env, digest, rawOutput);
            return value;
        }
        catch (Exception e) {
            throw new QuercusException(e);
        }
        finally {
            TempBuffer.free(tempBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Value sha1_file(Env env, Path source, @Optional boolean rawOutput) {
        TempBuffer tempBuffer = TempBuffer.allocate();
        try {
            int len;
            MessageDigest md = MessageDigest.getInstance("SHA1");
            ReadStream is = null;
            is = source.openRead();
            byte[] buffer = tempBuffer.getBuffer();
            while ((len = ((InputStream)is).read(buffer, 0, buffer.length)) >= 0) {
                md.update(buffer, 0, len);
            }
            byte[] digest = md.digest();
            Value value = StringModule.hashToValue(env, digest, rawOutput);
            try {
                if (is == null) return value;
                ((InputStream)is).close();
                return value;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return value;
            catch (IOException e) {
                log.log(Level.FINE, e.toString(), e);
                BooleanValue booleanValue = BooleanValue.FALSE;
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                TempBuffer.free(tempBuffer);
                return booleanValue;
                {
                    catch (Throwable throwable) {
                        try {
                            try {
                                if (is == null) throw throwable;
                                ((InputStream)is).close();
                                throw throwable;
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                        catch (Exception e2) {
                            throw new QuercusException(e2);
                        }
                    }
                }
            }
        }
        finally {
            TempBuffer.free(tempBuffer);
        }
    }

    private static Value hashToValue(Env env, byte[] bytes, boolean isBinary) {
        if (isBinary) {
            StringValue v = env.createBinaryBuilder();
            v.append(bytes, 0, bytes.length);
            return v;
        }
        StringValue v = env.createUnicodeBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            byte ch = bytes[i];
            int d1 = ch >> 4 & 0xF;
            int d2 = ch & 0xF;
            if (d1 < 10) {
                v.append((char)(48 + d1));
            } else {
                v.append((char)(97 + d1 - 10));
            }
            if (d2 < 10) {
                v.append((char)(48 + d2));
                continue;
            }
            v.append((char)(97 + d2 - 10));
        }
        return v;
    }

    public static Value soundex(StringValue string) {
        int length = string.length();
        if (length == 0) {
            return BooleanValue.FALSE;
        }
        StringValue result = string.createStringBuilder();
        int count = 0;
        char lastCode = '\u0000';
        for (int i = 0; i < length && count < 4; ++i) {
            char ch = StringModule.toUpperCase(string.charAt(i));
            if ('A' > ch || ch > 'Z') continue;
            char code = SOUNDEX_VALUES[ch - 65];
            if (count == 0) {
                result.append(ch);
                ++count;
            } else if (code != '0' && code != lastCode) {
                result.append(code);
                ++count;
            }
            lastCode = code;
        }
        while (count < 4) {
            result.append('0');
            ++count;
        }
        return result;
    }

    public static Value sprintf(Env env, StringValue format, Value[] args) {
        ArrayList<PrintfSegment> segments = StringModule.parsePrintfFormat(env, format);
        StringValue sb = format.createStringBuilder();
        for (PrintfSegment segment : segments) {
            if (segment.apply(env, sb, args)) continue;
            return BooleanValue.FALSE;
        }
        return sb;
    }

    private static ArrayList<PrintfSegment> parsePrintfFormat(Env env, StringValue format) {
        ArrayList<PrintfSegment> segments = new ArrayList<PrintfSegment>();
        StringBuilder sb = new StringBuilder();
        StringBuilder flags = new StringBuilder();
        int length = format.length();
        int index = 0;
        block19: for (int i = 0; i < length; ++i) {
            char ch = format.charAt(i);
            if (i + 1 < length && ch == '%') {
                int j;
                sb.append(ch);
                boolean isLeft = false;
                boolean isAlt = false;
                boolean isShowSign = false;
                int argIndex = -1;
                int leftPadLength = 0;
                int width = 0;
                int padChar = -1;
                flags.setLength(0);
                block20: for (j = i + 1; j < length; ++j) {
                    ch = format.charAt(j);
                    switch (ch) {
                        case '-': {
                            isLeft = true;
                            if (j + 1 >= length || format.charAt(j + 1) != '0') continue block20;
                            padChar = 48;
                            ++j;
                            continue block20;
                        }
                        case '#': {
                            isAlt = true;
                            continue block20;
                        }
                        case '0': {
                            char digit;
                            int k;
                            if (padChar < 0) {
                                padChar = 48;
                                continue block20;
                            }
                            int value = 0;
                            for (k = j + 1; k < length && '0' <= (digit = format.charAt(k)) && digit <= '9'; ++k) {
                                value = value * 10 + digit - 48;
                                ++j;
                            }
                            if (j + 1 < length && format.charAt(j + 1) == '$') {
                                argIndex = value - 1;
                                ++j;
                                continue block20;
                            }
                            width = value;
                            continue block20;
                        }
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            char digit;
                            int k;
                            int value = ch - 48;
                            for (k = j + 1; k < length && '0' <= (digit = format.charAt(k)) && digit <= '9'; ++k) {
                                value = value * 10 + digit - 48;
                                ++j;
                            }
                            if (j + 1 < length && format.charAt(j + 1) == '$') {
                                argIndex = value - 1;
                                ++j;
                                continue block20;
                            }
                            width = value;
                            continue block20;
                        }
                        case '\'': {
                            padChar = format.charAt(j + 1);
                            ++j;
                            continue block20;
                        }
                        case '+': {
                            isShowSign = true;
                            continue block20;
                        }
                        case '(': 
                        case ',': {
                            flags.append(ch);
                            continue block20;
                        }
                        case ' ': {
                            continue block20;
                        }
                    }
                }
                int head = j;
                if (argIndex < 0) {
                    argIndex = index;
                }
                while (j < length) {
                    ch = format.charAt(j);
                    switch (ch) {
                        case '%': {
                            i = j;
                            segments.add(new TextPrintfSegment(sb));
                            sb.setLength(0);
                            continue block19;
                        }
                        case '$': 
                        case '.': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            break;
                        }
                        case 'S': 
                        case 's': {
                            sb.setLength(sb.length() - 1);
                            if (width <= 0 && 0 < leftPadLength) {
                                width = leftPadLength;
                            }
                            ++index;
                            segments.add(new StringPrintfSegment(sb, isLeft || isAlt, padChar, ch == 'S', width, format.substring(head, j).toString(), argIndex));
                            sb.setLength(0);
                            i = j;
                            continue block19;
                        }
                        case 'C': 
                        case 'c': {
                            sb.setLength(sb.length() - 1);
                            if (width <= 0 && 0 < leftPadLength) {
                                width = leftPadLength;
                            }
                            ++index;
                            segments.add(new CharPrintfSegment(sb, isLeft || isAlt, padChar, ch == 'C', width, format.substring(head, j).toString(), argIndex));
                            sb.setLength(0);
                            i = j;
                            continue block19;
                        }
                        case 'i': {
                            ch = 'd';
                        }
                        case 'B': 
                        case 'X': 
                        case 'b': 
                        case 'd': 
                        case 'o': 
                        case 'u': 
                        case 'x': {
                            sb.setLength(sb.length() - 1);
                            if (sb.length() > 0) {
                                segments.add(new TextPrintfSegment(sb));
                            }
                            sb.setLength(0);
                            if (isAlt) {
                                sb.append('#');
                            }
                            if (isShowSign) {
                                sb.append('+');
                            }
                            sb.append((CharSequence)flags);
                            if (width > 0) {
                                if (isLeft) {
                                    sb.append('-');
                                } else if (padChar == 48) {
                                    sb.append('0');
                                }
                                sb.append(width);
                            }
                            sb.append(format, head, j);
                            sb.append(ch);
                            ++index;
                            segments.add(LongPrintfSegment.create(env, sb.toString(), argIndex));
                            sb.setLength(0);
                            i = j;
                            continue block19;
                        }
                        case 'E': 
                        case 'F': 
                        case 'G': 
                        case 'e': 
                        case 'f': 
                        case 'g': {
                            QuercusLocale locale = null;
                            if (ch == 'F') {
                                ch = 'f';
                                locale = QuercusLocale.getDefault();
                            } else if (ch == 'f') {
                                locale = env.getLocaleInfo().getNumeric();
                            }
                            sb.setLength(sb.length() - 1);
                            if (sb.length() > 0) {
                                segments.add(new TextPrintfSegment(sb));
                            }
                            sb.setLength(0);
                            if (isAlt) {
                                sb.append('#');
                            }
                            if (isShowSign) {
                                sb.append('+');
                            }
                            sb.append((CharSequence)flags);
                            if (width > 0) {
                                if (isLeft) {
                                    sb.append('-');
                                } else if (padChar == 48) {
                                    sb.append('0');
                                }
                                sb.append(width);
                            }
                            sb.append(format, head, j);
                            sb.append(ch);
                            ++index;
                            segments.add(new DoublePrintfSegment(sb.toString(), isLeft && padChar == 48, argIndex, locale));
                            sb.setLength(0);
                            i = j;
                            continue block19;
                        }
                        default: {
                            if (isLeft) {
                                sb.append('-');
                            }
                            if (isAlt) {
                                sb.append('#');
                            }
                            sb.append((CharSequence)flags);
                            sb.append(format, head, j);
                            sb.append(ch);
                            i = j;
                            continue block19;
                        }
                    }
                    ++j;
                }
                continue;
            }
            sb.append(ch);
        }
        if (sb.length() > 0) {
            segments.add(new TextPrintfSegment(sb));
        }
        return segments;
    }

    public static Value sscanf(Env env, StringValue string, StringValue format, @Optional @Reference Value[] args) {
        ScanfSegment[] formatArray = StringModule.sscanfParseFormat(env, format);
        int strlen = string.length();
        int sIndex = 0;
        boolean isReturnArray = args.length == 0;
        int argIndex = 0;
        if (strlen == 0) {
            return isReturnArray ? NullValue.NULL : LongValue.MINUS_ONE;
        }
        ArrayValueImpl array = new ArrayValueImpl();
        for (int i = 0; i < formatArray.length; ++i) {
            Value var;
            ScanfSegment segment = formatArray[i];
            if (!segment.isAssigned()) {
                var = null;
            } else if (isReturnArray) {
                var = array;
            } else if (argIndex < args.length) {
                var = args[argIndex];
                if (sIndex < strlen) {
                    ++argIndex;
                }
            } else {
                env.warning(L.l("not enough vars passed in"));
                var = NullValue.NULL;
            }
            sIndex = segment.apply(string, strlen, sIndex, var, isReturnArray);
            if (sIndex >= 0) continue;
            if (isReturnArray) {
                return StringModule.sscanfFillNull(array, formatArray, i);
            }
            return LongValue.create(argIndex);
        }
        return StringModule.sscanfReturn(env, array, args, argIndex, isReturnArray, false);
    }

    private static Value sscanfFillNull(ArrayValue array, ScanfSegment[] formatArray, int fIndex) {
        while (fIndex < formatArray.length) {
            ScanfSegment segment = formatArray[fIndex];
            if (segment.isAssigned()) {
                array.put(NullValue.NULL);
            }
            ++fIndex;
        }
        return array;
    }

    private static ScanfSegment[] sscanfParseFormat(Env env, StringValue format) {
        int fmtLen = format.length();
        int fIndex = 0;
        ArrayList<ScanfSegment> segmentList = new ArrayList<ScanfSegment>();
        StringBuilder sb = new StringBuilder();
        block14: while (fIndex < fmtLen) {
            char ch;
            if (StringModule.isWhitespace(ch = format.charAt(fIndex++))) {
                while (fIndex < fmtLen && StringModule.isWhitespace(ch = format.charAt(fIndex))) {
                    ++fIndex;
                }
                StringModule.scanfAddConstant(segmentList, sb);
                segmentList.add(ScanfWhitespace.SEGMENT);
                continue;
            }
            if (ch == '%') {
                int maxLen = -1;
                block16: while (fIndex < fmtLen) {
                    ch = format.charAt(fIndex++);
                    block0 : switch (ch) {
                        case '%': {
                            sb.append('%');
                            break;
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            if (maxLen < 0) {
                                maxLen = 0;
                            }
                            maxLen = 10 * maxLen + ch - 48;
                            continue block16;
                        }
                        case 's': {
                            StringModule.scanfAddConstant(segmentList, sb);
                            segmentList.add(new ScanfString(maxLen));
                            break;
                        }
                        case 'c': {
                            if (maxLen < 0) {
                                maxLen = 1;
                            }
                            StringModule.scanfAddConstant(segmentList, sb);
                            segmentList.add(new ScanfString(maxLen));
                            break;
                        }
                        case 'n': {
                            StringModule.scanfAddConstant(segmentList, sb);
                            segmentList.add(ScanfStringLength.SEGMENT);
                            break;
                        }
                        case 'd': {
                            StringModule.scanfAddConstant(segmentList, sb);
                            segmentList.add(new ScanfInteger(maxLen, 10, false));
                            break;
                        }
                        case 'i': {
                            StringModule.scanfAddConstant(segmentList, sb);
                            segmentList.add(new ScanfIntegerWithBaseDetection(maxLen));
                            break;
                        }
                        case 'u': {
                            StringModule.scanfAddConstant(segmentList, sb);
                            segmentList.add(new ScanfInteger(maxLen, 10, true));
                            break;
                        }
                        case 'o': {
                            StringModule.scanfAddConstant(segmentList, sb);
                            segmentList.add(new ScanfInteger(maxLen, 8, false));
                            break;
                        }
                        case 'X': 
                        case 'x': {
                            StringModule.scanfAddConstant(segmentList, sb);
                            segmentList.add(new ScanfHex(maxLen));
                            break;
                        }
                        case 'e': 
                        case 'f': {
                            StringModule.scanfAddConstant(segmentList, sb);
                            segmentList.add(new ScanfScientific(maxLen));
                            break;
                        }
                        case '[': {
                            StringModule.scanfAddConstant(segmentList, sb);
                            if (fmtLen <= fIndex) {
                                env.warning(L.l("expected ']', saw end of string"));
                                break;
                            }
                            boolean isNegated = false;
                            if (fIndex < fmtLen && format.charAt(fIndex) == '^') {
                                isNegated = true;
                                ++fIndex;
                            }
                            IntSet set = new IntSet();
                            while (true) {
                                char ch2;
                                if (fIndex == fmtLen) {
                                    env.warning(L.l("expected ']', saw end of string"));
                                    break block0;
                                }
                                if ((ch2 = format.charAt(fIndex++)) == ']') break;
                                set.union(ch2);
                            }
                            if (isNegated) {
                                segmentList.add(new ScanfSetNegated(set));
                                break;
                            }
                            segmentList.add(new ScanfSet(set));
                            break;
                        }
                        default: {
                            log.fine(L.l("'{0}' is a bad sscanf string.", (Object)format));
                            env.warning(L.l("'{0}' is a bad sscanf string.", (Object)format));
                            break;
                        }
                    }
                    continue block14;
                }
                continue;
            }
            sb.append(ch);
        }
        StringModule.scanfAddConstant(segmentList, sb);
        ScanfSegment[] segmentArray = new ScanfSegment[segmentList.size()];
        return segmentList.toArray(segmentArray);
    }

    private static void scanfAddConstant(ArrayList<ScanfSegment> segmentList, StringBuilder sb) {
        if (sb.length() == 0) {
            return;
        }
        segmentList.add(new ScanfConstant(sb.toString()));
        sb.setLength(0);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static Value sscanfOld(Env env, StringValue string, StringValue format, @Optional @Reference Value[] args) {
        int fmtLen = format.length();
        int strlen = string.length();
        int sIndex = 0;
        int fIndex = 0;
        boolean isAssign = args.length != 0;
        boolean isReturnArray = !isAssign;
        int argIndex = 0;
        if (strlen == 0) {
            Value value;
            if (isAssign) {
                value = LongValue.MINUS_ONE;
                return value;
            }
            value = NullValue.NULL;
            return value;
        }
        ArrayValueImpl array = new ArrayValueImpl();
        block12: while (fIndex < fmtLen) {
            char ch;
            if (StringModule.isWhitespace(ch = format.charAt(fIndex++))) {
                while (fIndex < fmtLen && StringModule.isWhitespace(ch = format.charAt(fIndex))) {
                    ++fIndex;
                }
                while (true) {
                    if (sIndex >= strlen || !StringModule.isWhitespace(string.charAt(sIndex))) continue block12;
                    ++sIndex;
                }
            }
            if (ch != '%') {
                if (ch != string.charAt(sIndex)) return StringModule.sscanfReturn(env, array, args, argIndex, false, true);
                ++sIndex;
                continue;
            }
            int maxLen = -1;
            block15: while (true) {
                Value value;
                block27: {
                    if (fIndex >= fmtLen) continue block12;
                    ch = format.charAt(fIndex++);
                    if (sIndex >= strlen && ch != 'n') {
                        array.append(NullValue.NULL);
                        continue block12;
                    }
                    if (isAssign) {
                        if (argIndex < args.length) {
                            Value value2 = args[argIndex++];
                            break block27;
                        } else {
                            env.warning(L.l("not enough vars passed in"));
                            continue block12;
                        }
                    }
                    ArrayValueImpl arrayValueImpl = array;
                }
                switch (ch) {
                    case '%': {
                        if (string.charAt(sIndex) == '%') continue block12;
                        return StringModule.sscanfReturn(env, array, args, argIndex, isAssign, true);
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        if (maxLen < 0) {
                            maxLen = 0;
                        }
                        maxLen = 10 * maxLen + ch - 48;
                        continue block15;
                    }
                    case 's': {
                        void var14_14;
                        ScanfSegment seg = new ScanfString(maxLen);
                        sIndex = seg.apply(string, strlen, sIndex, (Value)var14_14, isReturnArray);
                        continue block12;
                    }
                    case 'c': {
                        void var14_14;
                        if (maxLen < 0) {
                            maxLen = 1;
                        }
                        ScanfSegment seg = new ScanfString(maxLen);
                        sIndex = seg.apply(string, strlen, sIndex, (Value)var14_14, isReturnArray);
                        continue block12;
                    }
                    case 'n': {
                        void var14_14;
                        ScanfSegment seg = ScanfStringLength.SEGMENT;
                        sIndex = seg.apply(string, strlen, sIndex, (Value)var14_14, isReturnArray);
                        continue block12;
                    }
                    case 'd': {
                        void var14_14;
                        ScanfSegment seg = new ScanfInteger(maxLen, 10, false);
                        sIndex = seg.apply(string, strlen, sIndex, (Value)var14_14, isReturnArray);
                        continue block12;
                    }
                    case 'u': {
                        void var14_14;
                        ScanfSegment seg = new ScanfInteger(maxLen, 10, true);
                        sIndex = seg.apply(string, strlen, sIndex, (Value)var14_14, isReturnArray);
                        continue block12;
                    }
                    case 'o': {
                        void var14_14;
                        ScanfSegment seg = new ScanfInteger(maxLen, 8, false);
                        sIndex = seg.apply(string, strlen, sIndex, (Value)var14_14, isReturnArray);
                        continue block12;
                    }
                    case 'X': 
                    case 'x': {
                        void var14_14;
                        ScanfSegment seg = new ScanfHex(maxLen);
                        sIndex = seg.apply(string, strlen, sIndex, (Value)var14_14, isReturnArray);
                        continue block12;
                    }
                    case 'e': 
                    case 'f': {
                        void var14_14;
                        ScanfSegment seg = new ScanfScientific(maxLen);
                        sIndex = seg.apply(string, strlen, sIndex, (Value)var14_14, isReturnArray);
                        continue block12;
                    }
                }
                log.fine(L.l("'{0}' is a bad sscanf string.", (Object)format));
                env.warning(L.l("'{0}' is a bad sscanf string.", (Object)format));
                if (isAssign) {
                    value = LongValue.create(argIndex);
                    return value;
                }
                value = array;
                return value;
            }
            break;
        }
        return StringModule.sscanfReturn(env, array, args, argIndex, isAssign, false);
    }

    private static Value sscanfReturn(Env env, ArrayValue array, Value[] args, int argIndex, boolean isReturnArray, boolean isWarn) {
        if (isReturnArray) {
            return array;
        }
        if (isWarn && argIndex != args.length) {
            env.warning(L.l("{0} vars passed in but saw only {1} '%' args", args.length, argIndex));
        }
        return LongValue.create(argIndex);
    }

    private static int sscanfString(StringValue string, int sIndex, int maxLen, Value obj, boolean isAssignment) {
        char ch;
        int strlen = string.length();
        if (maxLen < 0) {
            maxLen = Integer.MAX_VALUE;
        }
        StringValue sb = string.createStringBuilder();
        while (sIndex < strlen && maxLen-- > 0 && !StringModule.isWhitespace(ch = string.charAt(sIndex))) {
            sb.append(ch);
            ++sIndex;
        }
        StringModule.sscanfPut(obj, sb, isAssignment);
        return sIndex;
    }

    private static void sscanfPut(Value obj, Value val, boolean isAssignment) {
        if (isAssignment) {
            obj.set(val);
        } else {
            obj.put(val);
        }
    }

    private static int sscanfInteger(StringValue string, int sIndex, int maxLen, Value obj, boolean isAssign, int base, boolean isUnsigned) {
        int strlen = string.length();
        if (maxLen < 0) {
            maxLen = Integer.MAX_VALUE;
        }
        int val = 0;
        int sign = 1;
        boolean isNotMatched = true;
        if (sIndex < strlen) {
            char ch = string.charAt(sIndex);
            if (ch == '+') {
                ++sIndex;
                --maxLen;
            } else if (ch == '-') {
                sign = -1;
                ++sIndex;
                --maxLen;
            }
        }
        int topRange = base + 48;
        while (sIndex < strlen && maxLen-- > 0) {
            char ch = string.charAt(sIndex);
            if ('0' > ch || ch >= topRange) {
                if (!isNotMatched) break;
                StringModule.sscanfPut(obj, NullValue.NULL, isAssign);
                return sIndex;
            }
            val = val * base + ch - 48;
            isNotMatched = false;
            ++sIndex;
        }
        if (isUnsigned) {
            if (sign == -1 && val != 0) {
                StringModule.sscanfPut(obj, StringValue.create(0xFFFFFFFFL - (long)val + 1L), isAssign);
            } else {
                StringModule.sscanfPut(obj, LongValue.create(val), isAssign);
            }
        } else {
            StringModule.sscanfPut(obj, LongValue.create(val * sign), isAssign);
        }
        return sIndex;
    }

    private static int sscanfHex(StringValue string, int sIndex, int maxLen, Value obj, boolean isAssign) {
        char ch;
        int strlen = string.length();
        if (maxLen < 0) {
            maxLen = Integer.MAX_VALUE;
        }
        int val = 0;
        int sign = 1;
        boolean isMatched = false;
        if (sIndex < strlen) {
            ch = string.charAt(sIndex);
            if (ch == '+') {
                ++sIndex;
                --maxLen;
            } else if (ch == '-') {
                sign = -1;
                ++sIndex;
                --maxLen;
            }
        }
        while (sIndex < strlen && maxLen-- > 0) {
            ch = string.charAt(sIndex);
            if ('0' <= ch && ch <= '9') {
                val = val * 16 + ch - 48;
                isMatched = true;
            } else if ('a' <= ch && ch <= 'f') {
                val = val * 16 + ch - 97 + 10;
                isMatched = true;
            } else if ('A' <= ch && ch <= 'F') {
                val = val * 16 + ch - 65 + 10;
                isMatched = true;
            } else {
                if (isMatched) break;
                StringModule.sscanfPut(obj, NullValue.NULL, isAssign);
                return sIndex;
            }
            ++sIndex;
        }
        StringModule.sscanfPut(obj, LongValue.create(val * sign), isAssign);
        return sIndex;
    }

    private static int sscanfScientific(StringValue s, int i, int maxLen, Value obj, boolean isAssign) {
        int start;
        block12: {
            int e;
            int ch;
            int len;
            block15: {
                block14: {
                    block13: {
                        if (maxLen < 0) {
                            maxLen = Integer.MAX_VALUE;
                        }
                        start = i;
                        len = s.length();
                        ch = 0;
                        if (i < len && maxLen > 0) {
                            char c = s.charAt(i);
                            ch = c;
                            if (c == '+' || ch == 45) {
                                ++i;
                                --maxLen;
                            }
                        }
                        while (i < len && maxLen > 0) {
                            char c = s.charAt(i);
                            ch = c;
                            if ('0' > c || ch > 57) break;
                            --maxLen;
                            ++i;
                        }
                        if (ch == 46) {
                            --maxLen;
                            ++i;
                            while (i < len && maxLen > 0) {
                                char c = s.charAt(i);
                                ch = c;
                                if ('0' > c || ch > 57) break;
                                --maxLen;
                                ++i;
                            }
                        }
                        if (ch != 101 && ch != 69) break block12;
                        --maxLen;
                        if (start == (e = i++)) {
                            StringModule.sscanfPut(obj, NullValue.NULL, isAssign);
                            return start;
                        }
                        if (i >= len || maxLen <= 0) break block13;
                        char c = s.charAt(i);
                        ch = c;
                        if (c == '+') break block14;
                    }
                    if (ch != 45) break block15;
                }
                ++i;
                --maxLen;
            }
            while (i < len && maxLen > 0) {
                char c = s.charAt(i);
                ch = c;
                if ('0' > c || ch > 57) break;
                --maxLen;
                ++i;
            }
            if (i == e + 1) {
                i = e;
            }
        }
        double val = i == 0 ? 0.0 : Double.parseDouble(s.substring(start, i).toString());
        StringModule.sscanfPut(obj, DoubleValue.create(val), isAssign);
        return i;
    }

    public static Value str_ireplace(Env env, Value search, Value replace, Value subject, @Reference @Optional Value count) {
        return StringModule.strReplace(env, search, replace, subject, count, true);
    }

    public static StringValue str_pad(StringValue string, int length, @Optional(value="' '") String pad, @Optional(value="STR_PAD_RIGHT") int type) {
        int i;
        int strLen = string.length();
        int padLen = length - strLen;
        if (padLen <= 0) {
            return string;
        }
        if (pad == null || pad.length() == 0) {
            pad = " ";
        }
        int leftPad = 0;
        int rightPad = 0;
        switch (type) {
            case 1: {
                leftPad = padLen;
                break;
            }
            default: {
                rightPad = padLen;
                break;
            }
            case 2: {
                leftPad = padLen / 2;
                rightPad = padLen - leftPad;
            }
        }
        int padStringLen = pad.length();
        StringValue sb = string.createStringBuilder(string.length() + padLen);
        for (i = 0; i < leftPad; ++i) {
            sb.append(pad.charAt(i % padStringLen));
        }
        sb = sb.append(string);
        for (i = 0; i < rightPad; ++i) {
            sb.append(pad.charAt(i % padStringLen));
        }
        return sb;
    }

    public static Value str_repeat(StringValue string, int count) {
        StringValue sb = string.createStringBuilder(count * string.length());
        for (int i = 0; i < count; ++i) {
            sb = sb.append(string);
        }
        return sb;
    }

    public static Value str_replace(Env env, Value search, Value replace, Value subject, @Reference @Optional Value count) {
        return StringModule.strReplace(env, search, replace, subject, count, false);
    }

    private static Value strReplace(Env env, Value search, Value replace, Value subject, Value count, boolean isInsensitive) {
        count.set(LongValue.ZERO);
        if (subject.isNull()) {
            return env.getEmptyString();
        }
        if (search.isNull()) {
            return subject;
        }
        if (subject.isArray()) {
            ArrayValue subjectArray = subject.toArrayValue(env);
            ArrayValueImpl resultArray = new ArrayValueImpl();
            for (Map.Entry<Value, Value> entry : subjectArray.entrySet()) {
                Value key = entry.getKey();
                Value value = entry.getValue();
                if (value.isArray()) {
                    ((ArrayValue)resultArray).append(key, value);
                    continue;
                }
                Value result = StringModule.strReplaceImpl(env, search, replace, value.toStringValue(env), count, isInsensitive);
                ((ArrayValue)resultArray).append(key, result);
            }
            return resultArray;
        }
        StringValue subjectString = subject.toStringValue(env);
        if (subjectString.length() == 0) {
            return env.getEmptyString();
        }
        return StringModule.strReplaceImpl(env, search, replace, subjectString, count, isInsensitive);
    }

    private static Value strReplaceImpl(Env env, Value search, Value replace, StringValue subject, Value count, boolean isInsensitive) {
        if (!search.isArray()) {
            StringValue searchString = search.toStringValue(env);
            if (searchString.length() == 0) {
                return subject;
            }
            if (replace.isArray()) {
                env.warning(L.l("Array to string conversion"));
            }
            subject = StringModule.strReplaceImpl(env, searchString, replace.toStringValue(env), subject, count, isInsensitive);
        } else if (replace.isArray()) {
            ArrayValue searchArray = search.toArrayValue(env);
            ArrayValue replaceArray = replace.toArrayValue(env);
            Iterator<Value> searchIter = searchArray.values().iterator();
            Iterator<Value> replaceIter = replaceArray.values().iterator();
            while (searchIter.hasNext()) {
                Value searchItem = searchIter.next();
                Value replaceItem = replaceIter.next();
                if (replaceItem == null) {
                    replaceItem = NullValue.NULL;
                }
                subject = StringModule.strReplaceImpl(env, searchItem.toStringValue(env), replaceItem.toStringValue(env), subject, count, isInsensitive);
            }
        } else {
            ArrayValue searchArray = search.toArrayValue(env);
            for (Value searchItem : searchArray.values()) {
                subject = StringModule.strReplaceImpl(env, searchItem.toStringValue(env), replace.toStringValue(env), subject, count, isInsensitive);
            }
        }
        return subject;
    }

    private static StringValue strReplaceImpl(Env env, StringValue search, StringValue replace, StringValue subject, Value countV, boolean isInsensitive) {
        int next;
        long count = countV.toLong();
        int head = 0;
        int searchLen = search.length();
        StringValue result = null;
        while (head <= (next = StringModule.indexOf(subject, search, head, isInsensitive))) {
            if (result == null) {
                result = subject.createStringBuilder();
            }
            result = result.append(subject, head, next);
            result = result.append(replace);
            head = head < next + searchLen ? next + searchLen : ++head;
            ++count;
        }
        if (count != 0L && result != null) {
            countV.set(LongValue.create(count));
            int subjectLength = subject.length();
            if (head > 0 && head < subjectLength) {
                result = result.append(subject, head, subjectLength);
            }
            return result;
        }
        return subject;
    }

    private static int indexOf(StringValue subject, StringValue match, int head, boolean isInsensitive) {
        if (!isInsensitive) {
            return subject.indexOf(match, head);
        }
        int length = subject.length();
        int matchLen = match.length();
        if (matchLen <= 0) {
            return -1;
        }
        char ch = Character.toLowerCase(match.charAt(0));
        while (head + matchLen <= length) {
            block6: {
                if (ch == Character.toLowerCase(subject.charAt(head))) {
                    for (int i = 1; i < matchLen; ++i) {
                        if (Character.toLowerCase(subject.charAt(head + i)) == Character.toLowerCase(match.charAt(i))) {
                            continue;
                        }
                        break block6;
                    }
                    return head;
                }
            }
            ++head;
        }
        return -1;
    }

    public static Value str_rot13(StringValue string) {
        if (string == null) {
            return NullValue.NULL;
        }
        StringValue sb = string.createStringBuilder(string.length());
        int len = string.length();
        for (int i = 0; i < len; ++i) {
            int off;
            char ch = string.charAt(i);
            if ('a' <= ch && ch <= 'z') {
                off = ch - 97;
                sb.append((char)(97 + (off + 13) % 26));
                continue;
            }
            if ('A' <= ch && ch <= 'Z') {
                off = ch - 65;
                sb.append((char)(65 + (off + 13) % 26));
                continue;
            }
            sb.append(ch);
        }
        return sb;
    }

    public static String str_shuffle(String string) {
        if (string == null) {
            string = "";
        }
        char[] chars = string.toCharArray();
        int length = chars.length;
        for (int i = 0; i < length; ++i) {
            int rand = RandomUtil.nextInt(length);
            char temp = chars[rand];
            chars[rand] = chars[i];
            chars[i] = temp;
        }
        return new String(chars);
    }

    public static Value str_split(StringValue string, @Optional(value="1") int chunk) {
        ArrayValueImpl array = new ArrayValueImpl();
        if (string.length() == 0) {
            ((ArrayValue)array).put(string);
            return array;
        }
        int strLen = string.length();
        for (int i = 0; i < strLen; i += chunk) {
            StringValue value = i + chunk <= strLen ? string.substring(i, i + chunk) : (i != 0 ? string.substring(i) : string);
            ((ArrayValue)array).put(value);
        }
        return array;
    }

    public static Value str_word_count(StringValue string, @Optional int format, @Optional String additionalWordCharacters) {
        if (format < 0 || format > 2) {
            return NullValue.NULL;
        }
        int strlen = string.length();
        boolean isAdditionalWordCharacters = false;
        if (additionalWordCharacters != null) {
            isAdditionalWordCharacters = additionalWordCharacters.length() > 0;
        }
        ArrayValueImpl resultArray = null;
        if (format > 0) {
            resultArray = new ArrayValueImpl();
        }
        boolean isBetweenWords = true;
        int wordCount = 0;
        int lastWordStart = 0;
        for (int i = 0; i <= strlen; ++i) {
            char ch;
            boolean isWordCharacter = i < strlen ? Character.isLetter((int)(ch = string.charAt(i))) || ch == '-' || ch == '\'' || isAdditionalWordCharacters && additionalWordCharacters.indexOf(ch) > -1 : false;
            if (isWordCharacter) {
                if (!isBetweenWords) continue;
                isBetweenWords = false;
                lastWordStart = i;
                ++wordCount;
                continue;
            }
            if (isBetweenWords) continue;
            isBetweenWords = true;
            if (format <= 0) continue;
            StringValue word = string.substring(lastWordStart, i);
            if (format == 1) {
                resultArray.append(word);
                continue;
            }
            if (format != 2) continue;
            resultArray.put(LongValue.create(lastWordStart), word);
        }
        if (resultArray == null) {
            return LongValue.create(wordCount);
        }
        return resultArray;
    }

    public static int strcasecmp(StringValue a, StringValue b) {
        int aLen = a.length();
        int bLen = b.length();
        for (int i = 0; i < aLen && i < bLen; ++i) {
            char chB;
            char chA = a.charAt(i);
            if (chA == (chB = b.charAt(i))) continue;
            if (Character.isUpperCase(chA)) {
                chA = Character.toLowerCase(chA);
            }
            if (Character.isUpperCase(chB)) {
                chB = Character.toLowerCase(chB);
            }
            if (chA == chB) continue;
            if (chA < chB) {
                return -1;
            }
            return 1;
        }
        if (aLen == bLen) {
            return 0;
        }
        if (aLen < bLen) {
            return -1;
        }
        return 1;
    }

    public static Value strchr(Env env, StringValue haystack, Value needle) {
        return StringModule.strstr(env, haystack, needle);
    }

    public static int strcmp(StringValue a, StringValue b) {
        int aLen = a.length();
        int bLen = b.length();
        for (int i = 0; i < aLen && i < bLen; ++i) {
            char chB;
            char chA = a.charAt(i);
            if (chA == (chB = b.charAt(i)) || chA == chB) continue;
            if (chA < chB) {
                return -1;
            }
            return 1;
        }
        if (aLen == bLen) {
            return 0;
        }
        if (aLen < bLen) {
            return -1;
        }
        return 1;
    }

    public static Value strcoll(String a, String b) {
        int cmp;
        if (a == null) {
            a = "";
        }
        if (b == null) {
            b = "";
        }
        if ((cmp = a.compareTo(b)) == 0) {
            return LongValue.ZERO;
        }
        if (cmp < 0) {
            return LongValue.MINUS_ONE;
        }
        return LongValue.ONE;
    }

    public static Value strcspn(StringValue string, StringValue characters, @Optional(value="0") int offset, @Optional(value="-2147483648") int length) {
        if (characters.length() == 0) {
            characters = StringValue.create('\u0000');
        }
        return StringModule.strspnImpl(string, characters, offset, length, false);
    }

    public static StringValue strip_tags(Env env, StringValue string, @Optional Value allowTags) {
        StringValue result = string.createStringBuilder(string.length());
        HashSet<StringValue> allowedTagMap = null;
        if (!allowTags.isDefault()) {
            allowedTagMap = StringModule.getAllowedTags(allowTags.toStringValue(env));
        }
        int len = string.length();
        for (int i = 0; i < len; ++i) {
            int j;
            char ch = string.charAt(i);
            if (i + 1 >= len || ch != '<') {
                result.append(ch);
                continue;
            }
            ch = string.charAt(i + 1);
            if (Character.isWhitespace(ch)) {
                ++i;
                result.append('<');
                result.append(ch);
                continue;
            }
            int tagNameStart = i + 1;
            if (ch == '/') {
                // empty if block
            }
            for (j = ++tagNameStart; j < len && (ch = string.charAt(j)) != '>' && !Character.isWhitespace(ch); ++j) {
            }
            StringValue tagName = string.substring(tagNameStart, j);
            int tagEnd = 0;
            if (allowedTagMap != null && allowedTagMap.contains(tagName)) {
                result.append(string, i, Math.min(j + 1, len));
            } else {
                while (j < len && (ch = string.charAt(j)) != '<') {
                    if (ch == '>') {
                        tagEnd = j;
                    }
                    ++j;
                }
            }
            i = tagEnd != 0 ? tagEnd : j;
        }
        return result;
    }

    private static HashSet<StringValue> getAllowedTags(StringValue str) {
        int len = str.length();
        HashSet<StringValue> set = new HashSet<StringValue>();
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '<': {
                    int j;
                    for (j = i + 1; j < len && (ch = str.charAt(j)) != '>' && !Character.isWhitespace(ch); ++j) {
                    }
                    if (ch == '>' && i + 1 < j && j < len) {
                        set.add(str.substring(i + 1, j));
                    }
                    i = j;
                }
            }
        }
        return set;
    }

    public static String stripcslashes(String source) {
        if (source == null) {
            source = "";
        }
        StringBuilder result = new StringBuilder(source.length());
        int length = source.length();
        for (int i = 0; i < length; ++i) {
            int ch = source.charAt(i);
            if (ch == 92) {
                if (++i == length) {
                    ch = 92;
                } else {
                    ch = source.charAt(i);
                    switch (ch) {
                        case 97: {
                            ch = 7;
                            break;
                        }
                        case 98: {
                            ch = 8;
                            break;
                        }
                        case 116: {
                            ch = 9;
                            break;
                        }
                        case 110: {
                            ch = 10;
                            break;
                        }
                        case 118: {
                            ch = 11;
                            break;
                        }
                        case 102: {
                            ch = 12;
                            break;
                        }
                        case 114: {
                            ch = 13;
                            break;
                        }
                        case 120: {
                            int digitValue;
                            if (i + 1 == length || (digitValue = StringModule.hexToDigit(source.charAt(i + 1))) < 0) break;
                            ch = digitValue;
                            if (++i + 1 == length || (digitValue = StringModule.hexToDigit(source.charAt(i + 1))) < 0) break;
                            ch = ch << 4 | digitValue;
                            ++i;
                            break;
                        }
                        default: {
                            int digitValue = StringModule.octToDigit((char)ch);
                            if (digitValue < 0) break;
                            ch = digitValue;
                            if (i + 1 == length || (digitValue = StringModule.octToDigit(source.charAt(i + 1))) < 0) break;
                            ch = ch << 3 | digitValue;
                            if (++i + 1 == length || (digitValue = StringModule.octToDigit(source.charAt(i + 1))) < 0) break;
                            ch = ch << 3 | digitValue;
                            ++i;
                        }
                    }
                }
            }
            result.append((char)ch);
        }
        return result.toString();
    }

    public static Value stripos(Env env, StringValue haystack, Value needleV, @Optional int offset) {
        int len = haystack.length();
        if (len < offset) {
            env.warning(L.l("offset cannot exceed string length"));
            return BooleanValue.FALSE;
        }
        StringValue needle = needleV.isString() ? needleV.toStringValue(env) : StringValue.create((char)needleV.toInt());
        int pos = (haystack = haystack.toLowerCase()).indexOf(needle = needle.toLowerCase(), offset);
        if (pos < 0) {
            return BooleanValue.FALSE;
        }
        return LongValue.create(pos);
    }

    public static StringValue stripslashes(StringValue string) {
        StringValue sb = string.createStringBuilder();
        int len = string.length();
        for (int i = 0; i < len; ++i) {
            char ch = string.charAt(i);
            if (ch == '\\') {
                if (i + 1 >= len) continue;
                char ch2 = string.charAt(i + 1);
                if (ch2 == '0') {
                    ch2 = '\u0000';
                }
                sb.append(ch2);
                ++i;
                continue;
            }
            sb.append(ch);
        }
        return sb;
    }

    public static Value stristr(Env env, StringValue haystack, Value needleV) {
        CharSequence needleLower;
        if (needleV.isString()) {
            needleLower = needleV.toStringValue(env).toLowerCase();
        } else {
            char lower = Character.toLowerCase((char)needleV.toLong());
            needleLower = String.valueOf(lower);
        }
        StringValue haystackLower = haystack.toLowerCase();
        int i = haystackLower.indexOf(needleLower);
        if (i >= 0) {
            return haystack.substring(i);
        }
        return BooleanValue.FALSE;
    }

    public static Value strlen(Value value) {
        return LongValue.create(value.length());
    }

    public static int strnatcasecmp(StringValue a, StringValue b) {
        return StringModule.naturalOrderCompare(a, b, true);
    }

    public static int strnatcmp(StringValue a, StringValue b) {
        return StringModule.naturalOrderCompare(a, b, false);
    }

    private static int naturalOrderCompare(StringValue a, StringValue b, boolean ignoreCase) {
        SimpleStringReader aIn = new SimpleStringReader(a);
        SimpleStringReader bIn = new SimpleStringReader(b);
        int aChar = aIn.read();
        int bChar = bIn.read();
        if (aChar == -1 && bChar >= 0) {
            return -1;
        }
        if (aChar >= 0 && bChar == -1) {
            return 1;
        }
        while (true) {
            if (Character.isWhitespace(aChar)) {
                aChar = aIn.read();
                continue;
            }
            while (Character.isWhitespace(bChar)) {
                bChar = bIn.read();
            }
            if (aChar == -1 && bChar == -1) {
                return 0;
            }
            if (aChar == 48 && bChar == 48) {
                do {
                    aChar = aIn.read();
                    bChar = bIn.read();
                } while (aChar == 48 && bChar == 48);
                if (aChar == 48) {
                    if (49 <= bChar && bChar <= 57) {
                        return -1;
                    }
                    return 1;
                }
                if (bChar == 0) {
                    if (49 <= aChar && aChar <= 57) {
                        return 1;
                    }
                    return -1;
                }
            } else if (48 < aChar && aChar <= 57 && 48 < bChar && bChar <= 57) {
                int bInteger;
                int aInteger = aIn.readInt(aChar);
                if (aInteger > (bInteger = bIn.readInt(bChar))) {
                    return 1;
                }
                if (aInteger < bInteger) {
                    return -1;
                }
                aChar = aIn.read();
                bChar = bIn.read();
            }
            if (ignoreCase) {
                aChar = Character.toUpperCase(aChar);
                bChar = Character.toUpperCase(bChar);
            }
            if (aChar > bChar) {
                return 1;
            }
            if (aChar < bChar) {
                return -1;
            }
            aChar = aIn.read();
            bChar = bIn.read();
            if (aChar >= 0 && bChar == -1) {
                return 1;
            }
            if (aChar == -1 && bChar >= 0) break;
        }
        return -1;
    }

    public static Value strncasecmp(Env env, StringValue a, StringValue b, int length) {
        if (length < 0) {
            env.warning(L.l("strncasecmp() length '{0}' must be non-negative", length));
            return BooleanValue.FALSE;
        }
        int aLen = a.length();
        int bLen = b.length();
        for (int i = 0; i < length; ++i) {
            char bChar;
            if (aLen <= i) {
                return LongValue.MINUS_ONE;
            }
            if (bLen <= i) {
                return LongValue.ONE;
            }
            char aChar = Character.toUpperCase(a.charAt(i));
            if (aChar < (bChar = Character.toUpperCase(b.charAt(i)))) {
                return LongValue.MINUS_ONE;
            }
            if (bChar >= aChar) continue;
            return LongValue.ONE;
        }
        return LongValue.ZERO;
    }

    public static Value strncmp(Env env, StringValue a, StringValue b, int length) {
        if (length < 0) {
            env.warning(L.l("strncmp() length '{0}' must be non-negative", length));
            return BooleanValue.FALSE;
        }
        if (length < a.length()) {
            a = a.substring(0, length);
        }
        if (length < b.length()) {
            b = b.substring(0, length);
        }
        return LongValue.create(StringModule.strcmp(a, b));
    }

    public static Value strpbrk(StringValue haystack, StringValue charList) {
        int len = haystack.length();
        int sublen = charList.length();
        for (int i = 0; i < len; ++i) {
            for (int j = 0; j < sublen; ++j) {
                if (haystack.charAt(i) != charList.charAt(j)) continue;
                return haystack.substring(i);
            }
        }
        return BooleanValue.FALSE;
    }

    public static Value strpos(Env env, StringValue haystack, Value needleV, @Optional int offset) {
        if (offset > haystack.length()) {
            env.warning(L.l("offset cannot exceed string length"));
            return BooleanValue.FALSE;
        }
        StringValue needle = needleV.isString() ? needleV.toStringValue(env) : StringValue.create((char)needleV.toInt());
        int pos = haystack.indexOf(needle, offset);
        if (pos < 0) {
            return BooleanValue.FALSE;
        }
        return LongValue.create(pos);
    }

    public static Value strrchr(Env env, StringValue haystack, Value needleV) {
        CharSequence needle = needleV.isString() ? needleV.toStringValue(env) : String.valueOf((char)needleV.toLong());
        int i = haystack.lastIndexOf(needle);
        if (i > 0) {
            return haystack.substring(i);
        }
        return BooleanValue.FALSE;
    }

    public static Value strrev(StringValue string) {
        StringValue sb = string.createStringBuilder(string.length());
        for (int i = string.length() - 1; i >= 0; --i) {
            sb.append(string.charAt(i));
        }
        return sb;
    }

    public static Value strripos(Env env, String haystack, Value needleV, @Optional Value offsetV) {
        int offset;
        if (haystack == null) {
            haystack = "";
        }
        String needle = needleV.isString() ? needleV.toString() : String.valueOf((char)needleV.toInt());
        if (offsetV.isDefault()) {
            offset = haystack.length();
        } else {
            offset = offsetV.toInt();
            if (haystack.length() < offset) {
                env.warning(L.l("offset cannot exceed string length"));
                return BooleanValue.FALSE;
            }
        }
        haystack = haystack.toLowerCase(Locale.ENGLISH);
        needle = needle.toLowerCase(Locale.ENGLISH);
        int pos = haystack.lastIndexOf(needle, offset);
        if (pos < 0) {
            return BooleanValue.FALSE;
        }
        return LongValue.create(pos);
    }

    public static Value strrpos(Env env, StringValue haystack, Value needleV, @Optional Value offsetV) {
        StringValue needle = needleV.isString() ? needleV.toStringValue(env) : StringValue.create((char)needleV.toInt());
        int offset = haystack.length() - offsetV.toInt();
        if (offset < 0) {
            env.warning(L.l("offset cannot exceed string length"));
            return BooleanValue.FALSE;
        }
        int pos = haystack.lastIndexOf(needle, offset);
        if (pos < 0) {
            return BooleanValue.FALSE;
        }
        return LongValue.create(pos);
    }

    public static Value strspn(StringValue string, StringValue characters, @Optional int offset, @Optional(value="-2147483648") int length) {
        return StringModule.strspnImpl(string, characters, offset, length, true);
    }

    private static Value strspnImpl(StringValue string, StringValue characters, int offset, int length, boolean isMatch) {
        int strlen = string.length();
        if (offset < 0 && (offset += strlen) < 0) {
            offset = 0;
        }
        if (offset > strlen) {
            return BooleanValue.FALSE;
        }
        if (length == Integer.MIN_VALUE) {
            length = strlen;
        } else if (length < 0 && (length += strlen - offset) < 0) {
            length = 0;
        }
        int end = offset + length;
        if (strlen < end) {
            end = strlen;
        }
        int count = 0;
        while (offset < end) {
            boolean isPresent;
            char ch = string.charAt(offset);
            boolean bl = isPresent = characters.indexOf(ch) > -1;
            if (isPresent == isMatch) {
                ++count;
            } else {
                return LongValue.create(count);
            }
            ++offset;
        }
        return LongValue.create(count);
    }

    public static Value strstr(Env env, StringValue haystackV, Value needleV) {
        String needle;
        if (haystackV == null) {
            haystackV = env.getEmptyString();
        }
        if ((needle = needleV.isString() ? needleV.toString() : String.valueOf((char)needleV.toLong())).length() == 0) {
            env.warning("empty needle");
            return BooleanValue.FALSE;
        }
        int i = haystackV.indexOf(needle);
        if (i >= 0) {
            return haystackV.substring(i);
        }
        return BooleanValue.FALSE;
    }

    public static Value strtok(Env env, StringValue string1, @Optional Value string2) {
        Value result;
        char ch;
        StringValue characters;
        int offset;
        StringValue string;
        if (string2.isNull()) {
            StringValue savedString = (StringValue)env.getSpecialValue("caucho.strtok_string");
            Integer savedOffset = (Integer)env.getSpecialValue("caucho.strtok_offset");
            string = savedString == null ? env.getEmptyString() : savedString;
            offset = savedOffset == null ? 0 : savedOffset;
            characters = string1;
        } else {
            string = string1;
            offset = 0;
            characters = string2.toStringValue(env);
            env.setSpecialValue("caucho.strtok_string", string);
        }
        int strlen = string.length();
        while (offset < strlen && characters.indexOf(ch = string.charAt(offset)) >= 0) {
            ++offset;
        }
        if (offset == strlen) {
            result = BooleanValue.FALSE;
        } else {
            int start;
            char ch2;
            int end;
            for (end = start = offset; end < strlen && characters.indexOf(ch2 = string.charAt(end)) <= -1; ++end) {
            }
            for (offset = end; offset < strlen && characters.indexOf(ch2 = string.charAt(offset)) >= 0; ++offset) {
            }
            result = string.substring(start, end);
        }
        env.setSpecialValue("caucho.strtok_offset", offset);
        return result;
    }

    public static StringValue strtolower(StringValue string) {
        return string.toLowerCase();
    }

    public static StringValue strtoupper(StringValue string) {
        return string.toUpperCase();
    }

    public static StringValue strtr(Env env, StringValue string, Value fromV, @Optional StringValue to) {
        if (fromV.isArray()) {
            return StringModule.strtrArray(env, string, fromV.toArrayValue(env));
        }
        StringValue from = fromV.toStringValue(env);
        int len = from.length();
        if (to.length() < len) {
            len = to.length();
        }
        char[] map = new char[256];
        for (int i = len - 1; i >= 0; --i) {
            map[from.charAt((int)i)] = to.charAt(i);
        }
        StringValue sb = string.createStringBuilder();
        len = string.length();
        for (int i = 0; i < len; ++i) {
            char ch = string.charAt(i);
            if (map[ch] != '\u0000') {
                sb.append(map[ch]);
                continue;
            }
            sb.append(ch);
        }
        return sb;
    }

    private static StringValue strtrArray(Env env, StringValue string, ArrayValue map) {
        int size = map.getSize();
        StringValue[] fromList = new StringValue[size];
        StringValue[] toList = new StringValue[size];
        Map.Entry[] entryArray = new Map.Entry[size];
        int i = 0;
        for (Map.Entry<Value, Value> entry : map.entrySet()) {
            entryArray[i++] = entry;
        }
        Arrays.sort(entryArray, new StrtrComparator());
        boolean[] charSet = new boolean[256];
        for (i = 0; i < size; ++i) {
            fromList[i] = ((Value)entryArray[i].getKey()).toStringValue(env);
            toList[i] = ((Value)entryArray[i].getValue()).toStringValue(env);
            charSet[fromList[i].charAt((int)0)] = true;
        }
        StringValue result = string.createStringBuilder();
        int len = string.length();
        int head = 0;
        block2: while (head < len) {
            char ch = string.charAt(head);
            if (charSet.length <= ch || charSet[ch]) {
                block3: for (i = 0; i < fromList.length; ++i) {
                    StringValue from = fromList[i];
                    int fromLen = from.length();
                    if (head + fromLen > len || ch != from.charAt(0)) continue;
                    for (int j = 0; j < fromLen; ++j) {
                        if (string.charAt(head + j) != from.charAt(j)) continue block3;
                    }
                    result = result.append(toList[i]);
                    head += fromLen;
                    continue block2;
                }
            }
            result.append(ch);
            ++head;
        }
        return result;
    }

    public static Value substr(Env env, StringValue string, int start, @Optional Value lenV) {
        int end;
        int len = lenV.toInt();
        int strLen = string.length();
        if (start < 0) {
            start = strLen + start;
        }
        if (start < 0 || start >= strLen) {
            return BooleanValue.FALSE;
        }
        if (lenV.isDefault()) {
            return string.substring(start);
        }
        if (len == 0) {
            return StringValue.EMPTY;
        }
        if (len < 0) {
            end = strLen + len;
        } else {
            int n = end = strLen < len ? strLen : start + len;
        }
        if (end <= start) {
            return BooleanValue.FALSE;
        }
        if (strLen <= end) {
            return string.substring(start);
        }
        return string.substring(start, end);
    }

    public static Value substr_compare(Env env, StringValue mainStr, StringValue str, int offset, @Optional Value lenV, @Optional boolean isCaseInsensitive) {
        int strLen = mainStr.length();
        int len = lenV.toInt();
        if (!lenV.isDefault() && len == 0) {
            return BooleanValue.FALSE;
        }
        if (strLen < offset) {
            env.warning(L.l("offset can not be greater than length of string"));
            return BooleanValue.FALSE;
        }
        if (len > strLen || len + offset > strLen) {
            return BooleanValue.FALSE;
        }
        mainStr = StringModule.substr(env, mainStr, offset, lenV).toStringValue(env);
        str = StringModule.substr(env, str, 0, lenV).toStringValue(env);
        if (isCaseInsensitive) {
            return LongValue.create(StringModule.strcasecmp(mainStr, str));
        }
        return LongValue.create(StringModule.strcmp(mainStr, str));
    }

    public static Value substr_count(Env env, StringValue haystackV, StringValue needleV, @Optional int offset, @Optional(value="-1") int length) {
        String haystack = haystackV.toString();
        String needle = needleV.toString();
        if (needle.length() == 0) {
            env.warning(L.l("empty substr"));
            return BooleanValue.FALSE;
        }
        int haystackLength = haystack.length();
        if (offset < 0 || offset > haystackLength) {
            env.warning(L.l("offset cannot exceed string length", offset));
            return BooleanValue.FALSE;
        }
        if (length >= 0) {
            int newLength = offset + length;
            if (newLength < 0 || newLength > haystackLength) {
                env.warning(L.l("length cannot exceed string length", length));
                return BooleanValue.FALSE;
            }
            haystackLength = newLength;
        }
        int needleLength = needle.length();
        int count = 0;
        int end = haystackLength - needleLength + 1;
        for (int i = offset; i < end; ++i) {
            if (!haystack.startsWith(needle, i)) continue;
            ++count;
            i += needleLength;
        }
        return LongValue.create(count);
    }

    public static Value substr_replace(Env env, Value subjectV, StringValue replacement, Value startV, @Optional Value lengthV) {
        Iterator<Value> lengthIterator;
        int start = 0;
        int length = 0x3FFFFFFF;
        if (!lengthV.isNull() && !lengthV.isArray()) {
            length = lengthV.toInt();
        }
        if (!startV.isNull() && !startV.isArray()) {
            start = startV.toInt();
        }
        Iterator<Value> startIterator = startV.isArray() ? ((ArrayValue)startV).values().iterator() : null;
        Iterator<Value> iterator = lengthIterator = lengthV.isArray() ? ((ArrayValue)lengthV).values().iterator() : null;
        if (subjectV.isArray()) {
            ArrayValueImpl resultArray = new ArrayValueImpl();
            ArrayValue subjectArray = (ArrayValue)subjectV;
            for (Value value : subjectArray.values()) {
                if (lengthIterator != null && lengthIterator.hasNext()) {
                    length = lengthIterator.next().toInt();
                }
                if (startIterator != null && startIterator.hasNext()) {
                    start = startIterator.next().toInt();
                }
                Value result = StringModule.substrReplaceImpl(value.toStringValue(env), replacement, start, length);
                resultArray.append(result);
            }
            return resultArray;
        }
        if (lengthIterator != null && lengthIterator.hasNext()) {
            length = lengthIterator.next().toInt();
        }
        if (startIterator != null && startIterator.hasNext()) {
            start = startIterator.next().toInt();
        }
        return StringModule.substrReplaceImpl(subjectV.toStringValue(env), replacement, start, length);
    }

    private static Value substrReplaceImpl(StringValue string, StringValue replacement, int start, int len) {
        int strLen = string.length();
        if (start > strLen) {
            start = strLen;
        } else if (start < 0) {
            start = Math.max(strLen + start, 0);
        }
        int end = len < 0 ? Math.max(strLen + len, start) : (strLen < len ? strLen : start + len);
        StringValue result = string.createStringBuilder();
        result = result.append(string.substring(0, start));
        result = result.append(replacement);
        result = result.append(string.substring(end));
        return result;
    }

    public static Value trim(Env env, StringValue string, @Optional String characters) {
        char ch;
        int tail;
        char ch2;
        int head;
        boolean[] trim = characters == null || characters.equals("") ? TRIM_WHITESPACE : StringModule.parseCharsetBitmap(env, characters.toString());
        int len = string.length();
        for (head = 0; head < len && (ch2 = string.charAt(head)) < '\u0100' && trim[ch2]; ++head) {
        }
        for (tail = len - 1; tail >= 0 && (ch = string.charAt(tail)) < '\u0100' && trim[ch]; --tail) {
        }
        if (head == 0 && tail == len - 1) {
            return string;
        }
        if (tail < head) {
            return env.getEmptyString();
        }
        return string.substring(head, tail + 1);
    }

    public static StringValue ucfirst(Env env, StringValue string) {
        if (string == null) {
            return env.getEmptyString();
        }
        if (string.length() == 0) {
            return string;
        }
        StringValue sb = string.createStringBuilder();
        sb = sb.append(Character.toUpperCase(string.charAt(0)));
        sb = sb.append(string, 1, string.length());
        return sb;
    }

    public static String ucwords(String string) {
        if (string == null) {
            string = "";
        }
        int strLen = string.length();
        boolean isStart = true;
        StringBuilder sb = new StringBuilder();
        block3: for (int i = 0; i < strLen; ++i) {
            char ch = string.charAt(i);
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    isStart = true;
                    sb.append(ch);
                    continue block3;
                }
                default: {
                    if (isStart) {
                        sb.append(Character.toUpperCase(ch));
                    } else {
                        sb.append(ch);
                    }
                    isStart = false;
                }
            }
        }
        return sb.toString();
    }

    public static int vprintf(Env env, StringValue format, @NotNull ArrayValue array) {
        Value[] args;
        if (array != null) {
            args = new Value[array.getSize()];
            int i = 0;
            for (Value value : array.values()) {
                args[i++] = value;
            }
        } else {
            args = new Value[]{};
        }
        return StringModule.printf(env, format, args);
    }

    public static Value vsprintf(Env env, StringValue format, @NotNull ArrayValue array) {
        Value[] args;
        if (array != null) {
            args = new Value[array.getSize()];
            int i = 0;
            for (Value value : array.values()) {
                args[i++] = value;
            }
        } else {
            args = new Value[]{};
        }
        return StringModule.sprintf(env, format, args);
    }

    public static Value wordwrap(Env env, @Expect(type=Expect.Type.STRING) Value value, @Optional @Expect(type=Expect.Type.NUMERIC) Value widthV, @Optional @Expect(type=Expect.Type.STRING) Value breakV, @Optional @Expect(type=Expect.Type.BOOLEAN) Value cutV) {
        int len;
        if (value instanceof UnexpectedValue) {
            env.warning(L.l("word must be a string, but {0} given", (Object)value.getType()));
            return NullValue.NULL;
        }
        if (widthV instanceof UnexpectedValue) {
            env.warning(L.l("width must be numeric, but {0} given", (Object)widthV.getType()));
            return NullValue.NULL;
        }
        int width = 0;
        width = widthV.isDefault() ? 75 : widthV.toInt();
        String string = value.toString();
        if (cutV instanceof UnexpectedValue) {
            env.warning(L.l("cut must be a boolean, but {0} given", (Object)cutV.getType()));
            return NullValue.NULL;
        }
        boolean isCut = cutV.toBoolean();
        if (isCut && width == 0 && string.length() > 0) {
            env.warning(L.l("cannot cut string to width 0"));
            return BooleanValue.FALSE;
        }
        int n = len = string != null ? string.length() : 0;
        if (breakV instanceof UnexpectedValue) {
            env.warning(L.l("break string must be a string, but {0} given", (Object)breakV.getType()));
            return NullValue.NULL;
        }
        String breakString = "\n";
        if (!breakV.isDefault()) {
            breakString = breakV.toString();
        }
        if (breakString == null || breakString.length() == 0) {
            env.warning(L.l("break string cannot be empty"));
            return BooleanValue.FALSE;
        }
        int breakLen = breakString.length();
        char breakChar = breakLen == 0 ? (char)'\uffffffff' : (char)breakString.charAt(0);
        int head = 0;
        int lastSpace = 0;
        StringValue sb = env.createStringBuilder();
        for (int i = 0; i < len; ++i) {
            char ch = string.charAt(i);
            if (ch == breakChar && string.regionMatches(i, breakString, 0, breakLen)) {
                sb.append(string, head, i + breakLen);
                head = i + breakLen;
                continue;
            }
            if (width <= i - head) {
                if (ch == ' ') {
                    sb.append(string, head, i);
                    sb.append(breakString);
                    head = i + 1;
                    continue;
                }
                if (head < lastSpace) {
                    sb.append(string, head, lastSpace);
                    sb.append(breakString);
                    head = lastSpace + 1;
                    continue;
                }
                if (!isCut) continue;
                sb.append(string, head, i);
                sb.append(breakString);
                head = i;
                continue;
            }
            if (ch != ' ') continue;
            lastSpace = i;
        }
        if (head < len) {
            sb.append(string, head, len);
        }
        return sb;
    }

    protected static boolean isWhitespace(char ch) {
        return ch == ' ' || ch == '\t' || ch == '\n' || ch == '\r';
    }

    protected static char toUpperCase(char ch) {
        if (ch >= 'a' && ch <= 'z') {
            return (char)(65 + (ch - 97));
        }
        return ch;
    }

    protected static char toUUChar(int d) {
        if (d == 0) {
            return '`';
        }
        return (char)(32 + (d & 0x3F));
    }

    protected static char toHexChar(int d) {
        if ((d &= 0xF) < 10) {
            return (char)(d + 48);
        }
        return (char)(d - 10 + 97);
    }

    protected static char toUpperHexChar(int d) {
        if ((d &= 0xF) < 10) {
            return (char)(d + 48);
        }
        return (char)(d - 10 + 65);
    }

    protected static int hexToDigit(char ch) {
        if ('0' <= ch && ch <= '9') {
            return ch - 48;
        }
        if ('a' <= ch && ch <= 'f') {
            return ch - 97 + 10;
        }
        if ('A' <= ch && ch <= 'F') {
            return ch - 65 + 10;
        }
        return -1;
    }

    protected static int octToDigit(char ch) {
        if ('0' <= ch && ch <= '7') {
            return ch - 48;
        }
        return -1;
    }

    static {
        BIG_TEN = new BigInteger("10");
        BIG_2_64 = BigInteger.ONE.shiftLeft(64);
        _md5FreeList = new FreeList(16);
        TRIM_WHITESPACE = new boolean[256];
        StringModule.TRIM_WHITESPACE[0] = true;
        StringModule.TRIM_WHITESPACE[8] = true;
        StringModule.TRIM_WHITESPACE[32] = true;
        StringModule.TRIM_WHITESPACE[9] = true;
        StringModule.TRIM_WHITESPACE[13] = true;
        StringModule.TRIM_WHITESPACE[10] = true;
        StringModule.TRIM_WHITESPACE[11] = true;
        SOUNDEX_VALUES = "01230120022455012623010202".toCharArray();
        DEFAULT_DECIMAL_FORMAT_SYMBOLS = new DecimalFormatSymbols();
        DEFAULT_DECIMAL_FORMAT_SYMBOLS.setDecimalSeparator('.');
        DEFAULT_DECIMAL_FORMAT_SYMBOLS.setGroupingSeparator(',');
        DEFAULT_DECIMAL_FORMAT_SYMBOLS.setZeroDigit('0');
    }

    static class ScanfString
    extends ScanfSegment {
        private final int _maxLen;

        ScanfString(int maxLen) {
            if (maxLen < 0) {
                maxLen = Integer.MAX_VALUE;
            }
            this._maxLen = maxLen;
        }

        public boolean isAssigned() {
            return true;
        }

        public int apply(StringValue string, int strlen, int sIndex, Value var, boolean isReturnArray) {
            char ch;
            if (sIndex == strlen) {
                if (isReturnArray) {
                    var.put(NullValue.NULL);
                }
                return sIndex;
            }
            StringValue sb = string.createStringBuilder();
            int maxLen = this._maxLen;
            while (sIndex < strlen && maxLen-- > 0 && !StringModule.isWhitespace(ch = string.charAt(sIndex))) {
                sb.append(ch);
                ++sIndex;
            }
            this.sscanfPut(var, sb, isReturnArray);
            return sIndex;
        }
    }

    static class ScanfIntegerWithBaseDetection
    extends ScanfSegment {
        private final int _maxLen;

        ScanfIntegerWithBaseDetection(int maxLen) {
            if (maxLen < 0) {
                maxLen = Integer.MAX_VALUE;
            }
            this._maxLen = maxLen;
        }

        public boolean isAssigned() {
            return true;
        }

        public int apply(StringValue string, int strlen, int sIndex, Value var, boolean isReturnArray) {
            char ch;
            if (sIndex == strlen) {
                if (isReturnArray) {
                    var.put(NullValue.NULL);
                }
                return sIndex;
            }
            long val = 0L;
            int sign = 1;
            int maxLen = this._maxLen;
            if (sIndex < strlen) {
                char ch2 = string.charAt(sIndex);
                if (ch2 == '+') {
                    ++sIndex;
                    --maxLen;
                } else if (ch2 == '-') {
                    sign = -1;
                    ++sIndex;
                    --maxLen;
                }
            }
            int base = 10;
            if (sIndex < strlen && (ch = string.charAt(sIndex)) == '0') {
                if (++sIndex < strlen && Character.toLowerCase(string.charAt(sIndex)) == 'x') {
                    base = 16;
                    ++sIndex;
                } else {
                    base = 8;
                }
            }
            boolean isNotMatched = true;
            while (sIndex < strlen && maxLen-- > 0) {
                char ch3 = string.charAt(sIndex);
                int digit = ScanfIntegerWithBaseDetection.toNumber(base, ch3);
                if (digit < 0) {
                    if (!isNotMatched) break;
                    this.sscanfPut(var, NullValue.NULL, isReturnArray);
                    return sIndex;
                }
                val = val * (long)base + (long)digit;
                isNotMatched = false;
                ++sIndex;
            }
            this.sscanfPut(var, LongValue.create(val * (long)sign), isReturnArray);
            return sIndex;
        }

        private static int toNumber(int base, char ch) {
            switch (base) {
                case 10: {
                    return ScanfIntegerWithBaseDetection.base10ToNumber(ch);
                }
                case 8: {
                    return ScanfIntegerWithBaseDetection.base8ToNumber(ch);
                }
                case 16: {
                    return ScanfIntegerWithBaseDetection.base16ToNumber(ch);
                }
            }
            throw new IllegalStateException();
        }

        private static int base10ToNumber(char ch) {
            if ('0' <= ch && ch <= '9') {
                return ch - 48;
            }
            return -1;
        }

        private static int base8ToNumber(char ch) {
            if ('0' <= ch && ch <= '7') {
                return ch - 48;
            }
            return -1;
        }

        private static int base16ToNumber(char ch) {
            if ('0' <= ch && ch <= '9') {
                return ch - 48;
            }
            if ('a' <= ch && ch <= 'f') {
                return ch - 97 + 10;
            }
            if ('A' <= ch && ch <= 'F') {
                return ch - 65 + 10;
            }
            return -1;
        }
    }

    static class ScanfInteger
    extends ScanfSegment {
        private final int _maxLen;
        private final int _base;
        private final boolean _isUnsigned;

        ScanfInteger(int maxLen, int base, boolean isUnsigned) {
            if (maxLen < 0) {
                maxLen = Integer.MAX_VALUE;
            }
            this._maxLen = maxLen;
            this._base = base;
            this._isUnsigned = isUnsigned;
        }

        public boolean isAssigned() {
            return true;
        }

        public int apply(StringValue string, int strlen, int sIndex, Value var, boolean isReturnArray) {
            if (sIndex == strlen) {
                if (isReturnArray) {
                    var.put(NullValue.NULL);
                }
                return sIndex;
            }
            int val = 0;
            int sign = 1;
            boolean isNotMatched = true;
            int maxLen = this._maxLen;
            if (sIndex < strlen) {
                char ch = string.charAt(sIndex);
                if (ch == '+') {
                    ++sIndex;
                    --maxLen;
                } else if (ch == '-') {
                    sign = -1;
                    ++sIndex;
                    --maxLen;
                }
            }
            int base = this._base;
            int topRange = base + 48;
            while (sIndex < strlen && maxLen-- > 0) {
                char ch = string.charAt(sIndex);
                if ('0' > ch || ch >= topRange) {
                    if (!isNotMatched) break;
                    this.sscanfPut(var, NullValue.NULL, isReturnArray);
                    return sIndex;
                }
                val = val * base + ch - 48;
                isNotMatched = false;
                ++sIndex;
            }
            if (this._isUnsigned) {
                if (sign == -1 && val != 0) {
                    this.sscanfPut(var, StringValue.create(0xFFFFFFFFL - (long)val + 1L), isReturnArray);
                } else {
                    this.sscanfPut(var, LongValue.create(val), isReturnArray);
                }
            } else {
                this.sscanfPut(var, LongValue.create(val * sign), isReturnArray);
            }
            return sIndex;
        }
    }

    static class ScanfHex
    extends ScanfSegment {
        private final int _maxLen;

        ScanfHex(int maxLen) {
            if (maxLen < 0) {
                maxLen = Integer.MAX_VALUE;
            }
            this._maxLen = maxLen;
        }

        public boolean isAssigned() {
            return true;
        }

        public int apply(StringValue string, int strlen, int sIndex, Value var, boolean isReturnArray) {
            char ch;
            if (sIndex == strlen) {
                if (isReturnArray) {
                    var.put(NullValue.NULL);
                }
                return sIndex;
            }
            int val = 0;
            int sign = 1;
            boolean isMatched = false;
            int maxLen = this._maxLen;
            if (sIndex < strlen) {
                ch = string.charAt(sIndex);
                if (ch == '+') {
                    ++sIndex;
                    --maxLen;
                } else if (ch == '-') {
                    sign = -1;
                    ++sIndex;
                    --maxLen;
                }
            }
            while (sIndex < strlen && maxLen-- > 0) {
                ch = string.charAt(sIndex);
                if ('0' <= ch && ch <= '9') {
                    val = val * 16 + ch - 48;
                    isMatched = true;
                } else if ('a' <= ch && ch <= 'f') {
                    val = val * 16 + ch - 97 + 10;
                    isMatched = true;
                } else if ('A' <= ch && ch <= 'F') {
                    val = val * 16 + ch - 65 + 10;
                    isMatched = true;
                } else {
                    if (isMatched) break;
                    this.sscanfPut(var, NullValue.NULL, isReturnArray);
                    return sIndex;
                }
                ++sIndex;
            }
            this.sscanfPut(var, LongValue.create(val * sign), isReturnArray);
            return sIndex;
        }
    }

    static class ScanfScientific
    extends ScanfSegment {
        private final int _maxLen;

        ScanfScientific(int maxLen) {
            if (maxLen < 0) {
                maxLen = Integer.MAX_VALUE;
            }
            this._maxLen = maxLen;
        }

        public boolean isAssigned() {
            return true;
        }

        public int apply(StringValue s, int strlen, int i, Value var, boolean isReturnArray) {
            int start;
            block13: {
                int e;
                int maxLen;
                int ch;
                int len;
                block16: {
                    block15: {
                        block14: {
                            if (i == strlen) {
                                if (isReturnArray) {
                                    var.put(NullValue.NULL);
                                }
                                return i;
                            }
                            start = i;
                            len = strlen;
                            ch = 0;
                            maxLen = this._maxLen;
                            if (i < len && maxLen > 0) {
                                char c = s.charAt(i);
                                ch = c;
                                if (c == '+' || ch == 45) {
                                    ++i;
                                    --maxLen;
                                }
                            }
                            while (i < len && maxLen > 0) {
                                char c = s.charAt(i);
                                ch = c;
                                if ('0' > c || ch > 57) break;
                                --maxLen;
                                ++i;
                            }
                            if (ch == 46) {
                                --maxLen;
                                ++i;
                                while (i < len && maxLen > 0) {
                                    char c = s.charAt(i);
                                    ch = c;
                                    if ('0' > c || ch > 57) break;
                                    --maxLen;
                                    ++i;
                                }
                            }
                            if (ch != 101 && ch != 69) break block13;
                            --maxLen;
                            if (start == (e = i++)) {
                                this.sscanfPut(var, NullValue.NULL, isReturnArray);
                                return start;
                            }
                            if (i >= len || maxLen <= 0) break block14;
                            char c = s.charAt(i);
                            ch = c;
                            if (c == '+') break block15;
                        }
                        if (ch != 45) break block16;
                    }
                    ++i;
                    --maxLen;
                }
                while (i < len && maxLen > 0) {
                    char c = s.charAt(i);
                    ch = c;
                    if ('0' > c || ch > 57) break;
                    --maxLen;
                    ++i;
                }
                if (i == e + 1) {
                    i = e;
                }
            }
            double val = i == 0 ? 0.0 : Double.parseDouble(s.substring(start, i).toString());
            this.sscanfPut(var, DoubleValue.create(val), isReturnArray);
            return i;
        }
    }

    static class ScanfSetNegated
    extends ScanfSegment {
        private IntSet _set;

        private ScanfSetNegated(IntSet set) {
            this._set = set;
        }

        public boolean isAssigned() {
            return true;
        }

        public int apply(StringValue string, int strlen, int sIndex, Value var, boolean isReturnArray) {
            char ch;
            StringValue sb = string.createStringBuilder();
            while (sIndex < strlen && !this._set.contains(ch = string.charAt(sIndex))) {
                sb.append(ch);
                ++sIndex;
            }
            if (sb.length() > 0) {
                this.sscanfPut(var, sb, isReturnArray);
            } else if (isReturnArray) {
                var.put(NullValue.NULL);
            }
            return sIndex;
        }
    }

    static class ScanfSet
    extends ScanfSegment {
        private IntSet _set;

        private ScanfSet(IntSet set) {
            this._set = set;
        }

        public boolean isAssigned() {
            return true;
        }

        public int apply(StringValue string, int strlen, int sIndex, Value var, boolean isReturnArray) {
            char ch;
            StringValue sb = string.createStringBuilder();
            while (sIndex < strlen && this._set.contains(ch = string.charAt(sIndex))) {
                sb.append(ch);
                ++sIndex;
            }
            if (sb.length() > 0) {
                this.sscanfPut(var, sb, isReturnArray);
            } else if (isReturnArray) {
                var.put(NullValue.NULL);
            }
            return sIndex;
        }
    }

    static class ScanfStringLength
    extends ScanfSegment {
        static final ScanfStringLength SEGMENT = new ScanfStringLength();

        private ScanfStringLength() {
        }

        public boolean isAssigned() {
            return true;
        }

        public int apply(StringValue string, int strlen, int sIndex, Value var, boolean isReturnArray) {
            this.sscanfPut(var, LongValue.create(sIndex), isReturnArray);
            return sIndex;
        }
    }

    static class ScanfWhitespace
    extends ScanfSegment {
        static final ScanfWhitespace SEGMENT = new ScanfWhitespace();

        private ScanfWhitespace() {
        }

        public boolean isAssigned() {
            return false;
        }

        public int apply(StringValue string, int strlen, int sIndex, Value var, boolean isReturnArray) {
            while (sIndex < strlen && StringModule.isWhitespace(string.charAt(sIndex))) {
                ++sIndex;
            }
            return sIndex;
        }
    }

    static class ScanfConstant
    extends ScanfSegment {
        private final String _string;
        private final int _strlen;

        private ScanfConstant(String string) {
            this._string = string;
            this._strlen = string.length();
        }

        public boolean isAssigned() {
            return false;
        }

        public int apply(StringValue string, int strlen, int sIndex, Value var, boolean isReturnArray) {
            int fStrlen = this._strlen;
            String fString = this._string;
            if (strlen - sIndex < fStrlen) {
                return -1;
            }
            for (int i = 0; i < fStrlen; ++i) {
                if (string.charAt(sIndex++) == fString.charAt(i)) continue;
                return -1;
            }
            return sIndex;
        }
    }

    static abstract class ScanfSegment {
        ScanfSegment() {
        }

        public abstract boolean isAssigned();

        public abstract int apply(StringValue var1, int var2, int var3, Value var4, boolean var5);

        void sscanfPut(Value var, Value val, boolean isReturnArray) {
            if (isReturnArray) {
                var.put(val);
            } else {
                var.set(val);
            }
        }
    }

    static class SimpleStringReader {
        StringValue _str;
        int _length;
        int _index;

        SimpleStringReader(StringValue str) {
            this._str = str;
            this._length = str.length();
            this._index = 0;
        }

        int read() {
            if (this._index < this._length) {
                return this._str.charAt(this._index++);
            }
            return -1;
        }

        int peek() {
            if (this._index < this._length) {
                return this._str.charAt(this._index);
            }
            return -1;
        }

        int readInt(int currChar) {
            int number = currChar - 48;
            while (48 <= (currChar = this.peek()) && currChar <= 57) {
                number = number * 10 + currChar - 48;
                ++this._index;
            }
            return number;
        }
    }

    static class CharPrintfSegment
    extends StringPrintfSegment {
        CharPrintfSegment(StringBuilder prefix, boolean isLeft, int pad, boolean isUpper, int width, String format, int index) {
            super(prefix, isLeft, pad, isUpper, width, format, index);
        }

        protected StringValue toValue(Env env, Value[] args) {
            if (args.length <= this._index) {
                return env.getEmptyString();
            }
            Value v = args[this._index];
            if (v.isLongConvertible()) {
                return env.createString((char)v.toLong());
            }
            return v.charValueAt(0L).toStringValue(env);
        }
    }

    static class StringPrintfSegment
    extends PrintfSegment {
        protected final char[] _prefix;
        protected final int _min;
        protected final int _max;
        protected final boolean _isLeft;
        protected final boolean _isUpper;
        protected final char _pad;
        protected final int _index;

        StringPrintfSegment(StringBuilder prefix, boolean isLeft, int pad, boolean isUpper, int width, String format, int index) {
            this._prefix = new char[prefix.length()];
            this._isLeft = isLeft;
            this._isUpper = isUpper;
            this._pad = pad >= 0 ? (char)pad : (char)32;
            prefix.getChars(0, this._prefix.length, this._prefix, 0);
            if (StringPrintfSegment.hasIndex(format)) {
                index = StringPrintfSegment.getIndex(format);
                format = StringPrintfSegment.getIndexFormat(format);
            }
            int i = 0;
            int len = format.length();
            int min = width;
            int max = Integer.MAX_VALUE;
            int ch = 32;
            if (0 < len && format.charAt(0) == '.') {
                max = 0;
                ++i;
                while (i < len) {
                    char c = format.charAt(i);
                    ch = c;
                    if ('0' > c || ch > 57) break;
                    max = 10 * max + ch - 48;
                    ++i;
                }
            }
            this._min = min;
            this._max = max;
            this._index = index;
        }

        protected StringValue toValue(Env env, Value[] args) {
            return args[this._index].toStringValue(env);
        }

        public boolean apply(Env env, StringValue sb, Value[] args) {
            int i;
            sb.append(this._prefix, 0, this._prefix.length);
            if (this._index >= args.length) {
                env.warning(L.l("printf(): not enough arguments to match format."));
                return false;
            }
            StringValue value = this.toValue(env, args);
            int len = value.length();
            if (this._max < len) {
                value = value.substring(0, this._max);
                len = this._max;
            }
            if (this._isUpper) {
                value = value.toUpperCase(Locale.ENGLISH);
            }
            if (!this._isLeft) {
                for (i = len; i < this._min; ++i) {
                    sb.append(this._pad);
                }
            }
            sb.append(value);
            if (this._isLeft) {
                for (i = len; i < this._min; ++i) {
                    sb.append(this._pad);
                }
            }
            return true;
        }
    }

    static class DoublePrintfSegment
    extends PrintfSegment {
        private final String _format;
        private final boolean _isLeftZero;
        private final int _index;
        private final QuercusLocale _locale;

        DoublePrintfSegment(String format, boolean isLeftZero, int index, QuercusLocale locale) {
            if (DoublePrintfSegment.hasIndex(format)) {
                this._index = DoublePrintfSegment.getIndex(format);
                this._format = DoublePrintfSegment.getIndexFormat(format);
            } else {
                this._format = '%' + format;
                this._index = index;
            }
            this._isLeftZero = isLeftZero;
            this._locale = locale;
        }

        public boolean apply(Env env, StringValue sb, Value[] args) {
            if (this._index >= args.length) {
                env.warning(L.l("printf(): not enough arguments to match format."));
                return false;
            }
            double value = args[this._index].toDouble();
            String s = this._locale == null ? String.format(this._format, value) : String.format(this._locale.getLocale(), this._format, value);
            if (this._isLeftZero) {
                int len = s.length();
                for (int i = 0; i < len; ++i) {
                    char ch = s.charAt(i);
                    if (ch == ' ') {
                        sb.append('0');
                        continue;
                    }
                    sb.append(ch);
                }
            } else {
                sb.append(s);
            }
            return true;
        }
    }

    static class BinaryPrintfSegment
    extends PrintfSegment {
        private final int _index;
        private final int _min;
        private final char _pad;

        BinaryPrintfSegment(int index, int min, int pad) {
            this._index = index;
            this._min = min;
            this._pad = pad >= 0 ? (char)pad : (char)32;
        }

        static BinaryPrintfSegment create(String format, int index) {
            int length = format.length();
            int offset = 1;
            int pad = 32;
            if (format.charAt(offset) == ' ') {
                pad = 32;
                ++offset;
            } else if (format.charAt(offset) == '0') {
                pad = 48;
                ++offset;
            }
            int min = 0;
            while (offset < length - 1) {
                char ch = format.charAt(offset);
                if ('0' > ch || ch > '9') {
                    return null;
                }
                min = 10 * min + ch - 48;
                ++offset;
            }
            return new BinaryPrintfSegment(index, min, pad);
        }

        public boolean apply(Env env, StringValue sb, Value[] args) {
            int i;
            if (this._index < 0 || this._index >= args.length) {
                env.warning(L.l("printf(): not enough arguments to match format."));
                return false;
            }
            long value = args[this._index].toLong();
            int digits = 0;
            long shift = value;
            for (i = 0; i < 64; ++i) {
                if (shift != 0L) {
                    digits = i;
                }
                shift >>>= 1;
            }
            for (i = digits + 1; i < this._min; ++i) {
                sb.append(this._pad);
            }
            while (digits >= 0) {
                int digit = (int)(value >>> digits) & 1;
                sb.append((char)(48 + digit));
                --digits;
            }
            return true;
        }
    }

    static class UnsignedPrintfSegment
    extends PrintfSegment {
        private final int _index;
        private final int _min;
        private final char _pad;

        UnsignedPrintfSegment(int index, int min, int pad) {
            this._index = index;
            this._min = min;
            this._pad = pad >= 0 ? (char)pad : (char)32;
        }

        static UnsignedPrintfSegment create(String format, int index) {
            int length = format.length();
            int offset = 1;
            if (format.charAt(offset) == '+') {
                ++offset;
            }
            int pad = 32;
            if (format.charAt(offset) == ' ') {
                pad = 32;
                ++offset;
            } else if (format.charAt(offset) == '0') {
                pad = 48;
                ++offset;
            }
            int min = 0;
            while (offset < length - 1) {
                char ch = format.charAt(offset);
                if ('0' > ch || ch > '9') {
                    return null;
                }
                min = 10 * min + ch - 48;
                ++offset;
            }
            return new UnsignedPrintfSegment(index, min, pad);
        }

        public boolean apply(Env env, StringValue sb, Value[] args) {
            long value;
            if (this._index < 0 || this._index >= args.length) {
                env.warning(L.l("printf(): not enough arguments to match format."));
                return false;
            }
            char[] buf = new char[32];
            int digits = buf.length;
            if (value == 0L) {
                buf[--digits] = 48;
            } else if (value > 0L) {
                for (value = args[this._index].toLong(); value != 0L; value /= 10L) {
                    int digit = (int)(value % 10L);
                    buf[--digits] = (char)(48 + digit);
                }
            } else {
                BigInteger bigInt = new BigInteger(String.valueOf(value));
                bigInt = bigInt.add(BIG_2_64);
                while (bigInt.compareTo(BigInteger.ZERO) != 0) {
                    int digit = bigInt.mod(BIG_TEN).intValue();
                    buf[--digits] = (char)(48 + digit);
                    bigInt = bigInt.divide(BIG_TEN);
                }
            }
            for (int i = buf.length - digits; i < this._min; ++i) {
                sb.append(this._pad);
            }
            while (digits < buf.length) {
                sb.append(buf[digits]);
                ++digits;
            }
            return true;
        }
    }

    static class HexPrintfSegment
    extends PrintfSegment {
        private final int _index;
        private final int _min;
        private final char _pad;
        private boolean _isUpper;

        HexPrintfSegment(int index, int min, int pad, boolean isUpper) {
            this._index = index;
            this._min = min;
            this._pad = pad >= 0 ? (char)pad : (char)32;
            this._isUpper = isUpper;
        }

        static HexPrintfSegment create(String format, int index) {
            int length = format.length();
            int offset = 1;
            boolean isUpper = format.charAt(length - 1) == 'X';
            int pad = 32;
            if (format.charAt(offset) == ' ') {
                pad = 32;
                ++offset;
            } else if (format.charAt(offset) == '0') {
                pad = 48;
                ++offset;
            }
            int min = 0;
            while (offset < length - 1) {
                char ch = format.charAt(offset);
                if ('0' > ch || ch > '9') {
                    return null;
                }
                min = 10 * min + ch - 48;
                ++offset;
            }
            return new HexPrintfSegment(index, min, pad, isUpper);
        }

        public boolean apply(Env env, StringValue sb, Value[] args) {
            int i;
            if (this._index < 0 || this._index >= args.length) {
                env.warning(L.l("printf(): not enough arguments to match format."));
                return false;
            }
            long value = args[this._index].toLong();
            int digits = 0;
            long shift = value;
            for (i = 0; i < 16; ++i) {
                if (shift != 0L) {
                    digits = i;
                }
                shift >>>= 4;
            }
            for (i = digits + 1; i < this._min; ++i) {
                sb.append(this._pad);
            }
            while (digits >= 0) {
                int digit = (int)(value >>> 4 * digits) & 0xF;
                if (digit <= 9) {
                    sb.append((char)(48 + digit));
                } else if (this._isUpper) {
                    sb.append((char)(65 + digit - 10));
                } else {
                    sb.append((char)(97 + digit - 10));
                }
                --digits;
            }
            return true;
        }
    }

    static class LongPrintfSegment
    extends PrintfSegment {
        private final String _format;
        private final int _index;
        private final QuercusLocale _locale;

        private LongPrintfSegment(String format, int index, QuercusLocale locale) {
            this._format = format;
            this._index = index;
            this._locale = locale;
        }

        static PrintfSegment create(Env env, String format, int index) {
            UnsignedPrintfSegment unsign;
            BinaryPrintfSegment bin;
            HexPrintfSegment hex;
            if (LongPrintfSegment.hasIndex(format)) {
                index = LongPrintfSegment.getIndex(format);
                format = LongPrintfSegment.getIndexFormat(format);
            } else {
                format = '%' + format;
            }
            if (format.length() > 1 && format.charAt(1) == '.') {
                char ch;
                int i;
                for (i = 2; i < format.length() && '0' <= (ch = format.charAt(i)) && ch <= '9'; ++i) {
                }
                format = '%' + format.substring(i);
            }
            if ((format.charAt(format.length() - 1) == 'x' || format.charAt(format.length() - 1) == 'X') && (hex = HexPrintfSegment.create(format, index)) != null) {
                return hex;
            }
            if ((format.charAt(format.length() - 1) == 'b' || format.charAt(format.length() - 1) == 'B') && (bin = BinaryPrintfSegment.create(format, index)) != null) {
                return bin;
            }
            if (format.charAt(format.length() - 1) == 'u' && (unsign = UnsignedPrintfSegment.create(format, index)) != null) {
                return unsign;
            }
            return new LongPrintfSegment(format, index, env.getLocaleInfo().getNumeric());
        }

        public boolean apply(Env env, StringValue sb, Value[] args) {
            if (this._index >= args.length) {
                env.warning(L.l("printf(): not enough arguments to match format."));
                return false;
            }
            long value = args[this._index].toLong();
            sb.append(String.format(this._locale.getLocale(), this._format, value));
            return true;
        }
    }

    static class TextPrintfSegment
    extends PrintfSegment {
        private final char[] _text;

        TextPrintfSegment(StringBuilder text) {
            this._text = new char[text.length()];
            text.getChars(0, this._text.length, this._text, 0);
        }

        public boolean apply(Env env, StringValue sb, Value[] args) {
            sb.append(this._text, 0, this._text.length);
            return true;
        }
    }

    static abstract class PrintfSegment {
        PrintfSegment() {
        }

        public abstract boolean apply(Env var1, StringValue var2, Value[] var3);

        static boolean hasIndex(String format) {
            return format.indexOf(36) >= 0;
        }

        static int getIndex(String format) {
            char ch;
            int value = 0;
            for (int i = 0; i < format.length() && '0' <= (ch = format.charAt(i)) && ch <= '9'; ++i) {
                value = 10 * value + ch - 48;
            }
            return value - 1;
        }

        static String getIndexFormat(String format) {
            int p = format.indexOf(36);
            return '%' + format.substring(p + 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class StrtrComparator<T extends Map.Entry<Value, Value>>
    implements Comparator<T> {
        StrtrComparator() {
        }

        @Override
        public int compare(T a, T b) {
            int lenB;
            int lenA = ((Value)a.getKey()).length();
            if (lenA < (lenB = ((Value)b.getKey()).length())) {
                return 1;
            }
            if (lenA == lenB) {
                return 0;
            }
            return -1;
        }
    }
}

