/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.marshal;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.marshal.Marshal;

public class LongMarshal
extends Marshal {
    public static final Marshal MARSHAL = new LongMarshal();

    public boolean isLong() {
        return true;
    }

    public boolean isReadOnly() {
        return true;
    }

    public Object marshal(Env env, Expr expr, Class expectedClass) {
        return new Long(expr.evalLong(env));
    }

    public Object marshal(Env env, Value value, Class expectedClass) {
        return new Long(value.toLong());
    }

    public Value unmarshal(Env env, Object value) {
        if (value == null) {
            return LongValue.ZERO;
        }
        return LongValue.create(((Number)value).longValue());
    }

    protected int getMarshalingCostImpl(Value argValue) {
        return argValue.toLongMarshalCost();
    }

    public Class getExpectedClass() {
        return Long.TYPE;
    }
}

