/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.module;

import com.caucho.quercus.QuercusExitException;
import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.env.JavaInvoker;
import com.caucho.quercus.module.ModuleContext;
import com.caucho.quercus.module.QuercusModule;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class StaticFunction
extends JavaInvoker {
    protected final QuercusModule _quercusModule;
    private final int _argLength;

    public StaticFunction(ModuleContext moduleContext, QuercusModule quercusModule, Method method) {
        super(moduleContext, null, method);
        this._argLength = method.getParameterTypes().length;
        this._quercusModule = quercusModule;
    }

    public boolean isStatic() {
        return true;
    }

    public String getDeclaringClassName() {
        return this._method.getDeclaringClass().getSimpleName();
    }

    public QuercusModule getModule() {
        return this._quercusModule;
    }

    public Method getMethod() {
        return this._method;
    }

    public int getArgumentLength() {
        return this._argLength;
    }

    public Object invoke(Object obj, Object[] javaArgs) {
        try {
            return this._method.invoke((Object)this._quercusModule, javaArgs);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(this.toString(this._method, javaArgs), e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof QuercusExitException) {
                throw (QuercusExitException)cause;
            }
            if (cause != null) {
                throw QuercusModuleException.create(cause);
            }
            throw QuercusModuleException.create(e);
        }
        catch (Exception e) {
            throw QuercusModuleException.create(e);
        }
    }

    private String toString(Method method, Object[] javaArgs) {
        StringBuilder sb = new StringBuilder();
        sb.append(method.getDeclaringClass().getName());
        sb.append(".");
        sb.append(method.getName());
        sb.append("(");
        for (int i = 0; i < javaArgs.length; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(javaArgs[i]);
        }
        sb.append(")");
        return sb.toString();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._method + "]";
    }
}

