/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.relaxng.pattern;

import com.caucho.relaxng.RelaxException;
import com.caucho.relaxng.pattern.ElementPattern;
import com.caucho.relaxng.pattern.GrammarPattern;
import com.caucho.relaxng.pattern.Pattern;
import com.caucho.relaxng.program.Item;

public class RefPattern
extends Pattern {
    private GrammarPattern _grammar;
    private String _refName;

    public RefPattern(GrammarPattern grammar, String refName) {
        this._grammar = grammar;
        this._refName = refName;
    }

    public String getTagName() {
        return "ref";
    }

    public String getRefName() {
        return this._refName;
    }

    public Item createItem(GrammarPattern grammar) throws RelaxException {
        Pattern pattern = grammar.getDefinition(this._refName);
        if (pattern == null) {
            throw this.error(L.l("<ref name=\"{0}\"/> is an unknown reference.", (Object)this._refName));
        }
        for (Pattern ptr = this; ptr != null && !(ptr instanceof ElementPattern); ptr = ptr.getParent()) {
            if (ptr != pattern) continue;
            throw this.error(L.l("<define name=\"{0}\"/> calls itself recursively in a <ref/>.", (Object)this._refName));
        }
        return pattern.createItem(grammar);
    }

    public String toProduction() {
        Pattern pattern = this._grammar.getDefinition(this._refName);
        return pattern.toProduction();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Pattern)) {
            return false;
        }
        return o.equals(this._grammar.getDefinition(this._refName));
    }

    public String toString() {
        return "RefPattern[" + this._refName + "]";
    }
}

