/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.Alarm;

public class AlarmHeap {
    private final Object _queueLock = new Object();
    private Alarm[] _heap = new Alarm[4096];
    private int _heapTop;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Alarm extractAlarm(long now) {
        Object object = this._queueLock;
        synchronized (object) {
            Alarm[] heap = this._heap;
            Alarm alarm = heap[1];
            if (alarm == null) {
                return null;
            }
            if (now < alarm.getWakeTime()) {
                return null;
            }
            this.dequeueImpl(alarm);
            return alarm;
        }
    }

    long nextAlarmTime() {
        Alarm[] heap = this._heap;
        Alarm alarm = heap[1];
        if (alarm != null) {
            return alarm.getWakeTime();
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean queueAt(Alarm alarm, long wakeTime) {
        Object object = this._queueLock;
        synchronized (object) {
            if (alarm.getHeapIndex() > 0) {
                this.dequeueImpl(alarm);
            }
            return this.insertImpl(alarm);
        }
    }

    private boolean insertImpl(Alarm alarm) {
        if (alarm.getHeapIndex() != 0) {
            throw new IllegalStateException();
        }
        if (this._heap.length <= this._heapTop + 2) {
            Alarm[] newHeap = new Alarm[2 * this._heap.length];
            System.arraycopy(this._heap, 0, newHeap, 0, this._heap.length);
            this._heap = newHeap;
        }
        Alarm[] heap = this._heap;
        int i = ++this._heapTop;
        int parent = 0;
        Alarm item = null;
        long wakeTime = alarm.getWakeTime();
        while (i > 1 && wakeTime < (item = heap[parent = i >> 1]).getWakeTime()) {
            heap[i] = item;
            item.setHeapIndex(i);
            i = parent;
        }
        heap[i] = alarm;
        alarm.setHeapIndex(i);
        if (this._heapTop < i) {
            throw new IllegalStateException("i=" + i + " top=" + this._heapTop);
        }
        if (i < 1) {
            throw new IllegalStateException("i=" + i);
        }
        return i == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dequeue(Alarm alarm) {
        Object object = this._queueLock;
        synchronized (object) {
            if (alarm.getHeapIndex() < 0) {
                return;
            }
            this.dequeueImpl(alarm);
        }
    }

    private void dequeueImpl(Alarm item) {
        int i = item.getHeapIndex();
        if (i < 1) {
            return;
        }
        if (this._heapTop < i) {
            throw new IllegalStateException("bad heap: " + this._heapTop + " index:" + i);
        }
        Alarm[] heap = this._heap;
        if (this._heapTop < 1) {
            throw new IllegalStateException();
        }
        int size = this._heapTop--;
        heap[i] = heap[size];
        heap[i].setHeapIndex(i);
        heap[size] = null;
        item.setHeapIndex(0);
        if (size == i) {
            return;
        }
        if (item.getWakeTime() < heap[i].getWakeTime()) {
            while (i < size) {
                int right;
                item = heap[i];
                int minIndex = i;
                long minWakeTime = item.getWakeTime();
                int left = i << 1;
                if (left < size && heap[left].getWakeTime() < minWakeTime) {
                    minIndex = left;
                    minWakeTime = heap[left].getWakeTime();
                }
                if ((right = left + 1) < size && heap[right].getWakeTime() < minWakeTime) {
                    minIndex = right;
                }
                if (i == minIndex) {
                    return;
                }
                heap[i] = heap[minIndex];
                heap[i].setHeapIndex(i);
                heap[minIndex] = item;
                item.setHeapIndex(minIndex);
                i = minIndex;
            }
        } else {
            int parent;
            Alarm alarm;
            item = heap[i];
            long wakeTime = item.getWakeTime();
            while (i > 1 && wakeTime < (alarm = heap[parent = i >> 1]).getWakeTime()) {
                heap[i] = alarm;
                alarm.setHeapIndex(i);
                i = parent;
            }
            heap[i] = item;
            item.setHeapIndex(i);
        }
    }

    public Alarm[] toArray() {
        int heapTop = this._heapTop;
        Alarm[] heap = this._heap;
        Alarm[] array = new Alarm[heapTop + 1];
        for (int i = 0; i <= heapTop; ++i) {
            array[i] = heap[i];
        }
        return array;
    }

    void testClear() {
        while (this._heapTop > 0) {
            Alarm alarm = this._heap[this._heapTop];
            alarm.setHeapIndex(0);
            this._heap[this._heapTop] = null;
            --this._heapTop;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

