/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.CharBuffer;
import java.text.CharacterIterator;

public abstract class CharCursor
implements CharacterIterator {
    public abstract int getIndex();

    public abstract int getBeginIndex();

    public abstract int getEndIndex();

    public abstract char setIndex(int var1);

    public abstract char next();

    public abstract char previous();

    public abstract char current();

    public abstract Object clone();

    public char first() {
        return this.setIndex(this.getBeginIndex());
    }

    public char last() {
        return this.setIndex(this.getEndIndex());
    }

    public char read() {
        char value = this.current();
        this.next();
        return value;
    }

    public char prev() {
        int pos = this.getIndex();
        char value = this.previous();
        this.setIndex(pos);
        return value;
    }

    public char skip(int n) {
        for (int i = 0; i < n; ++i) {
            this.next();
        }
        return this.current();
    }

    public void subseq(CharBuffer cb, int begin, int end) {
        int pos = this.getIndex();
        char ch = this.setIndex(begin);
        for (int i = begin; i < end; ++i) {
            if (ch != '\uffff') {
                cb.append(ch);
            }
            ch = this.next();
        }
        this.setIndex(pos);
    }

    public void subseq(CharBuffer cb, int length) {
        char ch = this.current();
        for (int i = 0; i < length; ++i) {
            if (ch != '\uffff') {
                cb.append(ch);
            }
            ch = this.next();
        }
    }

    public boolean regionMatches(char[] cb, int offset, int length) {
        int pos = this.getIndex();
        char ch = this.current();
        for (int i = 0; i < length; ++i) {
            if (cb[i + offset] != ch) {
                this.setIndex(pos);
                return false;
            }
            ch = this.next();
        }
        return true;
    }

    public boolean regionMatchesIgnoreCase(char[] cb, int offset, int length) {
        int pos = this.getIndex();
        char ch = this.current();
        for (int i = 0; i < length; ++i) {
            if (ch == '\uffff') {
                this.setIndex(pos);
                return false;
            }
            if (Character.toLowerCase(cb[i + offset]) != Character.toLowerCase(ch)) {
                this.setIndex(pos);
                return false;
            }
            ch = this.next();
        }
        return true;
    }
}

