/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.jmx.Jmx;
import java.lang.management.MemoryUsage;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;

public class MemoryPoolAdapter {
    private static final Logger log = Logger.getLogger(MemoryPoolAdapter.class.getName());
    private final MBeanServer _mbeanServer;
    private final ObjectName[] _gcObjectNames;
    private Map<PoolType, ObjectName> _poolNamesMap = new HashMap<PoolType, ObjectName>();

    public MemoryPoolAdapter() {
        Set<ObjectName> objectNames;
        ObjectName query;
        this._mbeanServer = Jmx.getGlobalMBeanServer();
        try {
            query = new ObjectName("java.lang:type=MemoryPool,*");
            objectNames = this._mbeanServer.queryNames(query, null);
            for (PoolType poolType : PoolType.values()) {
                ObjectName objectName = poolType.find(objectNames);
                this._poolNamesMap.put(poolType, objectName);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        try {
            query = new ObjectName("java.lang:type=GarbageCollector,*");
            objectNames = this._mbeanServer.queryNames(query, null);
            this._gcObjectNames = new ObjectName[objectNames.size()];
            int i = 0;
            for (ObjectName name : objectNames) {
                this._gcObjectNames[i++] = name;
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public ObjectName getCodeCacheName() {
        return this._poolNamesMap.get((Object)PoolType.CODE_CACHE);
    }

    public void setCodeCacheName(ObjectName codeCacheName) {
        this._poolNamesMap.put(PoolType.CODE_CACHE, codeCacheName);
    }

    public ObjectName getEdenName() {
        return this._poolNamesMap.get((Object)PoolType.EDEN);
    }

    public void setEdenName(ObjectName edenName) {
        this._poolNamesMap.put(PoolType.EDEN, edenName);
    }

    public ObjectName getSurvivorName() {
        return this._poolNamesMap.get((Object)PoolType.SURVIVOR);
    }

    public void setSurvivorName(ObjectName survivorName) {
        this._poolNamesMap.put(PoolType.SURVIVOR, survivorName);
    }

    public ObjectName getTenuredName() {
        return this._poolNamesMap.get((Object)PoolType.TENURED);
    }

    public void setTenuredName(ObjectName tenuredName) {
        this._poolNamesMap.put(PoolType.TENURED, tenuredName);
    }

    public long getCodeCacheCommitted() throws JMException {
        CompositeData data = (CompositeData)this._mbeanServer.getAttribute(this.getCodeCacheName(), "Usage");
        MemoryUsage usage = MemoryUsage.from(data);
        return usage.getCommitted();
    }

    public long getCodeCacheMax() throws JMException {
        CompositeData data = (CompositeData)this._mbeanServer.getAttribute(this.getCodeCacheName(), "Usage");
        MemoryUsage usage = MemoryUsage.from(data);
        return usage.getMax();
    }

    public long getCodeCacheUsed() throws JMException {
        CompositeData data = (CompositeData)this._mbeanServer.getAttribute(this.getCodeCacheName(), "Usage");
        MemoryUsage usage = MemoryUsage.from(data);
        return usage.getUsed();
    }

    public long getCodeCacheFree() throws JMException {
        CompositeData data = (CompositeData)this._mbeanServer.getAttribute(this.getCodeCacheName(), "Usage");
        MemoryUsage usage = MemoryUsage.from(data);
        return usage.getMax() - usage.getUsed();
    }

    public long getEdenCommitted() throws JMException {
        CompositeData data = (CompositeData)this._mbeanServer.getAttribute(this.getEdenName(), "Usage");
        MemoryUsage usage = MemoryUsage.from(data);
        return usage.getCommitted();
    }

    public long getEdenMax() throws JMException {
        CompositeData data = (CompositeData)this._mbeanServer.getAttribute(this.getEdenName(), "Usage");
        MemoryUsage usage = MemoryUsage.from(data);
        return usage.getMax();
    }

    public long getEdenUsed() throws JMException {
        CompositeData data = (CompositeData)this._mbeanServer.getAttribute(this.getEdenName(), "Usage");
        MemoryUsage usage = MemoryUsage.from(data);
        return usage.getUsed();
    }

    public long getEdenFree() throws JMException {
        CompositeData data = (CompositeData)this._mbeanServer.getAttribute(this.getEdenName(), "Usage");
        MemoryUsage usage = MemoryUsage.from(data);
        return usage.getMax() - usage.getUsed();
    }

    public long getPermGenCommitted() throws JMException {
        return 0L;
    }

    public long getPermGenMax() throws JMException {
        return 0L;
    }

    public long getPermGenUsed() throws JMException {
        return 0L;
    }

    public long getPermGenFree() throws JMException {
        return 0L;
    }

    public long getSurvivorCommitted() throws JMException {
        CompositeData data = (CompositeData)this._mbeanServer.getAttribute(this.getSurvivorName(), "Usage");
        MemoryUsage usage = MemoryUsage.from(data);
        return usage.getCommitted();
    }

    public long getSurvivorMax() throws JMException {
        CompositeData data = (CompositeData)this._mbeanServer.getAttribute(this.getSurvivorName(), "Usage");
        MemoryUsage usage = MemoryUsage.from(data);
        return usage.getMax();
    }

    public long getSurvivorUsed() throws JMException {
        CompositeData data = (CompositeData)this._mbeanServer.getAttribute(this.getSurvivorName(), "Usage");
        MemoryUsage usage = MemoryUsage.from(data);
        return usage.getUsed();
    }

    public long getSurvivorFree() throws JMException {
        CompositeData data = (CompositeData)this._mbeanServer.getAttribute(this.getSurvivorName(), "Usage");
        MemoryUsage usage = MemoryUsage.from(data);
        return usage.getMax() - usage.getUsed();
    }

    public long getTenuredCommitted() throws JMException {
        CompositeData data = (CompositeData)this._mbeanServer.getAttribute(this.getTenuredName(), "Usage");
        MemoryUsage usage = MemoryUsage.from(data);
        return usage.getCommitted();
    }

    public long getTenuredMax() throws JMException {
        CompositeData data = (CompositeData)this._mbeanServer.getAttribute(this.getTenuredName(), "Usage");
        MemoryUsage usage = MemoryUsage.from(data);
        return usage.getMax();
    }

    public long getTenuredUsed() throws JMException {
        CompositeData data = (CompositeData)this._mbeanServer.getAttribute(this.getTenuredName(), "Usage");
        MemoryUsage usage = MemoryUsage.from(data);
        return usage.getUsed();
    }

    public long getTenuredFree() throws JMException {
        CompositeData data = (CompositeData)this._mbeanServer.getAttribute(this.getTenuredName(), "Usage");
        MemoryUsage usage = MemoryUsage.from(data);
        return usage.getMax() - usage.getUsed();
    }

    public MemUsage getTenuredMemUsage() throws JMException {
        CompositeData data = (CompositeData)this._mbeanServer.getAttribute(this.getTenuredName(), "Usage");
        MemoryUsage usage = MemoryUsage.from(data);
        return new MemUsage(usage.getMax(), usage.getCommitted(), usage.getUsed());
    }

    public long getGarbageCollectionTime() throws JMException {
        long gcTime = 0L;
        for (ObjectName name : this._gcObjectNames) {
            try {
                Object value = this._mbeanServer.getAttribute(name, "CollectionTime");
                if (!(value instanceof Number)) continue;
                gcTime += ((Number)value).longValue();
            }
            catch (Exception e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }
        return gcTime;
    }

    public long getGarbageCollectionCount() throws JMException {
        long gcCount = 0L;
        for (ObjectName name : this._gcObjectNames) {
            try {
                Object value = this._mbeanServer.getAttribute(name, "CollectionCount");
                if (!(value instanceof Number)) continue;
                gcCount += ((Number)value).longValue();
            }
            catch (Exception e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }
        return gcCount;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PoolType {
        CODE_CACHE("java.lang:type=MemoryPool,name=Code Cache", "class storage", "class memory", "code cache", "class", "code"),
        EDEN("java.lang:type=MemoryPool,name=Eden Space", "eden"),
        SURVIVOR("java.lang:type=MemoryPool,name=Survivor Space", "survivor"),
        TENURED("java.lang:type=MemoryPool,name=Tenured Gen", "tenured", "old gen", "java heap", "old space", "old", "heap");

        private final String _defaultName;
        private final String[] _keywords;

        private PoolType(String defaultName, String ... keywords) {
            this._defaultName = defaultName;
            this._keywords = keywords;
        }

        public String defaultName() {
            return this._defaultName;
        }

        public String[] keywords() {
            return this._keywords;
        }

        public ObjectName find(Set<ObjectName> objectNames) throws MalformedObjectNameException {
            for (String keyword : this._keywords) {
                for (ObjectName objectName : objectNames) {
                    String name = objectName.getKeyProperty("name").toLowerCase();
                    if (!name.contains(keyword)) continue;
                    return objectName;
                }
            }
            return new ObjectName(this._defaultName);
        }
    }

    public static class MemUsage {
        private long _max;
        private long _used;

        protected MemUsage(long max, long committed, long used) {
            this._max = max < committed ? committed : max;
            this._used = used;
        }

        public long getMax() {
            return this._max;
        }

        public long getUsed() {
            return this._used;
        }

        public long getFree() {
            return this.getMax() - this.getUsed();
        }
    }
}

