/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.CurrentTime;
import com.caucho.util.RingBlocker;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RingBlockerBasic
implements RingBlocker {
    private static final Logger log = Logger.getLogger(RingBlockerBasic.class.getName());
    private final AtomicLong _offerWaitSequence = new AtomicLong();
    private final AtomicLong _offerWakeSequence = new AtomicLong();
    private final AtomicLong _pollWaitSequence = new AtomicLong();
    private final AtomicLong _pollWakeSequence = new AtomicLong();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean offerWait(long tail, AtomicLong tailRef, int reservedSpace, long timeout, TimeUnit unit) {
        if (timeout <= 0L) {
            return false;
        }
        long now = CurrentTime.getCurrentTimeActual();
        long expires = now + unit.toMillis(timeout);
        long sequence = this._offerWaitSequence.incrementAndGet();
        this.pollWake();
        AtomicLong atomicLong = this._offerWaitSequence;
        synchronized (atomicLong) {
            while (this._offerWakeSequence.get() < sequence && tail == tailRef.get() && (now = CurrentTime.getCurrentTimeActual()) < expires) {
                try {
                    long millis = Math.max(0L, expires - now);
                    this._offerWaitSequence.wait(millis);
                }
                catch (Exception e) {
                    Thread.interrupted();
                    log.log(Level.FINER, e.toString(), e);
                }
            }
        }
        return sequence <= this._offerWakeSequence.get() || tail != tailRef.get();
    }

    public final boolean isOfferWait() {
        return this._offerWakeSequence.get() < this._offerWaitSequence.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void offerWake() {
        long wakeSequence = this._offerWakeSequence.get();
        long waitSequence = this._offerWaitSequence.get();
        while (wakeSequence < waitSequence) {
            if (this._offerWakeSequence.compareAndSet(wakeSequence, waitSequence)) {
                AtomicLong atomicLong = this._offerWaitSequence;
                synchronized (atomicLong) {
                    this._offerWaitSequence.notifyAll();
                    break;
                }
            }
            wakeSequence = this._offerWakeSequence.get();
        }
    }

    public final void wake() {
        this.offerWake();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean pollWait(long timeout, TimeUnit unit) {
        long sequence;
        if (timeout <= 0L) {
            return false;
        }
        long expires = CurrentTime.getCurrentTime() + unit.toMillis(timeout);
        this.offerWake();
        AtomicLong atomicLong = this._pollWaitSequence;
        synchronized (atomicLong) {
            long now;
            sequence = this._pollWaitSequence.incrementAndGet();
            while (this._pollWakeSequence.get() < sequence && (now = CurrentTime.getCurrentTime()) < expires) {
                try {
                    long millis = Math.max(0L, expires - now);
                    this._pollWaitSequence.wait(millis);
                }
                catch (Exception e) {
                    Thread.interrupted();
                    log.log(Level.FINER, e.toString(), e);
                }
            }
        }
        return sequence <= this._pollWakeSequence.get();
    }

    public final boolean isPollWait() {
        return this._pollWakeSequence.get() < this._pollWaitSequence.get();
    }

    public final void pollWake() {
        if (this.isPollWait()) {
            this.pollWakeImpl();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pollWakeImpl() {
        AtomicLong atomicLong = this._pollWaitSequence;
        synchronized (atomicLong) {
            this._pollWakeSequence.set(this._pollWaitSequence.get());
            this._pollWaitSequence.notifyAll();
        }
    }

    public final void close() {
    }
}

