/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;

public class WaitQueue {
    private final AtomicBoolean _isWake = new AtomicBoolean();
    private volatile Item _head;

    public boolean wake() {
        this._isWake.set(true);
        for (Item item = this._head; item != null; item = item.getNext()) {
            if (!item.unpark()) continue;
            return true;
        }
        return false;
    }

    public void wakeAll() {
        this._isWake.set(true);
        for (Item item = this._head; item != null; item = item.getNext()) {
            item.unpark();
        }
    }

    public void park(Item item, long timeout) {
        if (this._isWake.getAndSet(false)) {
            return;
        }
        item.startPark();
        item.park(timeout);
        this._isWake.set(false);
    }

    public void parkUntil(Item item, long expires) {
        if (this._isWake.getAndSet(false)) {
            return;
        }
        item.startPark();
        item.parkUntil(expires);
        this._isWake.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Item create() {
        Item item = new Item();
        WaitQueue waitQueue = this;
        synchronized (waitQueue) {
            item.setNext(this._head);
            this._head = item;
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(Item item) {
        WaitQueue waitQueue = this;
        synchronized (waitQueue) {
            Item prev = null;
            for (Item ptr = this._head; ptr != null; ptr = ptr.getNext()) {
                if (ptr != item) continue;
                if (prev != null) {
                    prev.setNext(ptr.getNext());
                    continue;
                }
                this._head = ptr.getNext();
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }

    public final class Item {
        private final Thread _thread;
        private Item _next;
        private final AtomicBoolean _isParked = new AtomicBoolean();

        Item() {
            this._thread = Thread.currentThread();
        }

        final Thread getThread() {
            return this._thread;
        }

        final Item getNext() {
            return this._next;
        }

        final void setNext(Item next) {
            this._next = next;
        }

        final boolean unpark() {
            if (this._isParked.getAndSet(false)) {
                LockSupport.unpark(this._thread);
                return true;
            }
            return false;
        }

        public final void startPark() {
            this._isParked.set(true);
        }

        public final void endPark() {
            this._isParked.set(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void park(long millis) {
            if (!this._isParked.get()) {
                return;
            }
            try {
                Thread.interrupted();
                LockSupport.parkNanos(millis * 1000000L);
                Object var4_2 = null;
                this._isParked.set(false);
            }
            catch (Throwable throwable) {
                Object var4_3 = null;
                this._isParked.set(false);
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void parkUntil(long expires) {
            if (!this._isParked.get()) {
                return;
            }
            try {
                Thread.interrupted();
                LockSupport.parkUntil(expires);
                Object var4_2 = null;
                this._isParked.set(false);
            }
            catch (Throwable throwable) {
                Object var4_3 = null;
                this._isParked.set(false);
                throw throwable;
            }
        }

        public void remove() {
            WaitQueue.this.remove(this);
        }
    }
}

