/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.Crc64;
import java.io.IOException;
import java.io.OutputStream;

public class Crc64OutputStream
extends OutputStream {
    private final OutputStream _next;
    private long _crc;

    public Crc64OutputStream(OutputStream next) {
        this._next = next;
    }

    public long getDigest() {
        return this._crc;
    }

    public void write(int data) throws IOException {
        this._crc = Crc64.generate(this._crc, data);
        this._next.write(data);
    }

    public void write(byte[] buffer, int offset, int length) throws IOException {
        this._crc = Crc64.generate(this._crc, buffer, offset, length);
        this._next.write(buffer, offset, length);
    }

    public void close() throws IOException {
        this._next.close();
    }
}

