/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.CharBuffer;
import com.caucho.util.CurrentTime;
import com.caucho.vfs.Encoding;
import com.caucho.vfs.LockableStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.StreamFilter;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReadStream
extends InputStream
implements LockableStream {
    public static int ZERO_COPY_SIZE = 1024;
    public static final int READ_TIMEOUT = -4;
    private TempBuffer _tempRead;
    private byte[] _readBuffer;
    private int _readOffset;
    private int _readLength;
    private WriteStream _sibling;
    private StreamImpl _source;
    private long _position;
    private boolean _isEnableReadTime;
    private long _readTime;
    private Reader _readEncoding;
    private String _readEncodingName;
    private CharBuffer _cb;
    private boolean _disableClose;
    private boolean _isDisableCloseSource;
    private boolean _reuseBuffer;
    private Reader _reader;

    public ReadStream() {
    }

    public ReadStream(StreamImpl source) {
        this.init(source, null);
    }

    public ReadStream(StreamImpl source, WriteStream sibling) {
        this.init(source, sibling);
    }

    public void init(StreamImpl source, WriteStream sibling) {
        this._disableClose = false;
        this._isDisableCloseSource = false;
        this._readTime = 0L;
        if (this._source != null && this._source != source) {
            this.close();
        }
        if (source == null) {
            throw new IllegalArgumentException();
        }
        this._source = source;
        this._sibling = sibling;
        if (source.canRead() && this._tempRead == null) {
            this._tempRead = TempBuffer.allocate();
            this._readBuffer = this._tempRead._buf;
        }
        this._readOffset = 0;
        this._readLength = 0;
        this._readEncoding = null;
        this._readEncodingName = "ISO-8859-1";
    }

    public void setSibling(WriteStream sibling) {
        this._sibling = sibling;
    }

    public WriteStream getSibling() {
        return this._sibling;
    }

    public StreamImpl getSource() {
        return this._source;
    }

    public void setSource(StreamImpl source) {
        this._source = source;
    }

    public void setReuseBuffer(boolean reuse) {
        this._reuseBuffer = reuse;
    }

    public void pushFilter(StreamFilter filter) {
        filter.init(this._source);
        this._source = filter;
    }

    public byte[] getBuffer() {
        return this._readBuffer;
    }

    public int getOffset() {
        return this._readOffset;
    }

    public void setOffset(int offset) {
        if (offset < 0) {
            throw new IllegalStateException("illegal offset=" + offset);
        }
        this._readOffset = offset;
    }

    public int getLength() {
        return this._readLength;
    }

    public void setLength(int length) {
        if (length < 0 || this._readBuffer.length < length) {
            throw new IllegalStateException("illegal length=" + length);
        }
        this._readLength = length;
    }

    public long getPosition() {
        return this._position - (long)(this._readLength - this._readOffset);
    }

    public long getReadTime() {
        if (!this._isEnableReadTime) {
            throw new UnsupportedOperationException("last read-time is disabled");
        }
        return this._readTime;
    }

    public void clearReadTime() {
        this._readTime = 0L;
    }

    public void setEnableReadTime(boolean isEnable) {
        this._isEnableReadTime = isEnable;
    }

    public boolean setPosition(long pos) throws IOException {
        if (this._readEncoding != null) {
            this._readEncoding = Encoding.getReadEncoding(this, this._readEncodingName);
        }
        if (pos < 0L) {
            return false;
        }
        if (pos < this.getPosition()) {
            this._position = pos;
            this._readOffset = 0;
            this._readLength = 0;
            if (this._source != null) {
                this._source.seekStart(pos);
                return true;
            }
            return false;
        }
        long n = pos - this.getPosition();
        return this.skip(n) == n;
    }

    public void clearPosition() {
        this._position = this._readLength - this._readOffset;
    }

    public boolean canRead() {
        return this._source.canRead();
    }

    public void clearRead() {
        this._readOffset = 0;
        this._readLength = 0;
    }

    public int getAvailable() throws IOException {
        StreamImpl source;
        if (this._readOffset < this._readLength) {
            return this._readLength - this._readOffset;
        }
        if (this._sibling != null) {
            this._sibling.flush();
        }
        if ((source = this._source) != null) {
            return source.getAvailable();
        }
        return -1;
    }

    public int getBufferAvailable() throws IOException {
        return this._readLength - this._readOffset;
    }

    @Override
    public int available() throws IOException {
        return this.getAvailable();
    }

    @Override
    public final int read() throws IOException {
        if (this._readLength <= this._readOffset && !this.readBuffer()) {
            return -1;
        }
        return this._readBuffer[this._readOffset++] & 0xFF;
    }

    public final void unread() {
        if (this._readOffset <= 0) {
            throw new RuntimeException();
        }
        --this._readOffset;
    }

    public final boolean waitForRead() throws IOException {
        return this._readLength > this._readOffset || this.readBuffer();
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return n;
        }
        int skipped = this._readLength - this._readOffset;
        if (n < (long)skipped) {
            this._readOffset = (int)((long)this._readOffset + n);
            return n;
        }
        this._readLength = 0;
        this._readOffset = 0;
        if (this._source.hasSkip()) {
            long sourceSkipped;
            if (this._sibling != null) {
                this._sibling.flush();
            }
            if ((sourceSkipped = this._source.skip(n - (long)skipped)) < 0L) {
                return skipped;
            }
            this._position += sourceSkipped;
            return sourceSkipped + (long)skipped;
        }
        while ((long)(this._readLength - this._readOffset) < n - (long)skipped) {
            skipped += this._readLength - this._readOffset;
            this._readOffset = 0;
            this._readLength = 0;
            if (this.readBuffer()) continue;
            return skipped;
        }
        this._readOffset += (int)(n - (long)skipped);
        return n;
    }

    @Override
    public final int read(byte[] buf, int offset, int length) throws IOException {
        int readLength = this._readLength;
        int readOffset = this._readOffset;
        if (readLength <= readOffset) {
            if (ZERO_COPY_SIZE <= length) {
                StreamImpl source;
                if (this._sibling != null) {
                    this._sibling.flush();
                }
                if ((source = this._source) == null) {
                    return -1;
                }
                int len = source.read(buf, offset, length);
                if (len > 0) {
                    this._position += (long)len;
                    if (this._isEnableReadTime) {
                        this._readTime = CurrentTime.getCurrentTime();
                    }
                }
                return len;
            }
            if (!this.readBuffer()) {
                return -1;
            }
            readOffset = this._readOffset;
            readLength = this._readLength;
        }
        int sublen = Math.min(length, readLength - readOffset);
        System.arraycopy(this._readBuffer, readOffset, buf, offset, sublen);
        this._readOffset = readOffset + sublen;
        return sublen;
    }

    public int readAll(byte[] buf, int offset, int length) throws IOException {
        int readLength = 0;
        while (length > 0) {
            int sublen = this.read(buf, offset, length);
            if (sublen < 0) {
                return readLength == 0 ? -1 : readLength;
            }
            offset += sublen;
            readLength += sublen;
            length -= sublen;
        }
        return readLength == 0 ? -1 : readLength;
    }

    public void setEncoding(String encoding) throws UnsupportedEncodingException {
        String mimeName = Encoding.getMimeName(encoding);
        if (mimeName != null && mimeName.equals(this._readEncodingName)) {
            return;
        }
        this._readEncoding = Encoding.getReadEncoding(this, encoding);
        this._readEncodingName = mimeName;
    }

    public String getEncoding() {
        return this._readEncodingName;
    }

    public final int readChar() throws IOException {
        if (this._readEncoding != null) {
            int ch = this._readEncoding.read();
            return ch;
        }
        if (this._readLength <= this._readOffset && !this.readBuffer()) {
            return -1;
        }
        return this._readBuffer[this._readOffset++] & 0xFF;
    }

    public final int read(char[] buf, int offset, int length) throws IOException {
        if (this._readEncoding != null) {
            return this._readEncoding.read(buf, offset, length);
        }
        byte[] readBuffer = this._readBuffer;
        if (readBuffer == null) {
            return -1;
        }
        int readOffset = this._readOffset;
        int readLength = this._readLength;
        int sublen = Math.min(length, readLength - readOffset);
        if (readLength <= readOffset) {
            if (!this.readBuffer()) {
                return -1;
            }
            readLength = this._readLength;
            readOffset = this._readOffset;
            sublen = Math.min(length, readLength - readOffset);
        }
        for (int i = sublen - 1; i >= 0; --i) {
            buf[offset + i] = (char)(readBuffer[readOffset + i] & 0xFF);
        }
        this._readOffset = readOffset + sublen;
        return sublen;
    }

    public int readAll(char[] buf, int offset, int length) throws IOException {
        int readLength = 0;
        while (length > 0) {
            int sublen = this.read(buf, offset, length);
            if (sublen <= 0) {
                return readLength > 0 ? readLength : -1;
            }
            offset += sublen;
            readLength += sublen;
            length -= sublen;
        }
        return readLength;
    }

    public int read(CharBuffer buf, int length) throws IOException {
        int len = buf.getLength();
        buf.setLength(len + length);
        int readLength = this.read(buf.getBuffer(), len, length);
        if (readLength < 0) {
            buf.setLength(len);
        } else if (readLength < length) {
            buf.setLength(len + readLength);
        }
        return length;
    }

    public int readAll(CharBuffer buf, int length) throws IOException {
        int len = buf.getLength();
        buf.setLength(len + length);
        int readLength = this.readAll(buf.getBuffer(), len, length);
        if (readLength < 0) {
            buf.setLength(len);
        } else if (readLength < length) {
            buf.setLength(len + readLength);
        }
        return length;
    }

    public final String readln() throws IOException {
        return this.readLine();
    }

    public String readLine() throws IOException {
        String result;
        CharBuffer cb = this._cb;
        if (cb == null) {
            cb = this._cb = new CharBuffer();
        }
        if (this.readLine(cb, true)) {
            result = cb.toString();
            cb.clear();
        } else if (cb.length() == 0) {
            result = null;
        } else {
            result = cb.toString();
            cb.clear();
        }
        return result;
    }

    public String readLineNoChop() throws IOException {
        CharBuffer cb = new CharBuffer();
        if (this.readLine(cb, false)) {
            return cb.toString();
        }
        if (cb.length() == 0) {
            return null;
        }
        return cb.toString();
    }

    public final boolean readln(CharBuffer cb) throws IOException {
        return this.readLine(cb, true);
    }

    public final boolean readLine(CharBuffer cb) throws IOException {
        return this.readLine(cb, true);
    }

    public final boolean readLine(CharBuffer cb, boolean isChop) throws IOException {
        if (this._readEncoding != null) {
            return this.readlnEncoded(cb, isChop);
        }
        int capacity = cb.getCapacity();
        int offset = cb.getLength();
        char[] buf = cb.getBuffer();
        byte[] readBuffer = this._readBuffer;
        while (true) {
            int readOffset = this._readOffset;
            for (int sublen = Math.min(capacity - offset, this._readLength - readOffset); sublen > 0; --sublen) {
                int ch;
                if ((ch = readBuffer[readOffset++] & 0xFF) == 10) {
                    if (isChop) {
                        if (offset > 0 && buf[offset - 1] == '\r') {
                            cb.setLength(offset - 1);
                        } else {
                            cb.setLength(offset);
                        }
                        this._readOffset = readOffset;
                        return true;
                    }
                    buf[offset++] = 10;
                    cb.setLength(offset);
                    this._readOffset = readOffset;
                    return true;
                }
                buf[offset++] = (char)ch;
            }
            this._readOffset = readOffset;
            if (this._readLength <= readOffset && !this.readBuffer()) {
                cb.setLength(offset);
                return offset > 0;
            }
            if (capacity > offset) continue;
            cb.setLength(offset + 1);
            capacity = cb.getCapacity();
            buf = cb.getBuffer();
        }
    }

    public final int readLine(char[] buf, int length) throws IOException {
        return this.readLine(buf, length, true);
    }

    public final int readLine(char[] buf, int length, boolean isChop) throws IOException {
        byte[] readBuffer = this._readBuffer;
        int offset = 0;
        do {
            int readOffset = this._readOffset;
            for (int sublen = Math.min(length, this._readLength - readOffset); sublen > 0; --sublen) {
                int ch;
                if ((ch = readBuffer[readOffset++] & 0xFF) == 10) {
                    if (isChop) {
                        this._readOffset = readOffset;
                        if (offset > 0 && buf[offset - 1] == '\r') {
                            return offset - 1;
                        }
                        return offset;
                    }
                    buf[offset++] = (char)ch;
                    this._readOffset = readOffset;
                    return offset + 1;
                }
                buf[offset++] = (char)ch;
            }
            this._readOffset = readOffset;
            if (readOffset > this._readLength || this.readBuffer()) continue;
            return offset;
        } while (length > offset);
        return length + 1;
    }

    private boolean readlnEncoded(CharBuffer cb, boolean isChop) throws IOException {
        int ch;
        while ((ch = this.readChar()) >= 0) {
            if (ch == 10) {
                if (isChop) {
                    if (cb.length() > 0 && cb.getLastChar() == '\r') {
                        cb.setLength(cb.getLength() - 1);
                    }
                    return true;
                }
                cb.append('\n');
                return true;
            }
            cb.append((char)ch);
        }
        return cb.length() > 0;
    }

    public int readInt() throws IOException {
        if (this._readOffset + 4 < this._readLength) {
            return ((this._readBuffer[this._readOffset++] & 0xFF) << 24) + ((this._readBuffer[this._readOffset++] & 0xFF) << 16) + ((this._readBuffer[this._readOffset++] & 0xFF) << 8) + (this._readBuffer[this._readOffset++] & 0xFF);
        }
        return (this.read() << 24) + (this.read() << 16) + (this.read() << 8) + this.read();
    }

    public long readLong() throws IOException {
        return ((long)this.read() << 56) + ((long)this.read() << 48) + ((long)this.read() << 40) + ((long)this.read() << 32) + ((long)this.read() << 24) + ((long)this.read() << 16) + ((long)this.read() << 8) + (long)this.read();
    }

    public int readUTF8ByByteLength(char[] buffer, int offset, int byteLength) throws IOException {
        int k = 0;
        for (int i = 0; i < byteLength; ++i) {
            int c2;
            int ch;
            if (this._readLength <= this._readOffset) {
                this.readBuffer();
            }
            if ((ch = this._readBuffer[this._readOffset++] & 0xFF) < 128) {
                buffer[k++] = (char)ch;
                continue;
            }
            if ((ch & 0xE0) == 192) {
                c2 = this.read();
                ++i;
                buffer[k++] = (char)(((ch & 0x1F) << 6) + (c2 & 0x3F));
                continue;
            }
            c2 = this.read();
            int c3 = this.read();
            i += 2;
            buffer[k++] = (char)(((ch & 0x1F) << 12) + ((c2 & 0x3F) << 6) + (c3 & 0x3F));
        }
        return k;
    }

    public void writeToStream(OutputStream os) throws IOException {
        if (this._readLength <= this._readOffset) {
            this.readBuffer();
        }
        while (this._readOffset < this._readLength) {
            os.write(this._readBuffer, this._readOffset, this._readLength - this._readOffset);
            this.readBuffer();
        }
    }

    public void writeToStream(OutputStream os, int len) throws IOException {
        while (len > 0) {
            if (this._readLength <= this._readOffset && !this.readBuffer()) {
                return;
            }
            int sublen = Math.min(len, this._readLength - this._readOffset);
            os.write(this._readBuffer, this._readOffset, sublen);
            this._readOffset += sublen;
            len -= sublen;
        }
    }

    public void writeToWriter(Writer out) throws IOException {
        int ch;
        while ((ch = this.readChar()) >= 0) {
            out.write((char)ch);
        }
    }

    public int fillBuffer() throws IOException {
        if (!this.readBuffer()) {
            return -1;
        }
        return this._readLength;
    }

    public boolean readNonBlock() throws IOException {
        if (this._readOffset < this._readLength) {
            return true;
        }
        if (this._readBuffer == null) {
            this._readOffset = 0;
            this._readLength = 0;
            return false;
        }
        if (this._sibling != null) {
            this._sibling.flush();
        }
        this._readOffset = 0;
        int readLength = this._source.readNonBlock(this._readBuffer, 0, this._readBuffer.length);
        if (readLength > 0) {
            this._readLength = readLength;
            this._position += (long)readLength;
            if (this._isEnableReadTime) {
                this._readTime = CurrentTime.getCurrentTime();
            }
            return true;
        }
        this._readLength = 0;
        return false;
    }

    public int fillWithTimeout(long timeout) throws IOException {
        if (this._readOffset < this._readLength) {
            return this._readLength - this._readOffset;
        }
        if (this._readBuffer == null) {
            this._readOffset = 0;
            this._readLength = 0;
            return -1;
        }
        if (this._sibling != null) {
            this._sibling.flush();
        }
        this._readOffset = 0;
        StreamImpl source = this._source;
        if (source == null) {
            return -1;
        }
        int readLength = source.readTimeout(this._readBuffer, 0, this._readBuffer.length, timeout);
        if (readLength > 0) {
            this._readLength = readLength;
            this._position += (long)readLength;
            if (this._isEnableReadTime) {
                this._readTime = CurrentTime.getCurrentTime();
            }
            return readLength;
        }
        if (readLength == -4) {
            this._readLength = 0;
            return 0;
        }
        this._readLength = 0;
        return -1;
    }

    public boolean fillIfLive(long timeout) throws IOException {
        int readLength;
        StreamImpl source = this._source;
        byte[] readBuffer = this._readBuffer;
        if (readBuffer == null || source == null) {
            this._readOffset = 0;
            this._readLength = 0;
            return false;
        }
        if (this._readOffset > 0) {
            System.arraycopy(readBuffer, this._readOffset, readBuffer, 0, this._readLength - this._readOffset);
            this._readLength -= this._readOffset;
            this._readOffset = 0;
        }
        if (this._readLength == readBuffer.length) {
            return true;
        }
        if (this._sibling != null) {
            this._sibling.flush();
        }
        if ((readLength = source.readTimeout(this._readBuffer, this._readLength, this._readBuffer.length - this._readLength, timeout)) >= 0) {
            this._readLength += readLength;
            this._position += (long)readLength;
            if (this._isEnableReadTime) {
                this._readTime = CurrentTime.getCurrentTime();
            }
            return true;
        }
        return readLength == -4;
    }

    private boolean readBuffer() throws IOException {
        if (this._readBuffer == null || this._source == null) {
            this._readOffset = 0;
            this._readLength = 0;
            return false;
        }
        if (this._sibling != null) {
            this._sibling.flush();
        }
        this._readOffset = 0;
        this._readLength = 0;
        int readLength = this._source.read(this._readBuffer, 0, this._readBuffer.length);
        if (readLength > 0) {
            this._readLength = readLength;
            this._position += (long)readLength;
            if (this._isEnableReadTime) {
                this._readTime = CurrentTime.getCurrentTime();
            }
            return true;
        }
        this._readLength = 0;
        return false;
    }

    public void setDisableClose(boolean disableClose) {
        this._disableClose = disableClose;
    }

    public void setDisableCloseSource(boolean disableClose) {
        this._isDisableCloseSource = disableClose;
    }

    @Override
    public final void close() {
        try {
            if (this._disableClose) {
                return;
            }
            if (!this._reuseBuffer) {
                if (this._tempRead != null) {
                    TempBuffer.free(this._tempRead);
                    this._tempRead = null;
                }
                this._readBuffer = null;
            }
            if (this._readEncoding != null) {
                Reader reader = this._readEncoding;
                this._readEncoding = null;
                reader.close();
            }
            if (this._source != null && !this._isDisableCloseSource) {
                StreamImpl s = this._source;
                this._source = null;
                s.close();
            }
        }
        catch (IOException e) {
            ReadStream.log().log(Level.FINE, e.toString(), e);
        }
    }

    public Object getAttribute(String name) throws IOException {
        if (this._sibling != null) {
            this._sibling.flush();
        }
        return this._source.getAttribute(name);
    }

    public Iterator<String> getAttributeNames() throws IOException {
        if (this._sibling != null) {
            this._sibling.flush();
        }
        return this._source.getAttributeNames();
    }

    public void setAttribute(String name, Object value) throws IOException {
        this._source.setAttribute(name, value);
    }

    public void removeAttribute(String name) throws IOException {
        this._source.removeAttribute(name);
    }

    public Path getPath() {
        return this._source == null ? null : this._source.getPath();
    }

    public String getUserPath() {
        if (this._source == null || this._source.getPath() == null) {
            return "stream";
        }
        return this._source.getPath().getUserPath();
    }

    public String getURL() {
        if (this._source == null || this._source.getPath() == null) {
            return "stream:";
        }
        return this._source.getPath().getURL();
    }

    public void setPath(Path path) {
        this._source.setPath(path);
    }

    public Reader getReader() {
        if (this._reader == null) {
            this._reader = new StreamReader();
        }
        return this._reader;
    }

    private static Logger log() {
        return Logger.getLogger(ReadStream.class.getName());
    }

    public String toString() {
        return "ReadStream[" + this._source + "]";
    }

    @Override
    public boolean lock(boolean shared, boolean block) {
        if (!(this._source instanceof LockableStream)) {
            return true;
        }
        LockableStream ls = (LockableStream)((Object)this._source);
        return ls.lock(shared, block);
    }

    @Override
    public boolean unlock() {
        if (!(this._source instanceof LockableStream)) {
            return true;
        }
        LockableStream ls = (LockableStream)((Object)this._source);
        return ls.unlock();
    }

    public class StreamReader
    extends Reader {
        public final int read() throws IOException {
            return ReadStream.this.readChar();
        }

        public final int read(char[] cbuf, int off, int len) throws IOException {
            return ReadStream.this.read(cbuf, off, len);
        }

        public boolean ready() throws IOException {
            return ReadStream.this.available() > 0;
        }

        public final void close() throws IOException {
        }

        public ReadStream getStream() {
            return ReadStream.this;
        }
    }
}

