/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.StringPath;
import java.io.IOException;

public class StringStream
extends StreamImpl {
    private final String _string;
    private final int _length;
    private int _index;

    StringStream(String string) {
        this._string = string;
        this._length = string.length();
        this._index = 0;
    }

    public static ReadStream open(String string) {
        StringStream ss = new StringStream(string);
        return new ReadStream(ss);
    }

    public Path getPath() {
        return new StringPath(this._string);
    }

    public boolean canRead() {
        return true;
    }

    public int read(byte[] buf, int offset, int length) throws IOException {
        int index;
        int strlen = this._length;
        int start = offset;
        int end = offset + length;
        for (index = this._index; index < strlen && offset < end; ++index) {
            char ch = this._string.charAt(index);
            if (ch < '\u0080') {
                buf[offset++] = (byte)ch;
                continue;
            }
            if (ch < '\u0800' && offset + 1 < end) {
                buf[offset++] = (byte)(0xC0 | ch >> 6);
                buf[offset++] = (byte)(0x80 | ch & 0x3F);
                continue;
            }
            if (ch < '\u8000' && offset + 2 < end) {
                buf[offset++] = (byte)(0xE0 | ch >> 12);
                buf[offset++] = (byte)(0x80 | ch >> 6 & 0x3F);
                buf[offset++] = (byte)(0x80 | ch >> 6 & 0x3F);
                continue;
            }
            if (offset != start) break;
            throw new IllegalStateException("buffer length is not large enough to decode UTF-8 data");
        }
        this._index = index;
        return start < offset ? offset - start : -1;
    }

    public int getAvailable() throws IOException {
        return this._length - this._index;
    }
}

