/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.CharBuffer;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.WriteStream;
import java.io.CharConversionException;
import java.io.EOFException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class StringWriter
extends StreamImpl {
    private WriteStream _ws;
    private CharBuffer _cb;

    public StringWriter() {
    }

    public StringWriter(CharBuffer cb) {
        this._cb = cb;
    }

    public WriteStream openWrite() {
        if (this._cb != null) {
            this._cb.clear();
        } else {
            this._cb = CharBuffer.allocate();
        }
        if (this._ws == null) {
            this._ws = new WriteStream(this);
        } else {
            this._ws.init(this);
        }
        try {
            this._ws.setEncoding("utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return this._ws;
    }

    public String getString() {
        try {
            this._ws.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String str = this._cb.close();
        this._cb = null;
        return str;
    }

    public boolean canWrite() {
        return true;
    }

    public void write(byte[] buf, int offset, int length, boolean isEnd) throws IOException {
        int end = offset + length;
        while (offset < end) {
            int ch2;
            int ch1;
            if ((ch1 = buf[offset++] & 0xFF) < 128) {
                this._cb.append((char)ch1);
                continue;
            }
            if ((ch1 & 0xE0) == 192) {
                if (offset >= end) {
                    throw new EOFException("unexpected end of file in utf8 character");
                }
                if (((ch2 = buf[offset++] & 0xFF) & 0xC0) != 128) {
                    throw new CharConversionException("illegal utf8 encoding");
                }
                this._cb.append((char)(((ch1 & 0x1F) << 6) + (ch2 & 0x3F)));
                continue;
            }
            if ((ch1 & 0xF0) == 224) {
                if (offset + 1 >= end) {
                    throw new EOFException("unexpected end of file in utf8 character");
                }
                ch2 = buf[offset++] & 0xFF;
                int ch3 = buf[offset++] & 0xFF;
                if ((ch2 & 0xC0) != 128) {
                    throw new CharConversionException("illegal utf8 encoding");
                }
                if ((ch3 & 0xC0) != 128) {
                    throw new CharConversionException("illegal utf8 encoding");
                }
                this._cb.append((char)(((ch1 & 0x1F) << 12) + ((ch2 & 0x3F) << 6) + (ch3 & 0x3F)));
                continue;
            }
            throw new CharConversionException("illegal utf8 encoding at (" + ch1 + ")");
        }
    }
}

