/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs.i18n;

import com.caucho.util.ByteAppendable;
import com.caucho.vfs.OutputStreamWithBuffer;
import com.caucho.vfs.i18n.EncodingWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.logging.Level;

public class JDKWriter
extends EncodingWriter {
    private String _javaEncoding;

    public String getJavaEncoding() {
        return this._javaEncoding;
    }

    public void setJavaEncoding(String encoding) {
        this._javaEncoding = encoding;
    }

    public EncodingWriter create(String javaEncoding) {
        try {
            return new OutputStreamEncodingWriter(javaEncoding);
        }
        catch (UnsupportedEncodingException e) {
            log.log(Level.WARNING, e.toString(), e);
            return null;
        }
    }

    public void write(ByteAppendable os, char ch) throws IOException {
        throw new UnsupportedOperationException();
    }

    static class OutputStreamAdapter
    extends OutputStream {
        private final ByteAppendable _out;

        OutputStreamAdapter(ByteAppendable out) {
            this._out = out;
        }

        public void write(int b) throws IOException {
            this._out.write(b);
        }

        public void write(byte[] buffer, int offset, int len) throws IOException {
            this._out.write(buffer, offset, len);
        }
    }

    static class OutputStreamEncodingWriter
    extends EncodingWriter {
        private Charset _charset;
        private String _encoding;
        private OutputStreamWriter _writer;

        OutputStreamEncodingWriter(String javaEncoding) throws UnsupportedEncodingException {
            try {
                this._encoding = javaEncoding;
                if (!Charset.isSupported(javaEncoding)) {
                    throw new UnsupportedEncodingException(javaEncoding);
                }
                this._charset = Charset.forName(javaEncoding);
            }
            catch (UnsupportedCharsetException e) {
                throw new UnsupportedEncodingException(e.getMessage());
            }
        }

        public void write(ByteAppendable sb, char ch) throws IOException {
            if (this._writer == null) {
                OutputStream os = sb instanceof OutputStream ? (OutputStream)((Object)sb) : new OutputStreamAdapter(sb);
                this._writer = this._charset != null ? new OutputStreamWriter(os, this._charset) : new OutputStreamWriter(os, this._encoding);
            }
            this._writer.write(ch);
            this._writer.flush();
        }

        public int write(OutputStreamWithBuffer os, char[] buf, int offset, int length) throws IOException {
            if (this._writer == null) {
                this._writer = this._charset != null ? new OutputStreamWriter((OutputStream)os, this._charset) : new OutputStreamWriter((OutputStream)os, this._encoding);
            }
            this._writer.write(buf, offset, length);
            this._writer.flush();
            return length;
        }

        public EncodingWriter create(String encoding) {
            throw new UnsupportedOperationException();
        }
    }
}

