/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs.net;

import com.caucho.loader.EnvironmentLocal;
import com.caucho.vfs.QServerSocket;
import com.caucho.vfs.QSocket;
import com.caucho.vfs.net.TcpNetworkSystem;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public abstract class NetworkSystem {
    private static final EnvironmentLocal<NetworkSystem> _localSystem = new EnvironmentLocal();
    private static final TcpNetworkSystem _tcpSystem = new TcpNetworkSystem();

    public static void setLocal(NetworkSystem value) {
        _localSystem.set(value);
    }

    public static NetworkSystem getCurrent() {
        NetworkSystem system = _localSystem.get();
        if (system == null) {
            system = _tcpSystem;
        }
        return system;
    }

    public static NetworkSystem createSubSystem(String name) {
        NetworkSystem system = NetworkSystem.getCurrent();
        NetworkSystem subSystem = system.createSubSystemImpl(name);
        _localSystem.set(subSystem);
        return subSystem;
    }

    protected NetworkSystem createSubSystemImpl(String name) {
        return this;
    }

    public QServerSocket openServerSocket(String address, int port) throws IOException {
        InetAddress inetAddr = InetAddress.getByName(address);
        return this.openServerSocket(inetAddr, port, 100, true);
    }

    public abstract QServerSocket openServerSocket(InetAddress var1, int var2, int var3, boolean var4) throws IOException;

    public QSocket connect(String address, int port) throws IOException {
        InetAddress inetAddr = InetAddress.getByName(address);
        return this.connect(inetAddr, port, -1L);
    }

    public final QSocket connect(InetAddress address, int port, long timeout) throws IOException {
        return this.connect(new InetSocketAddress(address, port), timeout);
    }

    public abstract QSocket connect(InetSocketAddress var1, long var2) throws IOException;

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

