/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml;

import com.caucho.relaxng.SchemaImpl;
import com.caucho.relaxng.VerifierHandlerImpl;
import com.caucho.relaxng.pattern.ChoicePattern;
import com.caucho.relaxng.pattern.ElementPattern;
import com.caucho.relaxng.pattern.EmptyPattern;
import com.caucho.relaxng.pattern.GrammarPattern;
import com.caucho.relaxng.pattern.GroupPattern;
import com.caucho.relaxng.pattern.InterleavePattern;
import com.caucho.relaxng.pattern.NamePattern;
import com.caucho.relaxng.pattern.Pattern;
import com.caucho.relaxng.pattern.RefPattern;
import com.caucho.relaxng.pattern.TextPattern;
import com.caucho.relaxng.pattern.ZeroOrMorePattern;
import com.caucho.xml.QContentParticle;
import com.caucho.xml.QDocumentType;
import com.caucho.xml.QElementDef;
import com.caucho.xml.QName;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.ContentHandler;

class DtdRelaxGenerator {
    private static final Logger log = Logger.getLogger(DtdRelaxGenerator.class.getName());
    private QDocumentType _dtd;
    private GrammarPattern _grammar;

    DtdRelaxGenerator(QDocumentType dtd) {
        this._dtd = dtd;
    }

    ContentHandler generate() {
        try {
            this._grammar = new GrammarPattern();
            HashMap<String, QElementDef> elementMap = this._dtd.getElementMap();
            for (QElementDef elt : elementMap.values()) {
                String name = elt.getName();
                Pattern pattern = null;
                pattern = this.parseContentParticle(elt.getContent());
                if (pattern == null) continue;
                ElementPattern eltPattern = new ElementPattern(name);
                eltPattern.addNameChild(new NamePattern(new QName(name)));
                eltPattern.addChild(pattern);
                eltPattern.endElement();
                this._grammar.setDefinition(name, eltPattern);
            }
            Pattern start = this._grammar.getDefinition(this._dtd.getName());
            if (start == null) {
                return null;
            }
            this._grammar.setStart(start);
            SchemaImpl schema = new SchemaImpl(this._grammar);
            VerifierHandlerImpl handler = new VerifierHandlerImpl(schema);
            return handler;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.log(Level.WARNING, e.toString(), e);
            return null;
        }
    }

    private Pattern parseContentParticle(Object obj) throws Exception {
        if (obj instanceof QContentParticle) {
            QContentParticle cp = (QContentParticle)obj;
            Pattern pattern = null;
            boolean isText = false;
            pattern = cp.getSeparator() == ',' ? new GroupPattern() : (cp.getSeparator() == '|' ? new ChoicePattern() : (cp.getSeparator() == '&' ? new InterleavePattern() : new GroupPattern()));
            for (int i = 0; i < cp.getChildSize(); ++i) {
                Pattern child = this.parseContentParticle(cp.getChild(i));
                if (child instanceof TextPattern) {
                    isText = true;
                    continue;
                }
                if (child == null) {
                    log.finer(this + " " + cp.getChild(i) + " is an unknown CP");
                    return null;
                }
                pattern.addChild(child);
            }
            pattern.endElement();
            if (cp.getRepeat() == '*') {
                pattern = new ZeroOrMorePattern(pattern);
            } else if (cp.getRepeat() == '?') {
                ChoicePattern group = new ChoicePattern();
                ((Pattern)group).addChild(new EmptyPattern());
                ((Pattern)group).addChild(pattern);
                group.endElement();
                pattern = group;
            } else if (cp.getRepeat() == '+') {
                GroupPattern group = new GroupPattern();
                ((Pattern)group).addChild(pattern);
                ((Pattern)group).addChild(new ZeroOrMorePattern(pattern));
                group.endElement();
                pattern = group;
            }
            if (isText) {
                InterleavePattern group = new InterleavePattern();
                ((Pattern)group).addChild(pattern);
                ((Pattern)group).addChild(new TextPattern());
                group.endElement();
                pattern = group;
            }
            return pattern;
        }
        if (obj instanceof String) {
            String s = (String)obj;
            if ("EMPTY".equals(s)) {
                return new EmptyPattern();
            }
            if (s.startsWith("#")) {
                return new TextPattern();
            }
            return new RefPattern(this._grammar, s);
        }
        return null;
    }
}

