/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml.stream;

import com.caucho.util.L10N;
import com.caucho.xml.stream.NamespaceReaderContext;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public class DOMSourceXMLStreamReaderImpl
implements XMLStreamReader {
    private static final Logger log = Logger.getLogger(DOMSourceXMLStreamReaderImpl.class.getName());
    private static final L10N L = new L10N(DOMSourceXMLStreamReaderImpl.class);
    private NamespaceReaderContext _namespaceTracker;
    private Node _current;
    private boolean _ending = false;
    private String _systemId;
    private String _publicId;
    private String _version;
    private String _encoding;
    private boolean _standalone = false;
    private boolean _first = true;

    public DOMSourceXMLStreamReaderImpl(DOMSource source) throws XMLStreamException {
        this(source.getNode());
    }

    public DOMSourceXMLStreamReaderImpl(Node node) throws XMLStreamException {
        this._current = node;
        if (node.getNodeType() == 1) {
            this._first = false;
        }
        this.init();
    }

    private void init() throws XMLStreamException {
        this._namespaceTracker = new NamespaceReaderContext();
        this.declareNamespaces();
        if (this._current instanceof Document) {
            Document document = (Document)this._current;
            this._encoding = document.getXmlEncoding();
            this._version = document.getXmlVersion();
            this._standalone = document.getXmlStandalone();
        }
    }

    private void declareNamespaces() {
        if (this.isStartElement()) {
            this._namespaceTracker.push();
            Element element = (Element)this._current;
            NamedNodeMap map = element.getAttributes();
            if (map == null) {
                return;
            }
            for (int i = 0; i < map.getLength(); ++i) {
                Attr attr = (Attr)map.item(i);
                if (!attr.getName().startsWith("xmlns")) continue;
                int colon = attr.getName().indexOf(58);
                if (colon < 0) {
                    this._namespaceTracker.declare("", attr.getNodeValue());
                    continue;
                }
                String prefix = attr.getName().substring(0, colon);
                this._namespaceTracker.declare(prefix, attr.getNodeValue());
            }
        }
    }

    public int getAttributeCount() {
        if (this.isStartElement()) {
            Element element = (Element)this._current;
            NamedNodeMap map = element.getAttributes();
            if (map == null) {
                return 0;
            }
            int attributeCount = 0;
            for (int i = 0; i < map.getLength(); ++i) {
                Attr attr = (Attr)map.item(i);
                if (attr.getName().startsWith("xmlns")) continue;
                ++attributeCount;
            }
            return attributeCount;
        }
        throw new IllegalStateException(L.l("Current event not a start or end element"));
    }

    private Attr getAttribute(int index) {
        if (this.isStartElement()) {
            Element element = (Element)this._current;
            NamedNodeMap map = element.getAttributes();
            if (map == null) {
                throw new NoSuchElementException();
            }
            int attributeCount = 0;
            for (int i = 0; i < map.getLength(); ++i) {
                Attr attr = (Attr)map.item(i);
                if (attr.getName().startsWith("xmlns")) continue;
                if (attributeCount == index) {
                    return attr;
                }
                ++attributeCount;
            }
            throw new NoSuchElementException();
        }
        throw new IllegalStateException(L.l("Current event not a start or end element"));
    }

    public String getAttributeLocalName(int index) {
        Attr attr = this.getAttribute(index);
        return attr.getLocalName();
    }

    public QName getAttributeName(int index) {
        Attr attr = this.getAttribute(index);
        int colon = attr.getName().indexOf(58);
        if (colon < 0) {
            if (attr.getNamespaceURI() == null || "".equals(attr.getNamespaceURI())) {
                return new QName(attr.getNamespaceURI(), attr.getLocalName());
            }
            return new QName(attr.getLocalName());
        }
        String prefix = attr.getName().substring(0, colon);
        return new QName(attr.getNamespaceURI(), attr.getLocalName(), prefix);
    }

    public String getAttributeNamespace(int index) {
        Attr attr = this.getAttribute(index);
        return attr.getNamespaceURI();
    }

    public String getAttributePrefix(int index) {
        Attr attr = this.getAttribute(index);
        int colon = attr.getName().indexOf(58);
        if (colon < 0) {
            return "";
        }
        String prefix = attr.getName().substring(0, colon);
        return prefix;
    }

    public String getAttributeType(int index) {
        return "CDATA";
    }

    public String getAttributeValue(int index) {
        Attr attr = this.getAttribute(index);
        return attr.getNodeValue();
    }

    public boolean isAttributeSpecified(int index) {
        return index < this.getAttributeCount();
    }

    public String getAttributeValue(String namespaceURI, String localName) {
        if (this.isStartElement()) {
            Element element = (Element)this._current;
            NamedNodeMap map = element.getAttributes();
            Attr attr = (Attr)map.getNamedItemNS(namespaceURI, localName);
            if (attr == null) {
                return null;
            }
            return attr.getNodeValue();
        }
        throw new IllegalStateException(L.l("Current event not a start or end element"));
    }

    public String getCharacterEncodingScheme() {
        return this._encoding;
    }

    public String getElementText() throws XMLStreamException {
        return this._current.getTextContent();
    }

    public String getEncoding() {
        return this._encoding;
    }

    public int getEventType() {
        if (this._current == null) {
            return 8;
        }
        switch (this._current.getNodeType()) {
            case 2: {
                return 10;
            }
            case 4: {
                return 12;
            }
            case 8: {
                return 5;
            }
            case 11: {
                throw new IllegalStateException();
            }
            case 9: {
                return this._ending ? 8 : 7;
            }
            case 10: {
                return 11;
            }
            case 1: {
                return this._ending ? 2 : 1;
            }
            case 6: {
                return 15;
            }
            case 5: {
                return 9;
            }
            case 12: {
                return 14;
            }
            case 7: {
                return 3;
            }
            case 3: {
                return 4;
            }
        }
        return -1;
    }

    public Location getLocation() {
        return new UnknownLocation();
    }

    public String getLocalName() {
        if (this._current instanceof Element) {
            Element element = (Element)this._current;
            return element.getLocalName();
        }
        throw new IllegalStateException(L.l("Current event not a start or end element"));
    }

    public String getNamespaceURI() {
        if (this.isStartElement()) {
            Element element = (Element)this._current;
            return element.getNamespaceURI();
        }
        throw new IllegalStateException(L.l("Current event not a start or end element"));
    }

    public QName getName() {
        if (this._current.getNodeType() == 1) {
            Element element = (Element)this._current;
            String name = element.getNodeName();
            int colon = name.indexOf(58);
            if (colon < 0) {
                if (element.getNamespaceURI() == null || "".equals(element.getNamespaceURI())) {
                    return new QName(element.getLocalName());
                }
                return new QName(element.getNamespaceURI(), element.getLocalName());
            }
            String prefix = name.substring(0, colon);
            return new QName(element.getNamespaceURI(), element.getLocalName(), prefix);
        }
        throw new IllegalStateException(L.l("Current event not a start or end element"));
    }

    public NamespaceContext getNamespaceContext() {
        return this._namespaceTracker;
    }

    public int getNamespaceCount() {
        return this._namespaceTracker.getNumDecls();
    }

    public String getNamespacePrefix(int index) {
        String prefix = this._namespaceTracker.getPrefix(index);
        if ("".equals(prefix)) {
            return null;
        }
        return prefix;
    }

    public String getNamespaceURI(int index) {
        return this._namespaceTracker.getUri(index);
    }

    public String getNamespaceURI(String prefix) {
        return this._namespaceTracker.getUri(prefix);
    }

    public String getPIData() {
        if (this._current.getNodeType() != 7) {
            return null;
        }
        ProcessingInstruction pi = (ProcessingInstruction)this._current;
        return pi.getData();
    }

    public String getPITarget() {
        if (this._current.getNodeType() != 7) {
            return null;
        }
        ProcessingInstruction pi = (ProcessingInstruction)this._current;
        return pi.getTarget();
    }

    public String getPrefix() {
        if (this.isStartElement()) {
            Element element = (Element)this._current;
            String name = element.getNodeName();
            int colon = name.indexOf(58);
            if (colon < 0) {
                return "";
            }
            return name.substring(0, colon);
        }
        throw new IllegalStateException(L.l("Current event not a start or end element"));
    }

    public Object getProperty(String name) throws IllegalArgumentException {
        if ("javax.xml.stream.notations".equals(name)) {
            throw new UnsupportedOperationException(this.getClass().getName());
        }
        if ("javax.xml.stream.entities".equals(name)) {
            throw new UnsupportedOperationException(this.getClass().getName());
        }
        throw new IllegalArgumentException("property \"" + name + "+\" not supported");
    }

    public String getText() {
        if (this._current instanceof CharacterData) {
            CharacterData data = (CharacterData)this._current;
            return data.getData();
        }
        throw new IllegalStateException("Not a text node");
    }

    public char[] getTextCharacters() {
        return this.getText().toCharArray();
    }

    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws XMLStreamException {
        char[] source = this.getTextCharacters();
        int ret = Math.min(source.length - sourceStart, length);
        System.arraycopy(source, sourceStart, target, targetStart, ret);
        return ret;
    }

    public int getTextLength() {
        return this.getText().length();
    }

    public int getTextStart() {
        return 0;
    }

    public String getVersion() {
        return this._version;
    }

    public boolean hasName() {
        return this._current.getNodeType() == 1;
    }

    public boolean hasText() {
        switch (this._current.getNodeType()) {
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    public boolean isCharacters() {
        return this._current.getNodeType() == 3;
    }

    public boolean isEndElement() {
        return this._ending;
    }

    public boolean isStandalone() {
        return this._standalone;
    }

    public boolean isStartElement() {
        return this._current != null && this._current.getNodeType() == 1 && !this._ending;
    }

    public boolean isWhiteSpace() {
        if (!this.isCharacters()) {
            return false;
        }
        String text = this.getText();
        for (int i = 0; i < text.length(); ++i) {
            if (Character.isWhitespace(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public int nextTag() throws XMLStreamException {
        int tag;
        while ((tag = this.next()) >= 0 && tag != 1 && tag != 2) {
        }
        return tag;
    }

    public void require(int type, String namespaceURI, String localName) throws XMLStreamException {
        if (type != this.getEventType()) {
            throw new XMLStreamException("expected " + DOMSourceXMLStreamReaderImpl.constantToString(type) + ", " + "found " + DOMSourceXMLStreamReaderImpl.constantToString(this.getEventType()) + " at " + this.getLocation());
        }
        if (localName != null && !localName.equals(this.getLocalName())) {
            throw new XMLStreamException("expected <" + localName + ">, found " + "<" + this.getLocalName() + "> at " + this.getLocation());
        }
        if (namespaceURI != null && !namespaceURI.equals(this.getNamespaceURI())) {
            throw new XMLStreamException("expected xmlns=" + namespaceURI + ", found xmlns=" + this.getNamespaceURI() + " at " + this.getLocation());
        }
    }

    public boolean standaloneSet() {
        return this.isStandalone();
    }

    public boolean hasNext() throws XMLStreamException {
        return this._current != null && this.getEventType() != 8;
    }

    public int next() throws XMLStreamException {
        if (this._current == null) {
            throw new NoSuchElementException();
        }
        if (this._first) {
            this._first = false;
            return this.getEventType();
        }
        if (this._ending) {
            if (this._current.getNodeType() == 1) {
                this._namespaceTracker.pop();
            }
            if (this._current.getNextSibling() != null) {
                this._current = this._current.getNextSibling();
                this._ending = false;
            } else {
                this._current = this._current.getParentNode();
            }
        } else if (this._current.getFirstChild() != null) {
            this._current = this._current.getFirstChild();
        } else if (this.isStartElement()) {
            this._ending = true;
        } else if (this._current.getNextSibling() != null) {
            this._current = this._current.getNextSibling();
        } else {
            this._current = this._current.getParentNode();
            this._ending = true;
        }
        this.declareNamespaces();
        return this.getEventType();
    }

    public void close() throws XMLStreamException {
    }

    private static String constantToString(int constant) {
        switch (constant) {
            case 10: {
                return "ATTRIBUTE";
            }
            case 12: {
                return "CDATA";
            }
            case 4: {
                return "CHARACTERS";
            }
            case 5: {
                return "COMMENT";
            }
            case 11: {
                return "DTD";
            }
            case 8: {
                return "END_DOCUMENT";
            }
            case 2: {
                return "END_ELEMENT";
            }
            case 15: {
                return "ENTITY_DECLARATION";
            }
            case 9: {
                return "ENTITY_REFERENCE";
            }
            case 13: {
                return "NAMESPACE";
            }
            case 14: {
                return "NOTATION_DECLARATION";
            }
            case 3: {
                return "PROCESSING_INSTRUCTION";
            }
            case 6: {
                return "SPACE";
            }
            case 7: {
                return "START_DOCUMENT";
            }
            case 1: {
                return "START_ELEMENT";
            }
        }
        throw new RuntimeException("constantToString(" + constant + ") unknown");
    }

    private class UnknownLocation
    implements Location {
        private UnknownLocation() {
        }

        public int getCharacterOffset() {
            return -1;
        }

        public int getColumnNumber() {
            return -1;
        }

        public int getLineNumber() {
            return -1;
        }

        public String getPublicId() {
            return null;
        }

        public String getSystemId() {
            return null;
        }
    }
}

