/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml.stream;

import com.caucho.util.L10N;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.XMLEvent;
import javax.xml.stream.util.XMLEventAllocator;

public class XMLEventReaderImpl
implements XMLEventReader {
    public static final L10N L = new L10N(XMLEventReaderImpl.class);
    private final XMLEventAllocator _allocator;
    private final XMLStreamReader _in;
    private XMLEvent _current = null;
    private XMLEvent _next = null;

    public XMLEventReaderImpl(XMLEventAllocator allocator, XMLStreamReader in) throws XMLStreamException {
        this._in = in;
        this._allocator = allocator;
        this._next = this._allocator.allocate(this._in);
    }

    public XMLStreamReader getXMLStreamReader() {
        return this._in;
    }

    public void close() throws XMLStreamException {
        this._in.close();
    }

    public String getElementText() throws XMLStreamException {
        return this._in.getElementText();
    }

    public Object getProperty(String name) throws IllegalArgumentException {
        throw new IllegalArgumentException(name);
    }

    public boolean hasNext() {
        try {
            return this._next != null || this._in.hasNext();
        }
        catch (XMLStreamException e) {
            return false;
        }
    }

    public XMLEvent nextEvent() throws XMLStreamException {
        if (this._next != null) {
            this._current = this._next;
            this._next = null;
        } else {
            this._in.next();
            this._current = this._allocator.allocate(this._in);
        }
        return this._current;
    }

    public XMLEvent nextTag() throws XMLStreamException {
        if (this._next != null) {
            this._current = this._next;
            this._next = null;
        } else {
            this._in.nextTag();
            this._current = this._allocator.allocate(this._in);
        }
        return this._current;
    }

    public XMLEvent peek() throws XMLStreamException {
        if (this._next == null) {
            this._in.next();
            this._next = this._allocator.allocate(this._in);
        }
        return this._next;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public XMLEvent next() {
        try {
            return this.nextEvent();
        }
        catch (XMLStreamException e) {
            return null;
        }
    }
}

