/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.pattern;

import com.caucho.xpath.Expr;
import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.pattern.NodeIterator;
import java.util.logging.Level;
import org.w3c.dom.Node;

public class FilterIterator
extends NodeIterator {
    private NodeIterator _parentIter;
    private Expr _expr;
    private Node _node;
    private Node _next;

    public FilterIterator(NodeIterator parentIter, Expr expr, ExprEnvironment env, Node context) throws XPathException {
        super(env);
        this._parentIter = parentIter;
        this._expr = expr;
        this._env = env;
        this._contextNode = context;
        this._node = this.findFirstMatchingNode(parentIter);
        this._position = 1;
        this._next = this._node;
    }

    public boolean hasNext() {
        if (this._next == null) {
            try {
                this._next = this.nextNode();
            }
            catch (XPathException e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
        return this._next != null;
    }

    public Node nextNode() throws XPathException {
        if (this._next != null) {
            this._node = this._next;
            this._next = null;
            return this._node;
        }
        if (this._node != null) {
            this._node = this.findFirstMatchingNode(this._parentIter);
            ++this._position;
        }
        this._next = null;
        return this._node;
    }

    private Node findFirstMatchingNode(NodeIterator parentIter) throws XPathException {
        Node node = parentIter.nextNode();
        double value;
        while (node == null || !(this._expr.isNumber() ? (value = this._expr.evalNumber(node, parentIter)) == (double)parentIter.getContextPosition() : (this._expr.isBoolean() ? this._expr.evalBoolean(node, parentIter) : ((value = this._expr.evalObject(node, parentIter)) instanceof Number ? Expr.toDouble(value) == (double)parentIter.getContextPosition() : Expr.toBoolean(value))))) {
            if (parentIter == null || (node = parentIter.nextNode()) == null) {
                return null;
            }
            if (parentIter.getContextPosition() == 1) {
                this._position = 0;
                this._size = 0;
            }
            this._contextNode = node;
            parentIter.setContextNode(node);
        }
        return node;
    }

    public Object clone() {
        FilterIterator clone = null;
        try {
            clone = this._parentIter == null ? new FilterIterator(null, this._expr, this._env, this._contextNode) : new FilterIterator((NodeIterator)this._parentIter.clone(), this._expr, this._env, this._contextNode);
            clone._env = this._env;
            clone._position = this._position;
            clone._node = this._node;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
        return clone;
    }

    public String toString() {
        return "FilterIterator[" + this._expr + "]";
    }
}

