/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.pattern;

import com.caucho.xpath.Env;
import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.pattern.AbstractPattern;
import com.caucho.xpath.pattern.Axis;
import org.w3c.dom.Node;

public class FromChildren
extends Axis {
    public FromChildren(AbstractPattern parent) {
        super(parent);
    }

    public boolean match(Node node, ExprEnvironment env) throws XPathException {
        if (node == null) {
            return false;
        }
        return this._parent == null || this._parent.match(node.getParentNode(), env);
    }

    public int position(Node node, Env env, AbstractPattern pattern) throws XPathException {
        int count = 1;
        for (node = node.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (pattern != null && !pattern.match(node, env)) continue;
            ++count;
        }
        return count;
    }

    public int count(Node node, Env env, AbstractPattern pattern) throws XPathException {
        int count = 0;
        for (node = node.getParentNode().getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!pattern.match(node, env)) continue;
            ++count;
        }
        return count;
    }

    public Node firstNode(Node node, ExprEnvironment env) {
        return node.getFirstChild();
    }

    public Node nextNode(Node node, Node lastNode) {
        return node.getNextSibling();
    }

    boolean isSingleLevel() {
        return this._parent == null || this._parent.isSingleLevel();
    }

    public boolean isStrictlyAscending() {
        if (this._parent == null) {
            return true;
        }
        return this._parent.isStrictlyAscending();
    }

    public boolean equals(Object b) {
        if (!(b instanceof FromChildren)) {
            return false;
        }
        FromChildren bPattern = (FromChildren)b;
        return this._parent == bPattern._parent || this._parent != null && this._parent.equals(bPattern._parent);
    }

    public String toString() {
        return this.getPrefix() + "child::";
    }
}

