/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.pattern;

import com.caucho.xpath.Env;
import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.pattern.AbstractPattern;
import com.caucho.xpath.pattern.Axis;
import org.w3c.dom.Node;

public class FromNextSibling
extends Axis {
    public FromNextSibling(AbstractPattern parent) {
        super(parent);
        if (parent == null) {
            throw new RuntimeException();
        }
    }

    public boolean match(Node node, ExprEnvironment env) throws XPathException {
        if (node == null) {
            return false;
        }
        for (node = node.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (!this._parent.match(node, env)) continue;
            return true;
        }
        return false;
    }

    public int position(Node node, Env env, AbstractPattern pattern) throws XPathException {
        int index = env.getPositionIndex();
        int count = 1;
        while ((node = node.getPreviousSibling()) != null) {
            if (this._parent.match(node, env) && --index <= 0) {
                for (node = node.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
                    if (!this._parent.match(node, env)) continue;
                    env.setMorePositions(true);
                    break;
                }
                return count;
            }
            if (!pattern.match(node, env)) continue;
            ++count;
        }
        return count;
    }

    public boolean isStrictlyAscending() {
        if (this._parent == null) {
            return true;
        }
        return this._parent.isSingleSelect();
    }

    public Node firstNode(Node node, ExprEnvironment env) {
        return node.getNextSibling();
    }

    public Node nextNode(Node node, Node lastNode) {
        return node.getNextSibling();
    }

    public String toString() {
        return this.getPrefix() + "following-sibling::";
    }
}

