/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.pattern;

import com.caucho.xml.XmlUtil;
import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.StylesheetEnv;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.XPathFun;
import com.caucho.xpath.expr.Var;
import com.caucho.xpath.pattern.SelectedAttribute;
import com.caucho.xpath.pattern.SelectedNode;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NodeIterator
implements ExprEnvironment,
Iterator<Node> {
    protected static final Logger log = Logger.getLogger(NodeIterator.class.getName());
    protected ExprEnvironment _env;
    protected Node _contextNode;
    protected int _position;
    protected int _size;

    protected NodeIterator(ExprEnvironment env) {
        this._env = env;
    }

    @Override
    public abstract boolean hasNext();

    public abstract Node nextNode() throws XPathException;

    @Override
    public Node next() {
        Node value = null;
        try {
            value = this.nextNode();
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
        return value;
    }

    public SelectedNode nextSelectedNode() throws XPathException {
        Node node = this.nextNode();
        if (node == null) {
            return null;
        }
        if (node instanceof Attr) {
            return new SelectedAttribute(node);
        }
        return new SelectedNode(node);
    }

    @Override
    public Node getCurrentNode() {
        return this._env.getCurrentNode();
    }

    @Override
    public Node getContextNode() {
        if (this._contextNode != null) {
            return this._contextNode;
        }
        return this._env.getContextNode();
    }

    @Override
    public Node setContextNode(Node node) {
        Node oldNode = this._contextNode;
        this._contextNode = node;
        return oldNode;
    }

    @Override
    public int getContextPosition() {
        return this._position;
    }

    @Override
    public int getContextSize() {
        if (this._size == 0) {
            this._size = this._position;
            NodeIterator clone = (NodeIterator)this.clone();
            try {
                while (clone != null && clone.nextNode() != null) {
                    ++this._size;
                }
            }
            catch (XPathException xPathException) {
                // empty catch block
            }
        }
        return this._size;
    }

    @Override
    public Document getOwnerDocument() {
        return this._env.getOwnerDocument();
    }

    @Override
    public Var getVar(String name) {
        return this._env.getVar(name);
    }

    @Override
    public XPathFun getFunction(String name) {
        return this._env.getFunction(name);
    }

    @Override
    public StylesheetEnv getStylesheetEnv() {
        return this._env.getStylesheetEnv();
    }

    @Override
    public Object systemProperty(String namespaceURI, String localName) {
        return this._env.getOwnerDocument();
    }

    @Override
    public String stringValue(Node node) {
        return XmlUtil.textValue(node);
    }

    public int getPositionIndex() {
        return 0;
    }

    public void setMorePositions(boolean more) {
    }

    public abstract Object clone();

    public void copy(NodeIterator src) {
        this._env = src._env;
        this._position = src._position;
        this._size = src._size;
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

