/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc.internal;

import com.clickhouse.client.ClickHouseClient;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.data.ClickHouseColumn;
import com.clickhouse.data.ClickHouseDataConfig;
import com.clickhouse.data.ClickHouseDataStreamFactory;
import com.clickhouse.data.ClickHouseDataType;
import com.clickhouse.data.ClickHouseInputStream;
import com.clickhouse.data.ClickHouseOutputStream;
import com.clickhouse.data.ClickHousePassThruStream;
import com.clickhouse.data.ClickHousePipedOutputStream;
import com.clickhouse.data.ClickHouseValues;
import com.clickhouse.data.ClickHouseWriter;
import com.clickhouse.jdbc.ClickHousePreparedStatement;
import com.clickhouse.jdbc.SqlExceptionUtils;
import com.clickhouse.jdbc.internal.AbstractPreparedStatement;
import com.clickhouse.jdbc.internal.ClickHouseConnectionImpl;
import com.clickhouse.jdbc.internal.ClickHouseParameterMetaData;
import com.clickhouse.jdbc.parser.ClickHouseSqlStatement;
import com.clickhouse.logging.Logger;
import com.clickhouse.logging.LoggerFactory;
import java.io.File;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

public class StreamBasedPreparedStatement
extends AbstractPreparedStatement
implements ClickHousePreparedStatement {
    private static final Logger log = LoggerFactory.getLogger(StreamBasedPreparedStatement.class);
    private static final String ERROR_SET_PARAM = "Please use setString()/setBytes()/setInputStream() or pass String/InputStream/ClickHouseInputStream to setObject() method instead";
    private static final String DEFAULT_KEY = "pipe";
    private static final List<ClickHouseColumn> DEFAULT_PARAMS = Collections.singletonList(ClickHouseColumn.of((String)"data", (ClickHouseDataType)ClickHouseDataType.String, (boolean)false, (ClickHouseColumn[])new ClickHouseColumn[0]));
    private final ClickHouseSqlStatement parsedStmt;
    private final ClickHouseParameterMetaData paramMetaData;
    private final List<ClickHouseInputStream> batch;
    private ClickHouseInputStream value;

    protected StreamBasedPreparedStatement(ClickHouseConnectionImpl connection, ClickHouseRequest<?> request, ClickHouseSqlStatement parsedStmt, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        super(connection, request, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.parsedStmt = parsedStmt;
        this.value = null;
        this.paramMetaData = new ClickHouseParameterMetaData(DEFAULT_PARAMS, this.mapper, connection.getTypeMap());
        this.batch = new LinkedList<ClickHouseInputStream>();
    }

    protected void ensureParams() throws SQLException {
        if (this.value == null) {
            throw SqlExceptionUtils.clientError("Missing input stream");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long[] executeAny(boolean asBatch) throws SQLException {
        this.ensureOpen();
        boolean continueOnError = false;
        if (asBatch) {
            if (this.batch.isEmpty()) {
                return ClickHouseValues.EMPTY_LONG_ARRAY;
            }
            continueOnError = this.getConnection().getJdbcConfig().isContinueBatchOnError();
        } else {
            try {
                if (!this.batch.isEmpty()) {
                    throw SqlExceptionUtils.undeterminedExecutionError();
                }
                this.addBatch();
            }
            catch (SQLException e) {
                this.clearBatch();
                throw e;
            }
        }
        long[] results = new long[this.batch.size()];
        int count = 0;
        String sql = (String)this.getRequest().getStatements(false).get(0);
        try {
            for (ClickHouseInputStream in : this.batch) {
                CompletableFuture future = (CompletableFuture)in.removeUserData(DEFAULT_KEY);
                results[count++] = this.executeInsert(sql, (InputStream)in);
                if (future == null) continue;
                future.get();
            }
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            if (!asBatch) {
                throw SqlExceptionUtils.handle(e, new Throwable[0]);
            }
            if (!continueOnError) {
                throw SqlExceptionUtils.batchUpdateError(e, results);
            }
            log.error((Object)"Failed to execute batch insert of %d records", new Object[]{count + 1, e});
        }
        finally {
            this.clearBatch();
        }
        return results;
    }

    @Override
    protected int getMaxParameterIndex() {
        return 1;
    }

    protected String getSql() {
        return (String)this.getRequest().getStatements(false).get(0);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.ensureParams();
        try {
            this.executeAny(false);
        }
        catch (SQLException e) {
            if (e.getSQLState() != null) {
                throw e;
            }
            throw new SQLException("Query failed", "07000", e.getCause());
        }
        ResultSet rs = this.getResultSet();
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.newEmptyResultSet();
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        this.ensureParams();
        try {
            this.executeAny(false);
        }
        catch (SQLException e) {
            if (e.getSQLState() != null) {
                throw e;
            }
            throw new SQLException("Update failed", "07000", e.getCause());
        }
        long row = this.getLargeUpdateCount();
        return row > 0L ? row : 0L;
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        throw SqlExceptionUtils.clientError(ERROR_SET_PARAM);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        throw SqlExceptionUtils.clientError(ERROR_SET_PARAM);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        throw SqlExceptionUtils.clientError(ERROR_SET_PARAM);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        throw SqlExceptionUtils.clientError(ERROR_SET_PARAM);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        throw SqlExceptionUtils.clientError(ERROR_SET_PARAM);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        throw SqlExceptionUtils.clientError(ERROR_SET_PARAM);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        throw SqlExceptionUtils.clientError(ERROR_SET_PARAM);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.ensureOpen();
        this.value = ClickHouseInputStream.of((String[])new String[]{x});
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.ensureOpen();
        this.value = ClickHouseInputStream.of((byte[][])new byte[][]{x});
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.ensureOpen();
        this.value = ClickHouseInputStream.of((InputStream)x);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.ensureOpen();
        this.value = null;
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.ensureOpen();
        if (x instanceof ClickHousePassThruStream) {
            ClickHousePassThruStream stream = (ClickHousePassThruStream)x;
            if (!stream.hasInput()) {
                throw SqlExceptionUtils.clientError("No input available in the given pass-thru stream");
            }
            this.value = stream.newInputStream(this.getConfig().getWriteBufferSize(), null);
        } else if (x instanceof ClickHouseWriter) {
            ClickHouseWriter writer = (ClickHouseWriter)x;
            ClickHousePipedOutputStream stream = ClickHouseDataStreamFactory.getInstance().createPipedOutputStream((ClickHouseDataConfig)this.getConfig());
            this.value = stream.getInputStream();
            this.value.setUserData(DEFAULT_KEY, (Object)ClickHouseClient.submit(() -> {
                try (ClickHousePipedOutputStream out = stream;){
                    writer.write((ClickHouseOutputStream)out);
                }
                return true;
            }));
        } else if (x instanceof InputStream) {
            this.value = ClickHouseInputStream.of((InputStream)((InputStream)x));
        } else if (x instanceof String) {
            this.value = ClickHouseInputStream.of((String[])new String[]{(String)x});
        } else if (x instanceof byte[]) {
            this.value = ClickHouseInputStream.of((byte[][])new byte[][]{(byte[])x});
        } else if (x instanceof File) {
            this.value = ClickHouseInputStream.of((File[])new File[]{(File)x});
        } else {
            throw SqlExceptionUtils.clientError("Only byte[], String, File, InputStream, ClickHousePassThruStream, and ClickHouseWriter are supported");
        }
    }

    @Override
    public boolean execute() throws SQLException {
        this.ensureParams();
        if (!this.batch.isEmpty()) {
            throw SqlExceptionUtils.undeterminedExecutionError();
        }
        String sql = this.getSql();
        CompletableFuture future = (CompletableFuture)this.value.removeUserData(DEFAULT_KEY);
        this.executeInsert(sql, (InputStream)this.value);
        if (future != null) {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.warn((Object)"Execution of query was interrupted: %s", new Object[]{sql});
            }
            catch (ExecutionException e) {
                throw SqlExceptionUtils.handle(e.getCause(), new Throwable[0]);
            }
        }
        return false;
    }

    @Override
    public void addBatch() throws SQLException {
        this.ensureOpen();
        this.ensureParams();
        this.batch.add(this.value);
        this.clearParameters();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.ensureOpen();
        this.batch.clear();
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        throw SqlExceptionUtils.clientError(ERROR_SET_PARAM);
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        throw SqlExceptionUtils.clientError(ERROR_SET_PARAM);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        throw SqlExceptionUtils.clientError(ERROR_SET_PARAM);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        throw SqlExceptionUtils.clientError(ERROR_SET_PARAM);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.ensureOpen();
        this.value = ClickHouseInputStream.empty();
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.paramMetaData;
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.setObject(parameterIndex, x);
    }
}

