/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.http;

import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.http.ApacheHttpConnectionImpl;
import com.clickhouse.client.http.ClickHouseHttpConnection;
import com.clickhouse.client.http.HttpClientConnectionImpl;
import com.clickhouse.client.http.HttpUrlConnectionImpl;
import com.clickhouse.client.http.config.ClickHouseHttpOption;
import com.clickhouse.client.http.config.HttpConnectionProvider;
import com.clickhouse.config.ClickHouseOption;
import com.clickhouse.logging.Logger;
import com.clickhouse.logging.LoggerFactory;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ExecutorService;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class ClickHouseHttpConnectionFactory {
    private static final Logger log = LoggerFactory.getLogger(ClickHouseHttpConnectionFactory.class);

    public static ClickHouseHttpConnection createConnection(ClickHouseNode server, ClickHouseRequest<?> request, ExecutorService executor) throws IOException {
        return ClickHouseHttpConnectionFactory.createConnection(server, request, executor, Collections.emptyMap());
    }

    public static ClickHouseHttpConnection createConnection(ClickHouseNode server, ClickHouseRequest<?> request, ExecutorService executor, Map<String, Serializable> additionalRequestParams) throws IOException {
        HttpConnectionProvider provider = request.getConfig().getOption((ClickHouseOption)ClickHouseHttpOption.CONNECTION_PROVIDER, HttpConnectionProvider.class);
        if (provider == HttpConnectionProvider.APACHE_HTTP_CLIENT) {
            try {
                return new ApacheHttpConnectionImpl(server, request, executor);
            }
            catch (ExceptionInInitializerError | NoClassDefFoundError t) {
                log.warn((Object)"Error when creating %s, fall back to HTTP_URL_CONNECTION", new Object[]{provider, t});
            }
        } else if (provider == HttpConnectionProvider.HTTP_CLIENT) {
            return new HttpClientConnectionImpl(server, request, executor, additionalRequestParams);
        }
        return new HttpUrlConnectionImpl(server, request, executor, additionalRequestParams);
    }

    private ClickHouseHttpConnectionFactory() {
    }
}

