/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data;

import com.clickhouse.data.ClickHouseCache;
import java.io.Serializable;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ClickHouseVersion
implements Comparable<ClickHouseVersion>,
Serializable {
    private static final long serialVersionUID = 6721014333437055314L;
    private static final String STR_LATEST = "latest";
    private static final ClickHouseVersion defaultVersion = new ClickHouseVersion(false, 0, 0, 0, 0);
    private static final ClickHouseVersion latestVersion = new ClickHouseVersion(true, 0, 0, 0, 0);
    private static final ClickHouseCache<String, ClickHouseVersion> versionCache = ClickHouseCache.create(100, 300L, ClickHouseVersion::parseVersion);
    private static final Pattern versionPattern = Pattern.compile("^(?:.*?[\\s:])?(\\d+)(?:\\s*\\.\\s*(\\d+))?(?:\\s*\\.\\s*(\\d+))?(?:\\s*\\.\\s*(\\d+))?(?:|[\\.\\s].*)", 32);
    private final boolean latest;
    private final int year;
    private final int feature;
    private final int maintenance;
    private final int build;

    public static boolean check(String version, String range) {
        return ClickHouseVersion.of(version).check(range);
    }

    public static int compare(String fromVersion, String toVersion) {
        return ClickHouseVersion.of(fromVersion).compareTo(ClickHouseVersion.of(toVersion));
    }

    public static ClickHouseVersion of(String version) {
        if (version == null || version.isEmpty()) {
            return defaultVersion;
        }
        return versionCache.get(version);
    }

    public static ClickHouseVersion of(int yearOrMajor, int ... more) {
        int len = more != null ? more.length : 0;
        return new ClickHouseVersion(false, yearOrMajor, len > 0 ? more[0] : 0, len > 1 ? more[1] : 0, len > 2 ? more[2] : 0);
    }

    protected static ClickHouseVersion parseVersion(String version) {
        if (version == null || version.isEmpty()) {
            return defaultVersion;
        }
        boolean latest = false;
        int[] parts = new int[4];
        Matcher m = versionPattern.matcher(version);
        if (m.matches()) {
            int len = Math.min(m.groupCount(), parts.length);
            for (int i = 0; i < len; ++i) {
                try {
                    parts[i] = Integer.parseInt(m.group(i + 1));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        } else {
            int index = Math.max((version = version.trim().toLowerCase(Locale.ROOT)).lastIndexOf(32), version.lastIndexOf(58));
            latest = STR_LATEST.equals(index == -1 ? version : version.substring(index + 1));
        }
        return latest ? latestVersion : new ClickHouseVersion(false, parts[0], parts[1], parts[2], parts[3]);
    }

    protected ClickHouseVersion(boolean latest, int year, int feature, int maintenance, int build) {
        this.latest = latest;
        if (latest) {
            this.year = 0;
            this.feature = 0;
            this.maintenance = 0;
            this.build = 0;
        } else {
            this.year = year > 0 ? year : 0;
            this.feature = feature > 0 ? feature : 0;
            this.maintenance = maintenance > 0 ? maintenance : 0;
            this.build = build > 0 ? build : 0;
        }
    }

    protected int compareTo(ClickHouseVersion o, boolean sameSeriesComparison) {
        if (o == null) {
            o = defaultVersion;
        }
        if (this == o) {
            return 0;
        }
        if (this.latest) {
            return o.latest ? 0 : 1;
        }
        if (o.latest) {
            return -1;
        }
        int result = this.year - o.year;
        if (result != 0) {
            return result;
        }
        if (sameSeriesComparison && o.feature == 0 && o.maintenance == 0 && o.build == 0) {
            return 0;
        }
        result = this.feature - o.feature;
        if (result != 0) {
            return result;
        }
        if (sameSeriesComparison && o.maintenance == 0 && o.build == 0) {
            return 0;
        }
        result = this.maintenance - o.maintenance;
        if (result != 0) {
            return result;
        }
        if (sameSeriesComparison && o.build == 0) {
            return 0;
        }
        return this.build - o.build;
    }

    public boolean belongsTo(ClickHouseVersion version) {
        if (version == null) {
            version = defaultVersion;
        }
        if (this.isLatest()) {
            return version.isLatest();
        }
        if (version.isLatest()) {
            return false;
        }
        if (this.year != version.year) {
            return false;
        }
        if (version.feature == 0 && version.maintenance == 0 && version.build == 0) {
            return true;
        }
        if (this.feature != version.feature) {
            return false;
        }
        if (version.maintenance == 0 && version.build == 0) {
            return true;
        }
        if (this.maintenance != version.maintenance) {
            return false;
        }
        return version.build == 0 || this.build == version.build;
    }

    public boolean belongsTo(String version) {
        return this.belongsTo(ClickHouseVersion.of(version));
    }

    public boolean isLatest() {
        return this.latest;
    }

    public int getYear() {
        return this.year;
    }

    public int getFeatureRelease() {
        return this.feature;
    }

    public int getMaintenanceRelease() {
        return this.maintenance;
    }

    public int getBuilderNumber() {
        return this.build;
    }

    public int getMajorVersion() {
        return this.getYear();
    }

    public int getMinorVersion() {
        return this.getFeatureRelease();
    }

    public int getPatch() {
        return this.getMaintenanceRelease();
    }

    public boolean isNewerOrEqualTo(ClickHouseVersion version) {
        return this.compareTo(version, true) >= 0;
    }

    public boolean isNewerOrEqualTo(String version) {
        return this.isNewerOrEqualTo(ClickHouseVersion.of(version));
    }

    public boolean isNewerThan(ClickHouseVersion version) {
        return this.compareTo(version, false) > 0;
    }

    public boolean isNewerThan(String version) {
        return this.isNewerThan(ClickHouseVersion.of(version));
    }

    public boolean isOlderOrEqualTo(ClickHouseVersion version) {
        return this.compareTo(version, true) <= 0;
    }

    public boolean isOlderOrEqualTo(String version) {
        return this.isOlderOrEqualTo(ClickHouseVersion.of(version));
    }

    public boolean isOlderThan(ClickHouseVersion version) {
        return this.compareTo(version, false) < 0;
    }

    public boolean isOlderThan(String version) {
        return this.isOlderThan(ClickHouseVersion.of(version));
    }

    public boolean check(String range) {
        if (range == null || range.isEmpty()) {
            return false;
        }
        boolean result = false;
        StringBuilder builder = new StringBuilder();
        int len = range.length();
        for (int i = 0; i < len; ++i) {
            char ch = range.charAt(i);
            if (ch >= '0' && ch <= '9' || ch == '.') {
                builder.append(ch);
                continue;
            }
            if (ch == '[' || ch == '(') {
                if (builder.length() > 0) {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "Expect a comma after %s at %d but got %s", builder.toString(), i, Character.valueOf(ch)));
                }
                ClickHouseVersion v1 = null;
                ClickHouseVersion v2 = null;
                char nextCh = '\u0000';
                ++i;
                while (i < len) {
                    nextCh = range.charAt(i);
                    if (nextCh >= '0' && nextCh <= '9' || nextCh == '.') {
                        builder.append(nextCh);
                    } else if (nextCh == ',') {
                        v1 = ClickHouseVersion.of(builder.toString());
                        builder.setLength(0);
                    } else if (nextCh == ')' || nextCh == ']') {
                        if (builder.length() == 0) {
                            v2 = latestVersion;
                            break;
                        }
                        v2 = ClickHouseVersion.of(builder.toString());
                        builder.setLength(0);
                        break;
                    }
                    ++i;
                }
                if (v1 == null || v2 == null) {
                    throw new IllegalArgumentException("Brackets must come in pairs and at least one version and a comma must be specified within brackets");
                }
                boolean bl = result = ch == '(' ? this.isNewerThan(v1) : this.isNewerOrEqualTo(v1);
                if (!result) break;
                boolean bl2 = nextCh == ')' ? this.latest || this.isOlderThan(v2) : (result = this.isOlderOrEqualTo(v2));
                if (result) continue;
                break;
            }
            if (ch != ',' || builder.length() <= 0) continue;
            ClickHouseVersion v = ClickHouseVersion.of(builder.toString());
            builder.setLength(0);
            result = this.belongsTo(v);
            if (!result) break;
        }
        if (builder.length() > 0) {
            result = this.belongsTo(builder.toString());
        }
        return result;
    }

    @Override
    public int compareTo(ClickHouseVersion o) {
        return this.compareTo(o, false);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ClickHouseVersion other = (ClickHouseVersion)obj;
        return this.latest && other.latest || this.latest == other.latest && this.year == other.year && this.feature == other.feature && this.maintenance == other.maintenance && this.build == other.build;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.latest ? 1231 : 1237);
        result = 31 * result + this.year;
        result = 31 * result + this.feature;
        result = 31 * result + this.maintenance;
        result = 31 * result + this.build;
        return result;
    }

    public String toString() {
        return this.isLatest() ? STR_LATEST : "" + this.year + '.' + this.feature + '.' + this.maintenance + '.' + this.build;
    }
}

