/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.internal;

import com.clickhouse.client.api.ClickHouseException;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayDeque;
import java.util.List;

public abstract class BaseCollectionConverter<ACC, LIST> {
    public static final String ARRAY_START = "[";
    public static final String ARRAY_END = "]";
    private final String itemDelimiter;

    protected BaseCollectionConverter(String itemDelimiter) {
        this.itemDelimiter = itemDelimiter;
    }

    protected abstract void setAccumulator(ACC var1);

    protected abstract void append(String var1);

    protected abstract String buildString();

    protected abstract void onStart(ListConversionState<LIST> var1);

    protected abstract void onEnd(ListConversionState<LIST> var1);

    protected abstract void onItem(Object var1, ListConversionState<LIST> var2);

    protected abstract String onEmptyCollection();

    protected abstract boolean isEmpty(LIST var1);

    protected abstract boolean isSubList(Object var1);

    protected abstract int listSize(LIST var1);

    protected abstract Object getNext(ListConversionState<LIST> var1);

    public final String convert(LIST value, ACC acc) {
        if (this.isEmpty(value)) {
            return this.onEmptyCollection();
        }
        this.setAccumulator(acc);
        ArrayDeque stack = new ArrayDeque();
        ListConversionState state = new ListConversionState(value, this.listSize(value));
        while (state != null) {
            if (state.isFirst()) {
                this.onStart(state);
            }
            if (state.hasNext()) {
                Object item = this.getNext(state);
                state.incPos();
                if (this.isSubList(item)) {
                    stack.push(state);
                    Object list = item;
                    state = new ListConversionState(list, this.listSize(list));
                    continue;
                }
                this.onItem(item, state);
                if (!state.hasNext()) continue;
                this.append(this.itemDelimiter);
                continue;
            }
            this.onEnd(state);
            state = stack.isEmpty() ? null : (ListConversionState)stack.pop();
            if (state == null || !state.hasNext()) continue;
            this.append(this.itemDelimiter);
        }
        return this.buildString();
    }

    public static final class ListConversionState<LIST> {
        final LIST list;
        int position;
        int size;

        private ListConversionState(LIST list, int size) {
            this.list = list;
            this.position = 0;
            this.size = size;
        }

        public LIST getList() {
            return this.list;
        }

        public int getPosition() {
            return this.position;
        }

        public void incPos() {
            ++this.position;
        }

        public boolean hasNext() {
            return this.position < this.size;
        }

        public boolean isFirst() {
            return this.position == 0;
        }
    }

    public static abstract class BaseCollectionWriter<T>
    extends BaseCollectionConverter<Appendable, T> {
        protected Appendable appendable;

        protected BaseCollectionWriter(String itemDelimiter) {
            super(itemDelimiter);
        }

        @Override
        protected void setAccumulator(Appendable appendable) {
            this.appendable = appendable;
        }

        @Override
        protected void append(String str) {
            try {
                this.appendable.append(str);
            }
            catch (IOException e) {
                throw new ClickHouseException(e.getMessage(), e);
            }
        }

        @Override
        protected String buildString() {
            return this.appendable.toString();
        }

        @Override
        protected void onStart(ListConversionState<T> state) {
            try {
                this.appendable.append(BaseCollectionConverter.ARRAY_START);
            }
            catch (IOException e) {
                throw new ClickHouseException(e.getMessage(), e);
            }
        }

        @Override
        protected void onEnd(ListConversionState<T> state) {
            try {
                this.appendable.append(BaseCollectionConverter.ARRAY_END);
            }
            catch (IOException e) {
                throw new ClickHouseException(e.getMessage(), e);
            }
        }

        @Override
        protected String onEmptyCollection() {
            return "[]";
        }
    }

    public static abstract class BaseListWriter
    extends BaseCollectionWriter<List<?>> {
        protected BaseListWriter() {
            super(", ");
        }

        @Override
        protected boolean isEmpty(List<?> objects) {
            return objects.isEmpty();
        }

        @Override
        protected boolean isSubList(Object list) {
            return list instanceof List;
        }

        @Override
        protected int listSize(List<?> objects) {
            return objects.size();
        }

        @Override
        protected Object getNext(ListConversionState<List<?>> state) {
            return state.getList().get(state.getPosition());
        }
    }

    public static abstract class BaseArrayWriter
    extends BaseCollectionWriter<Object> {
        protected BaseArrayWriter() {
            super(", ");
        }

        @Override
        protected boolean isEmpty(Object objects) {
            return this.listSize(objects) == 0;
        }

        @Override
        protected boolean isSubList(Object list) {
            return list != null && list.getClass().isArray();
        }

        @Override
        protected int listSize(Object objects) {
            return Array.getLength(objects);
        }

        @Override
        protected Object getNext(ListConversionState<Object> state) {
            return Array.get(state.getList(), state.getPosition());
        }
    }
}

