/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.query;

import com.clickhouse.client.api.data_formats.ClickHouseBinaryFormatReader;
import com.clickhouse.client.api.data_formats.internal.BinaryReaderBackedRecord;
import com.clickhouse.client.api.metrics.OperationMetrics;
import com.clickhouse.client.api.metrics.ServerMetrics;
import com.clickhouse.client.api.query.GenericRecord;
import com.clickhouse.client.api.query.QueryResponse;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class Records
implements Iterable<GenericRecord>,
AutoCloseable {
    private final QueryResponse response;
    private final ClickHouseBinaryFormatReader reader;
    private boolean empty;
    private Iterator<GenericRecord> iterator;

    public Records(QueryResponse response, ClickHouseBinaryFormatReader reader) {
        this.response = response;
        this.reader = reader;
        this.empty = !reader.hasNext();
    }

    @Override
    public Iterator<GenericRecord> iterator() {
        if (this.iterator != null) {
            throw new IllegalStateException("Iterator has already been created");
        }
        this.iterator = new Iterator<GenericRecord>(){
            GenericRecord record;
            {
                this.record = new BinaryReaderBackedRecord(Records.this.reader);
            }

            @Override
            public boolean hasNext() {
                return Records.this.reader.hasNext();
            }

            @Override
            public GenericRecord next() {
                Records.this.reader.next();
                return this.record;
            }
        };
        return this.iterator;
    }

    @Override
    public Spliterator<GenericRecord> spliterator() {
        return Iterable.super.spliterator();
    }

    public boolean isEmpty() {
        return this.empty;
    }

    Stream<GenericRecord> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public OperationMetrics getMetrics() {
        return this.response.getMetrics();
    }

    public long getReadRows() {
        return this.response.getMetrics().getMetric(ServerMetrics.NUM_ROWS_READ).getLong();
    }

    public long getReadBytes() {
        return this.response.getMetrics().getMetric(ServerMetrics.NUM_BYTES_READ).getLong();
    }

    public long getWrittenRows() {
        return this.response.getMetrics().getMetric(ServerMetrics.NUM_ROWS_WRITTEN).getLong();
    }

    public long getWrittenBytes() {
        return this.response.getMetrics().getMetric(ServerMetrics.NUM_BYTES_WRITTEN).getLong();
    }

    public long getServerTime() {
        return this.response.getMetrics().getMetric(ServerMetrics.ELAPSED_TIME).getLong();
    }

    public long getResultRows() {
        return this.response.getMetrics().getMetric(ServerMetrics.RESULT_ROWS).getLong();
    }

    @Override
    public void close() throws Exception {
        this.response.close();
    }
}

