/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.sql;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SQLUtils {
    private static final Pattern SIMPLE_IDENTIFIER_PATTERN = Pattern.compile("^[a-zA-Z][a-zA-Z0-9_]{0,127}$");
    private static final Pattern UNQUOTE_INDENTIFIER = Pattern.compile("^[\\\"`]?(.+?)[\\\"`]?$");

    public static String enquoteLiteral(String str) {
        if (str == null) {
            throw new IllegalArgumentException("Input string cannot be null");
        }
        return "'" + str.replace("'", "''") + "'";
    }

    public static String enquoteIdentifier(String identifier, boolean quotesRequired) {
        if (identifier == null) {
            throw new IllegalArgumentException("Identifier cannot be null");
        }
        if (!quotesRequired && !SQLUtils.needsQuoting(identifier)) {
            return identifier;
        }
        return "\"" + identifier.replace("\"", "\"\"") + "\"";
    }

    public static String enquoteIdentifier(String identifier) {
        return SQLUtils.enquoteIdentifier(identifier, true);
    }

    private static boolean needsQuoting(String identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException("identifier cannot be null");
        }
        if (identifier.isEmpty()) {
            return true;
        }
        if (Character.isDigit(identifier.charAt(0))) {
            return true;
        }
        for (int i = 0; i < identifier.length(); ++i) {
            char c = identifier.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_') continue;
            return true;
        }
        return false;
    }

    public static boolean isSimpleIdentifier(String identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException("Identifier cannot be null");
        }
        return SIMPLE_IDENTIFIER_PATTERN.matcher(identifier).matches();
    }

    public static String unquoteIdentifier(String str) {
        Matcher matcher = UNQUOTE_INDENTIFIER.matcher(str.trim());
        if (matcher.find()) {
            return matcher.group(1);
        }
        return str;
    }

    public static String escapeSingleQuotes(String x) {
        return x.replace("\\", "\\\\").replace("'", "\\'");
    }
}

