/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc.internal;

import com.clickhouse.client.api.Client;
import com.clickhouse.client.api.ClientConfigProperties;
import com.clickhouse.jdbc.Driver;
import com.clickhouse.jdbc.internal.DriverProperties;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcConfiguration {
    private static final Logger log = LoggerFactory.getLogger(JdbcConfiguration.class);
    public static final String PREFIX_CLICKHOUSE = "jdbc:clickhouse:";
    public static final String PREFIX_CLICKHOUSE_SHORT = "jdbc:ch:";
    public static final String USE_SSL_PROP = "ssl";
    final boolean disableFrameworkDetection;
    final Map<String, String> clientProperties;
    private final Map<String, String> driverProperties;
    private final String connectionUrl;
    private boolean isIgnoreUnsupportedRequests;
    List<DriverPropertyInfo> listOfProperties;
    private static final Pattern URL_REGEXP = Pattern.compile("(https?:)?\\/\\/([\\w\\.\\-]+):?([\\d]*)(?:\\/([\\w]+))?\\/?\\??(.*)$");
    private static final Pattern PARAM_EXTRACT_REGEXP = Pattern.compile("(?:&?[\\w\\.]+)=(?:[\\\\w])*");
    private static final String PARSE_URL_CONN_URL_PROP = "connection_url";

    public Map<String, String> getClientProperties() {
        return ImmutableMap.copyOf(this.clientProperties);
    }

    public boolean isDisableFrameworkDetection() {
        return this.disableFrameworkDetection;
    }

    public boolean isIgnoreUnsupportedRequests() {
        return this.isIgnoreUnsupportedRequests;
    }

    public JdbcConfiguration(String url, Properties info) throws SQLException {
        this.disableFrameworkDetection = Boolean.parseBoolean(info.getProperty("disable_frameworks_detection", "false"));
        this.clientProperties = new HashMap<String, String>();
        this.driverProperties = new HashMap<String, String>();
        Map<String, String> urlProperties = this.parseUrl(url);
        String tmpConnectionUrl = urlProperties.remove(PARSE_URL_CONN_URL_PROP);
        this.initProperties(urlProperties, info);
        boolean useSSLInfo = Boolean.parseBoolean(info.getProperty(DriverProperties.SECURE_CONNECTION.getKey(), "false"));
        boolean useSSLUrlProperties = Boolean.parseBoolean(urlProperties.getOrDefault(DriverProperties.SECURE_CONNECTION.getKey(), "false"));
        boolean useSSL = useSSLInfo || useSSLUrlProperties;
        String bearerToken = info.getProperty(ClientConfigProperties.BEARERTOKEN_AUTH.getKey(), null);
        if (bearerToken != null) {
            this.clientProperties.put(ClientConfigProperties.BEARERTOKEN_AUTH.getKey(), bearerToken);
        }
        this.connectionUrl = JdbcConfiguration.createConnectionURL(tmpConnectionUrl, useSSL);
        this.isIgnoreUnsupportedRequests = Boolean.parseBoolean(this.getDriverProperty(DriverProperties.IGNORE_UNSUPPORTED_VALUES.getKey(), "false"));
    }

    public static boolean acceptsURL(String url) {
        return url.startsWith(PREFIX_CLICKHOUSE) || url.startsWith(PREFIX_CLICKHOUSE_SHORT);
    }

    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    static String createConnectionURL(String url, boolean ssl) throws SQLException {
        if (url.startsWith("//")) {
            url = (ssl ? "https:" : "http:") + url;
        }
        try {
            URI tmp = URI.create(url);
            return tmp.getScheme() + "://" + tmp.getAuthority();
        }
        catch (Exception e) {
            throw new SQLException("Failed to parse url", e);
        }
    }

    private static String stripJDBCPrefix(String url) {
        if (url.startsWith(PREFIX_CLICKHOUSE)) {
            return url.substring(PREFIX_CLICKHOUSE.length());
        }
        if (url.startsWith(PREFIX_CLICKHOUSE_SHORT)) {
            return url.substring(PREFIX_CLICKHOUSE_SHORT.length());
        }
        throw new IllegalArgumentException("Specified URL doesn't have jdbc any of prefixes: [ jdbc:clickhouse:, jdbc:ch: ]");
    }

    private Map<String, String> parseUrl(String url) throws SQLException {
        Matcher qm;
        String queryStr;
        HashMap<String, String> properties = new HashMap<String, String>();
        Matcher m = URL_REGEXP.matcher(url = JdbcConfiguration.stripJDBCPrefix(url));
        if (!m.find()) {
            throw new SQLException("Invalid url " + url);
        }
        String proto = m.group(1);
        String host = m.group(2);
        String port = m.group(3);
        String connectionUrl = (proto == null ? "" : proto) + "//" + host + (port.isEmpty() ? "" : ":" + port);
        properties.put(PARSE_URL_CONN_URL_PROP, connectionUrl);
        String database = m.group(4);
        if (database != null && !database.isEmpty()) {
            properties.put(ClientConfigProperties.DATABASE.getKey(), database);
        }
        if ((queryStr = m.group(5)) != null && !queryStr.isEmpty() && (qm = PARAM_EXTRACT_REGEXP.matcher(queryStr)).find()) {
            String value;
            String name = queryStr.substring(qm.start() + (queryStr.charAt(qm.start()) == '&' ? 1 : 0), qm.end() - 1);
            int valStartPos = qm.end();
            while (qm.find()) {
                value = queryStr.substring(valStartPos, qm.start());
                properties.put(name, value);
                name = queryStr.substring(qm.start() + (queryStr.charAt(qm.start()) == '&' ? 1 : 0), qm.end() - 1);
                valStartPos = qm.end();
            }
            value = queryStr.substring(valStartPos);
            properties.put(name, value);
        }
        return properties;
    }

    private void initProperties(Map<String, String> urlProperties, Properties providedProperties) {
        DriverPropertyInfo propertyInfo;
        HashMap<String, String> props = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : providedProperties.entrySet()) {
            if (entry.getKey() instanceof String && entry.getValue() instanceof String) {
                props.put((String)entry.getKey(), (String)entry.getValue());
                continue;
            }
            throw new IllegalArgumentException("Property key and value should be a string");
        }
        props.putAll(urlProperties);
        HashMap<String, DriverPropertyInfo> propertyInfos = new HashMap<String, DriverPropertyInfo>();
        for (Map.Entry prop : props.entrySet()) {
            DriverPropertyInfo propertyInfo2 = new DriverPropertyInfo((String)prop.getKey(), (String)prop.getValue());
            propertyInfo2.description = "(User Defined)";
            propertyInfos.put((String)prop.getKey(), propertyInfo2);
            this.clientProperties.put((String)prop.getKey(), (String)prop.getValue());
        }
        for (ClientConfigProperties clientConfigProperties : ClientConfigProperties.values()) {
            propertyInfo = (DriverPropertyInfo)propertyInfos.get(clientConfigProperties.getKey());
            if (propertyInfo != null) continue;
            propertyInfo = new DriverPropertyInfo(clientConfigProperties.getKey(), clientConfigProperties.getDefaultValue());
            propertyInfos.put(clientConfigProperties.getKey(), propertyInfo);
        }
        for (Enum enum_ : DriverProperties.values()) {
            String value;
            propertyInfo = (DriverPropertyInfo)propertyInfos.get(((DriverProperties)enum_).getKey());
            if (propertyInfo == null) {
                propertyInfo = new DriverPropertyInfo(((DriverProperties)enum_).getKey(), ((DriverProperties)enum_).getDefaultValue());
                propertyInfos.put(((DriverProperties)enum_).getKey(), propertyInfo);
            }
            if ((value = this.clientProperties.get(((DriverProperties)enum_).getKey())) == null) continue;
            this.driverProperties.put(((DriverProperties)enum_).getKey(), value);
        }
        this.listOfProperties = propertyInfos.values().stream().sorted(Comparator.comparing(o -> o.name)).collect(Collectors.toList());
    }

    public List<DriverPropertyInfo> getDriverPropertyInfo() {
        return this.listOfProperties;
    }

    public String getDriverProperty(String key, String defaultValue) {
        return this.driverProperties.getOrDefault(key, defaultValue);
    }

    public Client.Builder applyClientProperties(Client.Builder builder) {
        builder.addEndpoint(this.connectionUrl).setOptions(this.clientProperties);
        return builder;
    }

    public void updateUserClient(String clientName, Client client) {
        client.updateClientName((clientName == null || clientName.isEmpty() ? "" : clientName) + ' ' + JdbcConfiguration.getDefaultClientName());
    }

    public static String getDefaultClientName() {
        StringBuilder jdbcName = new StringBuilder();
        jdbcName.append("jdbc-v2/").append(Driver.driverVersion);
        return jdbcName.toString();
    }
}

