/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.commons.gsm;

import com.cloudhopper.commons.gsm.Npi;
import com.cloudhopper.commons.gsm.Ton;

public class TypeOfAddress {
    private Ton ton;
    private Npi npi;

    public TypeOfAddress(Ton ton, Npi npi) {
        this.ton = ton;
        this.npi = npi;
    }

    public Ton getTon() {
        return this.ton;
    }

    public void setTon(Ton ton) {
        this.ton = ton;
    }

    public Npi getNpi() {
        return this.npi;
    }

    public void setNpi(Npi npi) {
        this.npi = npi;
    }

    public byte toByte() {
        return TypeOfAddress.toByte(this);
    }

    public static byte toByte(TypeOfAddress toa) {
        byte b = 0;
        if (toa.getTon() != null) {
            b = (byte)(b | toa.getTon().toInt() << 0);
        }
        if (toa.getNpi() != null) {
            b = (byte)(b | toa.getNpi().toInt() << 4);
        }
        b = (byte)(b | 0x80);
        return b;
    }

    public static TypeOfAddress valueOf(byte b) {
        int ton = b & 0xF;
        int npi = b >> 4 & 7;
        return new TypeOfAddress(Ton.fromInt(ton), Npi.fromInt(npi));
    }

    public String toString() {
        return "ton=" + (Object)((Object)this.ton) + ", npi=" + (Object)((Object)this.npi);
    }
}

