/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.internal;

import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.contentsquare.android.internal.ConfigurationCompositor$AjcClosure1;
import com.contentsquare.android.internal.config.ProjectConfiguration;
import com.contentsquare.android.internal.logging.Logger;
import com.contentsquare.android.internal.util.Strings;
import com.contentsquare.android.internal.validator.InSampleIntervalValidator;
import hugo.weaving.DebugLog;
import hugo.weaving.internal.Hugo;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.json.JSONException;
import org.json.JSONObject;

public class ConfigurationCompositor {
    public static final String CS_PROJECT_ID = "cs_project_id";
    public static final String CONFIG_VERSION = "version";
    public static final String TRACKER_ACTIVE = "enabled";
    public static final String ANONYMIZE = "anonymize";
    public static final String TRACKER_ENDPOINT_URL = "endpoint";
    public static final String SAMPLE_RATE = "sample";
    public static final String STORAGE_MAX_ITEMS = "bucket";
    public static final String SCREEN_RECORD_ACTIVE = "screenshots";
    public static final String DEBUG_FLAG = "debug_flag";
    public static final String BLACKLISTED_VERSIONS = "blacklisted";
    private static final Logger LOGGER;
    @NonNull
    private final InSampleIntervalValidator mInSampleValidator;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public ConfigurationCompositor(@NonNull InSampleIntervalValidator sampleIntervalValidator) {
        this.mInSampleValidator = sampleIntervalValidator;
    }

    @NonNull
    public ProjectConfiguration getRunConfiguration(String ... data) {
        ProjectConfiguration.Builder builder = ProjectConfiguration.builder();
        if (data != null) {
            for (String config : data) {
                this.updateBuilderBasedOnJsonConfig(config, builder);
            }
        } else {
            LOGGER.d("No data passed to config", new Object[0]);
        }
        return builder.build();
    }

    @DebugLog
    @NonNull
    @CheckResult
    public ProjectConfiguration updateRunConfigurationFromConfig(@NonNull ProjectConfiguration config, @Nullable String data) {
        ProjectConfiguration projectConfiguration = config;
        String string = data;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)projectConfiguration, (Object)string);
        Object[] objectArray = new Object[]{this, projectConfiguration, string, joinPoint};
        return (ProjectConfiguration)Hugo.aspectOf().logAndExecute(new ConfigurationCompositor$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    public boolean validateConfig(@NonNull String config) {
        return config.contains(CS_PROJECT_ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBuilderBasedOnJsonConfig(@Nullable String data, @NonNull ProjectConfiguration.Builder builder) {
        LOGGER.d("updating config with : %s", Strings.nullToEmpty(data));
        if (Strings.isNullOrEmpty(data)) {
            return;
        }
        try {
            JSONObject object = new JSONObject(data);
            builder.csProjectId(this.opt(object, CS_PROJECT_ID, builder.getCsProjectId()));
            builder.configVersion(this.opt(object, CONFIG_VERSION, builder.getVersion()));
            builder.trackingEnabled(object.optBoolean(TRACKER_ACTIVE, builder.isTrackerEnabled()));
            builder.anonymize(object.optBoolean(ANONYMIZE, builder.isAnonymized()));
            builder.collectorEndpoint(this.opt(object, TRACKER_ENDPOINT_URL, builder.getCollectorEndpoint()));
            builder.samplingRate(this.opt(object, SAMPLE_RATE, builder.getSampleRateValue()));
            builder.maxBucketSize(this.opt(object, STORAGE_MAX_ITEMS, builder.getMaxBucketSize()));
            builder.debugFlag(this.opt(object, DEBUG_FLAG, builder.getDebugFlag()));
            builder.screenShotsEnabled(object.optBoolean(SCREEN_RECORD_ACTIVE, builder.isScreenShotEnabled()));
            builder.blackListedVersionsList(this.opt(object, BLACKLISTED_VERSIONS, builder.getBlackListedVersionsList()));
        }
        catch (JSONException e) {
            LOGGER.w(e, "cannot parse JSon Object. Exception thrown: ", new Object[0]);
        }
        finally {
            builder.inSamplingInterval(this.mInSampleValidator.isInSampleInterval(builder.getSampleRateValue()));
        }
    }

    private int opt(@NonNull JSONObject object, @NonNull String key, int defaultValue) {
        int value = object.optInt(key, defaultValue);
        return value >= 0 ? value : defaultValue;
    }

    private float opt(@NonNull JSONObject object, @NonNull String key, float defaultValue) {
        float value = (float)object.optDouble(key, (double)defaultValue);
        return value >= 0.0f ? value : defaultValue;
    }

    @NonNull
    private String opt(@NonNull JSONObject object, @NonNull String key, String defaultValue) {
        String value = object.optString(key, defaultValue);
        return !Strings.isNullOrEmpty(value) ? value : defaultValue;
    }

    static {
        ConfigurationCompositor.ajc$preClinit();
        LOGGER = new Logger("ConfigurationCompositor");
    }

    static final /* synthetic */ ProjectConfiguration updateRunConfigurationFromConfig_aroundBody0(ConfigurationCompositor ajc$this, ProjectConfiguration config, String data, JoinPoint joinPoint) {
        ProjectConfiguration.Builder builder = ProjectConfiguration.builder();
        builder.csProjectId(config.getCsProjectId()).configVersion(config.getConfigVersion()).trackingEnabled(config.isTrackingEnabled()).screenShotsEnabled(config.isScreenShotEnabled()).anonymize(config.isAnonymousEnabled()).collectorEndpoint(config.getCollectorEndpoint()).samplingRate(config.getTrackingSampleRate()).debugFlag(config.getGodModeKey()).maxBucketSize(config.getMaxBucketSize()).csProjectId(config.getCsProjectId()).blackListedVersionsList(config.getBlackListedVersionsList());
        ajc$this.updateBuilderBasedOnJsonConfig(data, builder);
        return builder.build();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ConfigurationCompositor.java", ConfigurationCompositor.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateRunConfigurationFromConfig", "com.contentsquare.android.internal.ConfigurationCompositor", "com.contentsquare.android.internal.config.ProjectConfiguration:java.lang.String", "config:data", "", "com.contentsquare.android.internal.config.ProjectConfiguration"), 103);
    }
}

