/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.internal;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.WindowManager;
import com.contentsquare.android.BuildConfig;
import com.contentsquare.android.R;
import com.contentsquare.android.internal.logging.Logger;
import com.contentsquare.android.internal.util.MathUtil;
import com.contentsquare.android.internal.util.Strings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

public class DeviceInfo {
    public static final String HEIGHT = "h";
    public static final String WIDTH = "w";
    public static final String LABEL_SDK_VERSION = "sv";
    public static final String LABEL_SDK_BUILD = "sb";
    public static final String LABEL_APP_VERSOIN = "av";
    public static final String LABEL_APP_FLAVOR = "af";
    static final int PHONE_INT = 4;
    static final int TABLET_INT = 5;
    private static final double DEFAULT_BATTERY_LEVEL = -1.0;
    private static final float MAX_BATTERY_LEVEL = 100.0f;
    private static final String ANDROID_SDK_IDENTIFIER = "sdk-android";
    private static final String ANDROID_SDK_DEBUG = "debug";
    private static final String ANDROID_SDK_RELEASE = "release";
    private static final int BATTERY_FETCH_TIMEOUT = 30000;
    private final Logger mLogger = new Logger("DeviceInfo");
    private final int mStatusBarHeight;
    private final Application mApplication;
    private String mDeviceName;
    private int mDeviceIntType;
    private Map<String, Integer> mDeviceResolution;
    private String mDeviceOs;
    private String mApplicationName;
    private String mApplicationVersion;
    private String mApplicationFlavor;
    private String mUserLanguage;
    private String mUserTimezone;
    private boolean mDebugBuild = true;
    private String mCarrierName;
    private long mBatteryFetchTimestamp = 0L;
    @NonNull
    private Intent mCachedBatteryIntent;

    public DeviceInfo(@NonNull Application application) {
        this.mApplication = application;
        this.mDebugBuild = BuildConfig.DEBUG;
        this.fillDeviceProperties();
        Resources res = application.getResources();
        int resourceId = res.getIdentifier("status_bar_height", "dimen", "android");
        this.mStatusBarHeight = resourceId > 0 ? res.getDimensionPixelSize(resourceId) : 0;
        this.mCachedBatteryIntent = this.loadBatteryIntent();
        this.mBatteryFetchTimestamp = System.currentTimeMillis();
    }

    public Application getApplication() {
        return this.mApplication;
    }

    public String getDeviceName() {
        return this.mDeviceName;
    }

    public int getDeviceIntType() {
        return this.mDeviceIntType;
    }

    public Map<String, Integer> getDeviceResolution() {
        return this.mDeviceResolution;
    }

    @Nullable
    public JSONObject getDeviceResolutionJson() {
        JSONObject object = new JSONObject();
        try {
            object.put(WIDTH, (Object)this.mDeviceResolution.get(WIDTH));
            object.put(HEIGHT, (Object)this.mDeviceResolution.get(WIDTH));
        }
        catch (JSONException e) {
            this.mLogger.e(e, "Failed to process device resolution for bundle.", new Object[0]);
        }
        return object;
    }

    public String getDeviceOs() {
        return this.mDeviceOs;
    }

    public String getCarrierName() {
        return this.mCarrierName;
    }

    public int getBatteryLevelNow() {
        Intent batteryIntent = this.getCachedtBatteryIntent();
        if (batteryIntent == null) {
            return -1;
        }
        int level = batteryIntent.getIntExtra("level", -1);
        int scale = batteryIntent.getIntExtra("scale", -1);
        if (level == -1 || scale == -1) {
            return -1;
        }
        return (int)((float)level / (float)scale * 100.0f);
    }

    @NonNull
    private Intent getCachedtBatteryIntent() {
        long now = System.currentTimeMillis();
        if (now - this.mBatteryFetchTimestamp > 30000L) {
            this.mCachedBatteryIntent = this.loadBatteryIntent();
        }
        return this.mCachedBatteryIntent;
    }

    private Intent loadBatteryIntent() {
        IntentFilter batteryFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        return this.mApplication.registerReceiver(null, batteryFilter);
    }

    public String getApplicationName() {
        return this.mApplicationName;
    }

    public String getApplicationVersion() {
        return this.mApplicationVersion;
    }

    private String getApplicationFlavor() {
        return this.mApplicationFlavor;
    }

    public String getUserLanguage() {
        return this.mUserLanguage;
    }

    public String getUserTimezone() {
        return this.mUserTimezone;
    }

    boolean isTablet() {
        return this.mApplication.getResources().getBoolean(R.bool.isTablet);
    }

    boolean isInLandscape() {
        return this.mApplication.getResources().getBoolean(R.bool.isLandscape);
    }

    public boolean isDebugBuild() {
        return this.mDebugBuild;
    }

    public String getSdkVersion() {
        return "release-1.0.4";
    }

    int getSdkBuild() {
        return 1;
    }

    public int getStatusBarHeight() {
        return this.mStatusBarHeight;
    }

    int convertDpToPx(int dips) {
        Resources res = this.mApplication.getResources();
        return (int)TypedValue.applyDimension((int)1, (float)dips, (DisplayMetrics)res.getDisplayMetrics());
    }

    public int calculateActionBarHeight() {
        int actionBarHeight = 0;
        TypedValue tv = new TypedValue();
        if (this.mApplication.getApplicationContext().getTheme().resolveAttribute(16843499, tv, true)) {
            actionBarHeight = TypedValue.complexToDimensionPixelSize((int)tv.data, (DisplayMetrics)this.mApplication.getApplicationContext().getResources().getDisplayMetrics());
        }
        return actionBarHeight;
    }

    private void fillDeviceProperties() {
        this.mLogger.d("initiating the device info.", new Object[0]);
        this.mDeviceName = Build.MANUFACTURER + ' ' + Build.MODEL;
        this.mLogger.d("DeviceName: %s", this.mDeviceName);
        this.mDeviceIntType = this.isTablet() ? 5 : 4;
        this.mLogger.d("DeviceType: %s", this.mDeviceIntType);
        DisplayMetrics metrics = new DisplayMetrics();
        WindowManager windowManager = (WindowManager)this.mApplication.getSystemService("window");
        if (windowManager != null) {
            if (Build.VERSION.SDK_INT >= 17) {
                windowManager.getDefaultDisplay().getRealMetrics(metrics);
            } else {
                windowManager.getDefaultDisplay().getMetrics(metrics);
            }
            this.mDeviceResolution = new HashMap<String, Integer>();
            this.mDeviceResolution.put(HEIGHT, metrics.heightPixels);
            this.mDeviceResolution.put(WIDTH, metrics.widthPixels);
            this.mLogger.d("DeviceWidth: %d", metrics.widthPixels);
            this.mLogger.d("DeviceHeight: %d", metrics.heightPixels);
        }
        this.mDeviceOs = Build.VERSION.RELEASE;
        this.mLogger.d("DeviceOS: %s", this.mDeviceOs);
        PackageManager packageManager = this.mApplication.getPackageManager();
        ApplicationInfo appInfo = this.mApplication.getApplicationInfo();
        this.mApplicationName = String.valueOf(appInfo.loadLabel(packageManager));
        this.mApplicationFlavor = (String)this.processApplicationFlavor(this.getApplication().getApplicationContext(), "BUILD_TYPE");
        if (Strings.isNullOrEmpty(this.mApplicationFlavor)) {
            this.mApplicationFlavor = (String)this.processApplicationFlavor(this.getApplication().getApplicationContext(), "FLAVOR");
        }
        this.mLogger.d("ApplicationName: %s", this.mApplicationName);
        try {
            PackageInfo info = packageManager.getPackageInfo(this.mApplication.getPackageName(), 0);
            this.mApplicationVersion = String.valueOf(info.versionName);
        }
        catch (PackageManager.NameNotFoundException e) {
            this.mLogger.w(e, "failed to get the PackageInfo for %s", this.mApplication.getPackageName());
            this.mApplicationVersion = "Unknown";
        }
        this.mLogger.d("ApplicationVersion: %s", this.mApplicationVersion);
        this.mUserLanguage = Locale.getDefault().getDisplayName();
        this.mLogger.d("UserLanguage: %s", this.mUserLanguage);
        this.mUserTimezone = TimeZone.getDefault().getID();
        this.mLogger.d("UserTimezone: %s", this.mUserTimezone);
        TelephonyManager manager = (TelephonyManager)this.mApplication.getSystemService("phone");
        if (manager != null) {
            this.mCarrierName = manager.getNetworkOperatorName();
        }
    }

    @CheckResult
    @Nullable
    private <T> T processApplicationFlavor(Context context, String fieldName) {
        try {
            Class<?> clazz = Class.forName(context.getPackageName() + ".BuildConfig");
            Field field = clazz.getField(fieldName);
            return (T)field.get(null);
        }
        catch (ClassNotFoundException e) {
            this.mLogger.e("Failed to get app Flavor %s", e.getMessage());
        }
        catch (NoSuchFieldException e) {
            this.mLogger.e("Failed to get app Flavor %s", e.getMessage());
        }
        catch (IllegalAccessException e) {
            this.mLogger.e("Failed to get app Flavor %s", e.getMessage());
        }
        return null;
    }

    public boolean hasPermissionGranted(@NonNull String permission) {
        int res = this.getApplication().getApplicationContext().checkCallingOrSelfPermission(permission);
        return res == 0;
    }

    @SuppressLint(value={"MissingPermission"})
    public int getActiveConnectionType() {
        ConnectivityManager conManager = (ConnectivityManager)this.mApplication.getSystemService("connectivity");
        if (conManager != null && this.hasPermissionGranted("android.permission.ACCESS_NETWORK_STATE")) {
            NetworkInfo networkInfo = conManager.getActiveNetworkInfo();
            if (networkInfo == null) {
                return 0;
            }
            if (!networkInfo.isConnectedOrConnecting()) {
                return 1;
            }
            if (networkInfo.getType() == 1) {
                return 2;
            }
            return this.determineDataConnectionType(networkInfo.getSubtype());
        }
        return 0;
    }

    private int determineDataConnectionType(int networkSubtype) {
        switch (networkSubtype) {
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return 3;
            }
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: {
                return 4;
            }
            case 11: 
            case 13: 
            case 15: {
                return 5;
            }
            case 0: {
                return 0;
            }
        }
        return 0;
    }

    public boolean isDeviceCharging() {
        boolean acCharge;
        Intent batteryStatus = this.getCachedtBatteryIntent();
        boolean wifiCharge = false;
        int chargePlug = batteryStatus.getIntExtra("plugged", -1);
        boolean usbCharge = chargePlug == 2;
        boolean bl = acCharge = chargePlug == 1;
        if (Build.VERSION.SDK_INT >= 17) {
            wifiCharge = chargePlug == 4;
        }
        return usbCharge || acCharge || wifiCharge;
    }

    public int getScreenOrientation() {
        int orientation = this.getApplication().getResources().getConfiguration().orientation;
        if (orientation == 2) {
            return 1;
        }
        return 0;
    }

    @SuppressFBWarnings(value={"DB_DUPLICATE_BRANCHES"}, justification="Findbugs acting weirdly because we use the same value (when optimised in a different field")
    @NonNull
    public JSONObject getTypeOrigin() {
        JSONObject jsonOrigin = new JSONObject();
        try {
            jsonOrigin.put("an", (Object)this.getApplicationName());
            jsonOrigin.put("st", (Object)ANDROID_SDK_IDENTIFIER);
            jsonOrigin.put("sf", (Object)(this.mDebugBuild ? ANDROID_SDK_DEBUG : ANDROID_SDK_RELEASE));
        }
        catch (JSONException e) {
            this.mLogger.e(e, "Failed to get Type Origin json for event.", new Object[0]);
        }
        return jsonOrigin;
    }

    @NonNull
    public JSONObject getVersionOrigin() {
        JSONObject jsonOrigin = new JSONObject();
        try {
            jsonOrigin.put(LABEL_SDK_VERSION, (Object)this.getSdkVersion());
            jsonOrigin.put(LABEL_SDK_BUILD, this.getSdkBuild());
            jsonOrigin.put(LABEL_APP_VERSOIN, (Object)this.getApplicationVersion());
            jsonOrigin.put(LABEL_APP_FLAVOR, (Object)this.getApplicationFlavor());
        }
        catch (JSONException e) {
            this.mLogger.e(e, "Failed to get json version Origin for event.", new Object[0]);
        }
        return jsonOrigin;
    }

    public int getCurrentAvailableFreeHeapMemory(Runtime forProcess) {
        long currentUsedMemory = forProcess.totalMemory() - forProcess.freeMemory();
        long currentAvailableMemory = forProcess.maxMemory() - currentUsedMemory;
        long toKbDivider = 1024L;
        long currentAvailableMemoryInKb = currentAvailableMemory / 1024L;
        return MathUtil.safeLongToInt(currentAvailableMemoryInKb);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DeviceIntType {
    }
}

