/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.internal;

import android.app.Activity;
import android.app.Application;
import android.content.ComponentCallbacks;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.contentsquare.android.internal.ConfigurationCompositor;
import com.contentsquare.android.internal.DeviceInfo;
import com.contentsquare.android.internal.Session$AjcClosure1;
import com.contentsquare.android.internal.async.ConfigRetrieverTask;
import com.contentsquare.android.internal.config.GodModeConfiguration;
import com.contentsquare.android.internal.config.ProjectConfiguration;
import com.contentsquare.android.internal.dagger.SingletonProvider;
import com.contentsquare.android.internal.dagger.session.SessionComponent;
import com.contentsquare.android.internal.events.processing.EventsProcessor;
import com.contentsquare.android.internal.factories.TasksFactory;
import com.contentsquare.android.internal.listeners.CsActivityCallbacks;
import com.contentsquare.android.internal.listeners.CsComponentChange;
import com.contentsquare.android.internal.logging.Logger;
import com.contentsquare.android.internal.model.EventsFactory;
import com.contentsquare.android.internal.model.JsonProxy;
import com.contentsquare.android.internal.model.data.ActionEvent;
import com.contentsquare.android.internal.model.data.AppExitEvent;
import com.contentsquare.android.internal.model.data.AppHideEvent;
import com.contentsquare.android.internal.preferences.PrefsHelper;
import com.contentsquare.android.internal.ui.glasspane.IGlassPane;
import com.contentsquare.android.internal.util.AssetManager;
import com.contentsquare.android.internal.util.ConfigurationHelper;
import com.contentsquare.android.internal.util.HttpConnection;
import com.contentsquare.android.internal.util.Strings;
import hugo.weaving.DebugLog;
import hugo.weaving.internal.Hugo;
import java.util.UUID;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class Session {
    private static final String SESSIONID = "sid";
    @NonNull
    private final String mProjectId;
    @NonNull
    private final EventsProcessor mEventsProcessor;
    @NonNull
    private final Application mApplication;
    @NonNull
    private final AssetManager mAssets;
    @NonNull
    private final ConfigurationCompositor mCompositor;
    @NonNull
    private final DeviceInfo mDeviceInfo;
    @NonNull
    private final IGlassPane mGlassPane;
    private final TasksFactory mTasksFactory;
    private final EventsFactory mEventsFactory;
    private final JsonProxy mJsonProxy;
    @VisibleForTesting
    boolean mSessionIsValid = false;
    @NonNull
    @VisibleForTesting
    PrefsHelper mPreferences;
    @Nullable
    @VisibleForTesting
    CsActivityCallbacks mActivityListener = null;
    @NonNull
    @VisibleForTesting
    ConfigurationHelper mHelper;
    private int mScreenCount = 0;
    @NonNull
    private ProjectConfiguration mProjectConfig = ProjectConfiguration.builder().build();
    @NonNull
    private GodModeConfiguration mGodModeConfiguration = new GodModeConfiguration();
    private int mSessionId;
    private String mUserId = null;
    private CsComponentChange mComponentListener = null;
    private final Logger mLog = new Logger("Session");
    private ConfigRetrieverTask mConfigRetrieverTask;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public Session(@NonNull Application application, @NonNull String projectId, @NonNull PrefsHelper prefsHelper, @NonNull IGlassPane glassPane, @NonNull EventsProcessor eventsProcessor, @NonNull AssetManager assets, @NonNull DeviceInfo deviceInfo, @NonNull ConfigurationCompositor compositor, @NonNull TasksFactory tasksFactory, @NonNull EventsFactory eventsFactory, @NonNull JsonProxy jsonProxy) {
        this.mProjectId = projectId;
        this.mPreferences = prefsHelper;
        this.mEventsProcessor = eventsProcessor;
        this.mAssets = assets;
        this.mCompositor = compositor;
        this.mGlassPane = glassPane;
        this.mApplication = application;
        this.mDeviceInfo = deviceInfo;
        this.mTasksFactory = tasksFactory;
        this.mEventsFactory = eventsFactory;
        this.mJsonProxy = jsonProxy;
        this.mHelper = new ConfigurationHelper();
    }

    public int getSessionId() {
        return this.mSessionId;
    }

    @Nullable
    public String getUserId() {
        return this.mUserId;
    }

    @NonNull
    public EventsFactory getEventsFactory() {
        return this.mEventsFactory;
    }

    @NonNull
    public JsonProxy getJsonProxy() {
        return this.mJsonProxy;
    }

    public boolean canTakeScreenShots() {
        return this.mProjectConfig.isScreenShotEnabled() && this.mGodModeConfiguration.isGodModeEnabled();
    }

    @VisibleForTesting
    void loadUserId() {
        this.mUserId = this.mHelper.getLastUserIdConfig();
        if (Strings.isNullOrEmpty(this.mUserId)) {
            this.mUserId = this.generateAndStoreUserId();
        }
    }

    private String generateAndStoreUserId() {
        String uid = UUID.randomUUID().toString();
        this.mHelper.setUserIdConfig(uid);
        return uid;
    }

    @VisibleForTesting
    void loadSessionId() {
        int previousSession = this.mPreferences.getInt(SESSIONID, -1);
        this.mSessionId = previousSession + 1;
        this.mPreferences.putInt(SESSIONID, this.mSessionId);
    }

    boolean isSessionValid() {
        return this.mSessionIsValid;
    }

    @NonNull
    public ProjectConfiguration getRunConfiguration() {
        return this.mProjectConfig;
    }

    @NonNull
    Session setRunConfiguration(@NonNull ProjectConfiguration runConfiguration) {
        this.mProjectConfig = runConfiguration;
        return this;
    }

    @DebugLog
    public void startSession() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        Hugo.aspectOf().logAndExecute(new Session$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    private void disposeConfigRetrieverIfExists() {
        if (this.mConfigRetrieverTask != null) {
            this.mConfigRetrieverTask.cancel(true);
        }
    }

    private void retrieveConfig() {
        SessionComponent sessionComponent = SingletonProvider.getSessionComponent();
        HttpConnection httpConnection = sessionComponent.getHttpConnection();
        this.mConfigRetrieverTask = this.mTasksFactory.produceConfigRetrieverTask(new ConfigRetrieverTask.ConfigProviderCallback(){

            @Override
            public void processAnswer(@NonNull ConfigRetrieverTask.ConfigProviderAnswer answer) {
                if (answer.isValid()) {
                    Session.this.mProjectConfig = answer.projectConfiguration();
                    Session.this.mGodModeConfiguration = answer.godModeConfiguration();
                    Session.this.startListeners();
                    boolean inGodmode = Session.this.mGodModeConfiguration.isGodModeEnabled();
                    boolean godOverride = Session.this.mGodModeConfiguration.isLoggingEnabled();
                    if (inGodmode) {
                        Logger.overrideLogging(godOverride);
                    }
                    Session.this.getEventsProcessor().setBucketSize(Session.this.getRunConfiguration().getMaxBucketSize());
                }
            }
        }, httpConnection, this.mAssets, this.mCompositor, this.mHelper);
        this.mConfigRetrieverTask.execute(new String[]{this.getProjectId()});
    }

    public boolean isGodModeOn() {
        return this.mGodModeConfiguration.isGodModeEnabled();
    }

    @NonNull
    public GodModeConfiguration getGodModeConfig() {
        return this.mGodModeConfiguration;
    }

    @VisibleForTesting
    boolean hasConfigurationSaved() {
        return !Strings.isNullOrEmpty(this.mHelper.getLastClientConfig());
    }

    @VisibleForTesting
    void startListeners() {
        if (this.shouldTrackSession()) {
            this.mSessionIsValid = true;
            if (this.mActivityListener == null && this.mComponentListener == null) {
                this.mLog.i("the session was validated, attaching listeners", new Object[0]);
                this.mActivityListener = new CsActivityCallbacks();
                this.mComponentListener = new CsComponentChange();
                this.mApplication.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.mActivityListener);
                this.mApplication.registerComponentCallbacks((ComponentCallbacks)this.mComponentListener);
            } else {
                this.mLog.i("the session is already active, moving along", new Object[0]);
            }
        } else {
            this.mLog.i("the session Is INVALID, aborting", new Object[0]);
            this.stopSession();
        }
    }

    @VisibleForTesting
    boolean shouldTrackSession() {
        ProjectConfiguration conf = this.getRunConfiguration();
        boolean track = conf.isTrackingEnabled() && conf.isInSampleInterval();
        this.mLog.d("shouldTrackSession : mSessionIsValid:%b ", this.mSessionIsValid);
        this.mLog.d("shouldTrackSession : isTrackerEngaged:%b ", conf.isTrackingEnabled());
        this.mLog.d("shouldTrackSession : isInAudience:%b ", conf.isInSampleInterval());
        this.mLog.d("shouldTrackSession : Final:%b ", track);
        return track;
    }

    public void stopSession() {
        this.mLog.i("stopSession Called", new Object[0]);
        if (this.mSessionIsValid) {
            this.mLog.i("Stopping all listeners", new Object[0]);
            this.mGlassPane.stopSession();
            AppHideEvent.AppHideEventBuilder hideBuilder = (AppHideEvent.AppHideEventBuilder)this.getEventsFactory().produceEvent(2);
            AppExitEvent.AppExitEventBuilder exitBuilder = (AppExitEvent.AppExitEventBuilder)this.getEventsFactory().produceEvent(3);
            this.getEventsProcessor().processEvent(this.getJsonProxy().serializeToJson(hideBuilder.build()));
            this.getEventsProcessor().processEvent(this.getJsonProxy().serializeToJson(exitBuilder.build()));
            this.getEventsProcessor().flushPendingEvents();
            this.mApplication.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.mActivityListener);
            this.mApplication.unregisterComponentCallbacks((ComponentCallbacks)this.mComponentListener);
            if (this.mActivityListener != null) {
                this.detachGlassPane(this.mActivityListener.getLiveActivity());
            }
            this.mActivityListener = null;
            this.mComponentListener = null;
            this.mSessionIsValid = false;
            this.disposeConfigRetrieverIfExists();
        } else {
            this.mLog.i("the session was INVALID, no listeners was registered.", new Object[0]);
        }
    }

    @NonNull
    public EventsProcessor getEventsProcessor() {
        return this.mEventsProcessor;
    }

    @NonNull
    public IGlassPane getGlass() {
        return this.mGlassPane;
    }

    @NonNull
    public String getProjectId() {
        return this.mProjectId;
    }

    @Nullable
    public CsActivityCallbacks getActivityListener() {
        return this.mActivityListener;
    }

    public void attachGlassPane(@NonNull Activity activity) {
        this.mGlassPane.attachGlassPane(activity);
        this.incrementScreenCount();
    }

    public void detachGlassPane(Activity activity) {
        this.mGlassPane.detachGlassPane(activity);
    }

    public void pauseSession() {
        this.mGlassPane.pauseListeners();
    }

    public void resumeSession() {
        this.mGlassPane.resumeListeners();
    }

    private void incrementScreenCount() {
        ++this.mScreenCount;
    }

    public int getScreenCount() {
        return this.mScreenCount;
    }

    public <T extends ActionEvent.Builder> T produceEventBuilder(int eventAction) {
        return this.getEventsFactory().produceEvent(eventAction);
    }

    static {
        Session.ajc$preClinit();
    }

    static final /* synthetic */ void startSession_aroundBody0(Session ajc$this, JoinPoint joinPoint) {
        ajc$this.mLog.i("startSession Called", new Object[0]);
        ajc$this.loadSessionId();
        ajc$this.getEventsProcessor().setSessionId(ajc$this.getSessionId());
        ajc$this.loadUserId();
        ajc$this.disposeConfigRetrieverIfExists();
        ajc$this.retrieveConfig();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("Session.java", Session.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "startSession", "com.contentsquare.android.internal.Session", "", "", "", "void"), 241);
    }
}

