/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.internal.async;

import android.os.AsyncTask;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.contentsquare.android.internal.ConfigurationCompositor;
import com.contentsquare.android.internal.config.GodModeConfiguration;
import com.contentsquare.android.internal.config.ProjectConfiguration;
import com.contentsquare.android.internal.logging.Logger;
import com.contentsquare.android.internal.util.AssetManager;
import com.contentsquare.android.internal.util.ConfigurationHelper;
import com.contentsquare.android.internal.util.HttpConnection;
import com.contentsquare.android.internal.util.Strings;
import com.contentsquare.android.internal.util.UriBuilder;
import com.contentsquare.android.internal.validator.GodModeClipboardValidator;
import com.contentsquare.android.internal.validator.GodModeConfigValidator;

public class ConfigRetrieverTask
extends AsyncTask<String, Void, ConfigProviderAnswer> {
    public static final String TAG = "ConfigRetrieverTask";
    @NonNull
    private final ConfigProviderCallback mCallback;
    @NonNull
    private final HttpConnection mHttpConnection;
    @NonNull
    private final AssetManager mAssetsManager;
    @NonNull
    private final ConfigurationCompositor mConfigurationCompositor;
    @NonNull
    private final ConfigurationHelper mHelper;
    @NonNull
    private final GodModeClipboardValidator mGodModeClipboardValidator;
    @NonNull
    private final GodModeConfigValidator mGodModeConfigValidator;
    @NonNull
    private final Logger mLogger;
    @NonNull
    private final UriBuilder mUriBuilder;
    private ProjectConfiguration mDefaultConfig;

    public ConfigRetrieverTask(@NonNull ConfigProviderCallback callback, @NonNull HttpConnection httpConnection, @NonNull AssetManager assetManager, @NonNull ConfigurationCompositor configurationCompositor, @NonNull ConfigurationHelper helper, @NonNull UriBuilder uriBuilder, @NonNull GodModeClipboardValidator godModeClipboardValidator, @NonNull GodModeConfigValidator godModeConfigValidator, @NonNull Logger logger) {
        this.mCallback = callback;
        this.mHttpConnection = httpConnection;
        this.mAssetsManager = assetManager;
        this.mConfigurationCompositor = configurationCompositor;
        this.mHelper = helper;
        this.mUriBuilder = uriBuilder;
        this.mGodModeClipboardValidator = godModeClipboardValidator;
        this.mGodModeConfigValidator = godModeConfigValidator;
        this.mLogger = logger;
    }

    protected void onPreExecute() {
        super.onPreExecute();
        this.mDefaultConfig = this.fetchDefaultConfig();
        this.mGodModeClipboardValidator.fetchClipboardData();
        this.onPostExecute(new ConfigProviderAnswer(this.mDefaultConfig, new GodModeConfiguration()));
    }

    protected ConfigProviderAnswer doInBackground(String ... params) {
        boolean shouldUseDebugConfig;
        String projectConfigUrl;
        String jsonString;
        String projectId = params[0];
        GodModeConfiguration godModeConfiguration = this.godModeConfiguration();
        boolean godModeValid = this.mGodModeConfigValidator.isGodModeValidFor(projectId, godModeConfiguration);
        if (!godModeValid) {
            godModeConfiguration = new GodModeConfiguration();
        }
        if ((jsonString = this.fetchConfig(projectConfigUrl = (shouldUseDebugConfig = godModeValid && godModeConfiguration.shouldUseDebugConfig()) ? this.mUriBuilder.buildProjectConfigUrlForDebug(projectId) : this.mUriBuilder.buildProjectConfigUrl(projectId))) == null) {
            return ConfigProviderAnswer.invalid();
        }
        ProjectConfiguration projectConfiguration = this.mConfigurationCompositor.updateRunConfigurationFromConfig(this.mDefaultConfig, jsonString);
        this.mHelper.setLastConfig(projectConfiguration.toJson().toString());
        return new ConfigProviderAnswer(projectConfiguration, godModeConfiguration);
    }

    protected void onPostExecute(ConfigProviderAnswer answer) {
        super.onPostExecute((Object)answer);
        if (this.isCancelled()) {
            return;
        }
        if (answer != null) {
            this.mCallback.processAnswer(answer);
        }
    }

    @NonNull
    private GodModeConfiguration godModeConfiguration() {
        if (this.mGodModeClipboardValidator.isGodModeKeyVerified(this.mDefaultConfig.getGodModeKey())) {
            String godModeConfig = this.fetchConfig(this.mUriBuilder.godModeConfigEndpoint());
            return GodModeConfiguration.load(godModeConfig);
        }
        return GodModeConfiguration.load(null);
    }

    @Nullable
    private String fetchConfig(@NonNull String path) {
        HttpConnection.HttpResponse projectResult = this.mHttpConnection.performGetWithFormdata(path, null);
        if (projectResult.getStatus() == 200) {
            this.mLogger.d("Got HTTP_OK for path: [%s]", path);
            String stringResponse = projectResult.getStringResponse();
            if (!TextUtils.isEmpty((CharSequence)stringResponse)) {
                return stringResponse;
            }
        }
        if (projectResult.getStatus() == 404) {
            this.mLogger.e("Got HTTP_NOT_FOUND for path [%s]", path);
        }
        if (projectResult.getStatus() > 200) {
            this.mLogger.e("Got HTTP Status: [%d] for path: [%s]", projectResult.getStatus(), path);
        }
        String errorMsg = "Invalid ProjectId provided. Please verify the project ID you provided when making the call to the ContentSquareSDK. \n ContentSquare Exiting...";
        Log.e((String)"ContentSquare", (String)"Invalid ProjectId provided. Please verify the project ID you provided when making the call to the ContentSquareSDK. \n ContentSquare Exiting...");
        return null;
    }

    @NonNull
    private ProjectConfiguration fetchDefaultConfig() {
        String jsonConfig;
        if (this.hasCachedConfig()) {
            this.mLogger.d("has configuration saved", new Object[0]);
            jsonConfig = this.mHelper.getLastClientConfig();
        } else {
            this.mLogger.d("No configuration saved - Loading Base Config", new Object[0]);
            jsonConfig = this.mAssetsManager.loadBaseConfigFromAsset();
        }
        return this.mConfigurationCompositor.getRunConfiguration(jsonConfig);
    }

    private boolean hasCachedConfig() {
        return !Strings.isNullOrEmpty(this.mHelper.getLastClientConfig());
    }

    public static class ConfigProviderAnswer {
        @Nullable
        private final ProjectConfiguration mProjectConfiguration;
        @Nullable
        private final GodModeConfiguration mGodModeConfiguration;
        private final boolean mIsValid;

        ConfigProviderAnswer(@NonNull ProjectConfiguration projectConfiguration, @Nullable GodModeConfiguration godModeConfiguration) {
            this(projectConfiguration, godModeConfiguration, true);
        }

        ConfigProviderAnswer(@Nullable ProjectConfiguration projectConfiguration, @Nullable GodModeConfiguration godModeConfiguration, boolean isValid) {
            this.mProjectConfiguration = projectConfiguration;
            this.mGodModeConfiguration = godModeConfiguration;
            this.mIsValid = isValid;
        }

        @NonNull
        static ConfigProviderAnswer invalid() {
            return new ConfigProviderAnswer(null, null, false);
        }

        @Nullable
        public GodModeConfiguration godModeConfiguration() {
            return this.mGodModeConfiguration;
        }

        @Nullable
        public ProjectConfiguration projectConfiguration() {
            return this.mProjectConfiguration;
        }

        public boolean isValid() {
            return this.mIsValid;
        }
    }

    public static interface ConfigProviderCallback {
        public void processAnswer(@NonNull ConfigProviderAnswer var1);
    }
}

