/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.internal.async;

import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.contentsquare.android.internal.async.TransactionRunnable;
import com.contentsquare.android.internal.logging.Logger;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadExecutor {
    private static final int CORE_POOL_SIZE = 1;
    private static final int AVAILABLE_PROCESSORS = Runtime.getRuntime().availableProcessors();
    private static final long KEEP_ALIVE = 30L;
    private static final TimeUnit TIME_UNIT = TimeUnit.SECONDS;
    private static final int BLOCKING_QUEUE_SIZE = 10;
    @VisibleForTesting
    final BlockingQueue<Runnable> mWorkQueue;
    @VisibleForTesting
    ThreadPoolExecutor mExecutor;
    private static final Logger LOGGER = new Logger("ThreadExecutor");

    public ThreadExecutor() {
        this(new ArrayBlockingQueue<Runnable>(10), new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable runnable, ThreadPoolExecutor executor) {
                if (runnable instanceof TransactionRunnable) {
                    LOGGER.i("Transaction Rejected! rolling back.", new Object[0]);
                    ((TransactionRunnable)runnable).rollBack();
                } else {
                    LOGGER.e("Rejected! Cannot rollback! Not an instance of TransactionRunnable", new Object[0]);
                }
            }
        });
    }

    @VisibleForTesting
    ThreadExecutor(BlockingQueue<Runnable> workQueue, RejectedExecutionHandler rejectedHandler) {
        LOGGER.i("Building a thredpool executor maxSize %d", AVAILABLE_PROCESSORS);
        this.mExecutor = new ThreadPoolExecutor(1, AVAILABLE_PROCESSORS, 30L, TIME_UNIT, workQueue, rejectedHandler);
        this.mWorkQueue = workQueue;
        this.mExecutor.allowCoreThreadTimeOut(false);
    }

    public boolean dispatch(@Nullable Runnable runnable) {
        if (runnable == null) {
            return false;
        }
        this.mExecutor.execute(runnable);
        LOGGER.i("dispatching, mWorkQueue.size(%d) ", this.mWorkQueue.size());
        LOGGER.w("pool status: ActiveCount[%d], QueueSize[%d], TaskCount[%d], PoolSize[%d], isShutdown[%b], isTerminated[%b], isTerminating[%b], ", this.mExecutor.getActiveCount(), this.mExecutor.getQueue().size(), this.mExecutor.getTaskCount(), this.mExecutor.getPoolSize(), this.mExecutor.isShutdown(), this.mExecutor.isTerminated(), this.mExecutor.isTerminating());
        return true;
    }

    public void clearQueue() {
        this.mWorkQueue.clear();
    }
}

