/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.internal.config;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.contentsquare.android.internal.logging.Logger;
import com.contentsquare.android.internal.util.Strings;
import org.json.JSONException;
import org.json.JSONObject;

public class GodModeConfiguration {
    private static final String GOD_MODE = "god_mode";
    private static final String USE_DEBUG_CONF = "use_debug_conf";
    private static final String ENABLE_LOG = "enable_log";
    private static final String SD_STORAGE_EVENTS = "sd_storage_events";
    private static final String SD_STORAGE_SCREENS = "sd_storage_screens";
    private static final String UPLOAD_URL = "network_storage";
    private static final String PRINT_TOUCHPATH = "print_touchpath";
    private static final String SAVE_SCREENSHOT_LOCALLY = "save_screenshot_locally";
    private static final String WHITELIST = "whitelist";
    private static final Logger LOG = new Logger("GodModeConfiguration");
    private boolean mGodModeEnabled = false;
    private boolean mUseDebugConfig = false;
    private boolean mDebugLogsEnabled = false;
    private boolean mUseSdForEventStorage = false;
    private boolean mUseSdForScreenStorage = false;
    private String mScreengraphUploadUrl = null;
    private boolean mLogTouchPaths = false;
    private boolean mStoreScreengraphsLocally = false;
    private String mWhiteList;

    @NonNull
    public static GodModeConfiguration load(@Nullable String godDirectives) {
        GodModeConfiguration godConfig = new GodModeConfiguration();
        godConfig.setGodModeOn(false);
        if (Strings.isNullOrEmpty(godDirectives)) {
            return godConfig;
        }
        try {
            JSONObject object = new JSONObject(godDirectives);
            if (object.has(USE_DEBUG_CONF)) {
                boolean debugConf = GodModeConfiguration.getBooleanField(object, USE_DEBUG_CONF);
                godConfig.setUseDebugConfig(debugConf);
            }
            if (object.has(ENABLE_LOG)) {
                boolean enableLog = GodModeConfiguration.getBooleanField(object, ENABLE_LOG);
                godConfig.setLogEnabled(enableLog);
            }
            if (object.has(SD_STORAGE_EVENTS)) {
                boolean storeEvents = GodModeConfiguration.getBooleanField(object, SD_STORAGE_EVENTS);
                godConfig.setStoreEventsOnSdCard(storeEvents);
            }
            if (object.has(SD_STORAGE_SCREENS)) {
                boolean storeScreen = GodModeConfiguration.getBooleanField(object, SD_STORAGE_SCREENS);
                godConfig.setStoreScreensOnSdCard(storeScreen);
            }
            if (object.has(UPLOAD_URL)) {
                String url = GodModeConfiguration.getStringField(object, UPLOAD_URL);
                godConfig.setScreengraphUploadUrl(url);
            }
            if (object.has(PRINT_TOUCHPATH)) {
                boolean touchPath = GodModeConfiguration.getBooleanField(object, PRINT_TOUCHPATH);
                godConfig.setPrintTouchPad(touchPath);
            }
            if (object.has(SAVE_SCREENSHOT_LOCALLY)) {
                boolean saveScreenShot = GodModeConfiguration.getBooleanField(object, SAVE_SCREENSHOT_LOCALLY);
                godConfig.setStoreScreenshotsLocally(saveScreenShot);
            }
            godConfig.setWhiteList(GodModeConfiguration.getStringField(object, WHITELIST));
            if (object.has(GOD_MODE)) {
                boolean godMode = GodModeConfiguration.getBooleanField(object, GOD_MODE);
                godConfig.setGodModeOn(godMode);
            }
        }
        catch (NullPointerException | JSONException e) {
            LOG.e("Error: %s", e.getMessage());
            LOG.w("God mode is disabled due to an error in the config.", new Object[0]);
        }
        return godConfig;
    }

    private static boolean getBooleanField(@NonNull JSONObject json, String label) {
        return json.optBoolean(label, false);
    }

    @NonNull
    private static String getStringField(@NonNull JSONObject json, String label) {
        return json.optString(label, null);
    }

    public boolean isGodModeEnabled() {
        return this.mGodModeEnabled;
    }

    @VisibleForTesting
    private void setGodModeOn(boolean godMode) {
        this.mGodModeEnabled = godMode;
    }

    public boolean shouldUseDebugConfig() {
        return this.mUseDebugConfig;
    }

    @VisibleForTesting
    private void setUseDebugConfig(boolean useDebugConfig) {
        this.mUseDebugConfig = useDebugConfig;
    }

    public boolean isLoggingEnabled() {
        return this.mDebugLogsEnabled;
    }

    @VisibleForTesting
    private void setLogEnabled(boolean enableLog) {
        this.mDebugLogsEnabled = enableLog;
    }

    boolean storeEventsOnSdCard() {
        return this.mUseSdForEventStorage;
    }

    @VisibleForTesting
    private void setStoreEventsOnSdCard(boolean sdStorageEvents) {
        this.mUseSdForEventStorage = sdStorageEvents;
    }

    boolean storeScreensOnSdCard() {
        return this.mUseSdForScreenStorage;
    }

    @VisibleForTesting
    private void setStoreScreensOnSdCard(boolean sdStorageScreens) {
        this.mUseSdForScreenStorage = sdStorageScreens;
    }

    public String getScreengraphUploadUrl() {
        return this.mScreengraphUploadUrl;
    }

    @VisibleForTesting
    private void setScreengraphUploadUrl(String uploadUrl) {
        this.mScreengraphUploadUrl = uploadUrl;
    }

    boolean shouldPrintTouchPath() {
        return this.mLogTouchPaths;
    }

    @VisibleForTesting
    private void setPrintTouchPad(boolean printTouchPath) {
        this.mLogTouchPaths = printTouchPath;
    }

    boolean storeScreenshotsLocally() {
        return this.mStoreScreengraphsLocally;
    }

    @VisibleForTesting
    private void setStoreScreenshotsLocally(boolean saveScreenShotLocally) {
        this.mStoreScreengraphsLocally = saveScreenShotLocally;
    }

    @Nullable
    public String getWhiteList() {
        return this.mWhiteList;
    }

    private void setWhiteList(String whiteList) {
        this.mWhiteList = whiteList;
    }
}

