/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.internal.config;

import android.support.annotation.NonNull;
import com.contentsquare.android.internal.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class ProjectConfiguration {
    private final int mCsProjectId;
    private final int mConfigVersion;
    private final boolean mTrackerEnabled;
    private final boolean mScreenShots;
    private final boolean mAnonymize;
    private final String mEndpoint;
    private final float mSampleRate;
    private final String mDebugFlag;
    private final int mBucketSize;
    private final String mBlackListedAppVersions;
    private final boolean mInSampleInterval;
    private final Logger mLogger = new Logger(ProjectConfiguration.class.getSimpleName());

    private ProjectConfiguration(@NonNull Builder builder) {
        this.mCsProjectId = builder.mCsProjectId;
        this.mConfigVersion = builder.mVersion;
        this.mTrackerEnabled = builder.mEnabled;
        this.mScreenShots = builder.mScreenShots;
        this.mAnonymize = builder.mAnonymize;
        this.mEndpoint = builder.mEndpoint;
        this.mSampleRate = builder.mSampleRate;
        this.mDebugFlag = builder.mDebugFlag;
        this.mBucketSize = builder.mMaxBucketSize;
        this.mBlackListedAppVersions = builder.mBlackListed;
        this.mInSampleInterval = builder.mInSampleInterval;
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    public int getCsProjectId() {
        return this.mCsProjectId;
    }

    public int getConfigVersion() {
        return this.mConfigVersion;
    }

    public boolean isTrackingEnabled() {
        return this.mTrackerEnabled;
    }

    public boolean isScreenShotEnabled() {
        return this.mScreenShots;
    }

    public boolean isAnonymousEnabled() {
        return this.mAnonymize;
    }

    @NonNull
    public String getCollectorEndpoint() {
        return this.mEndpoint;
    }

    public float getTrackingSampleRate() {
        return this.mSampleRate;
    }

    @NonNull
    public String getGodModeKey() {
        return this.mDebugFlag;
    }

    public int getMaxBucketSize() {
        return this.mBucketSize;
    }

    @NonNull
    public String getBlackListedVersionsList() {
        return this.mBlackListedAppVersions;
    }

    @NonNull
    public JSONObject toJson() {
        JSONObject object = new JSONObject();
        try {
            object.put("cs_project_id", this.mCsProjectId);
            object.put("version", this.mConfigVersion);
            object.put("blacklisted", (Object)this.mBlackListedAppVersions);
            object.put("screenshots", this.mScreenShots);
            object.put("enabled", this.mTrackerEnabled);
            object.put("anonymize", this.mAnonymize);
            object.put("debug_flag", (Object)this.mDebugFlag);
            object.put("sample", (double)this.mSampleRate);
            object.put("bucket", this.mBucketSize);
            object.put("endpoint", (Object)this.mEndpoint);
        }
        catch (JSONException e) {
            this.mLogger.e(e, "JSONException while trying to serialize the current instance into a JSONObject", new Object[0]);
        }
        return object;
    }

    public boolean isInSampleInterval() {
        return this.mInSampleInterval;
    }

    public static class Builder {
        private int mCsProjectId;
        private int mVersion;
        private boolean mEnabled;
        private boolean mScreenShots;
        private boolean mAnonymize;
        private String mEndpoint = "";
        private float mSampleRate;
        private String mDebugFlag = "";
        private int mMaxBucketSize;
        private String mBlackListed = "";
        private boolean mInSampleInterval;

        private Builder() {
        }

        @NonNull
        public Builder anonymize(boolean anonymize) {
            this.mAnonymize = anonymize;
            return this;
        }

        @NonNull
        public Builder csProjectId(int projectId) {
            this.mCsProjectId = projectId;
            return this;
        }

        @NonNull
        public Builder configVersion(int configVersion) {
            this.mVersion = configVersion;
            return this;
        }

        @NonNull
        public Builder trackingEnabled(boolean trackingEnabled) {
            this.mEnabled = trackingEnabled;
            return this;
        }

        @NonNull
        public Builder screenShotsEnabled(boolean screenShotsEnabled) {
            this.mScreenShots = screenShotsEnabled;
            return this;
        }

        @NonNull
        public Builder collectorEndpoint(@NonNull String collectorEndpoint) {
            this.mEndpoint = collectorEndpoint;
            return this;
        }

        @NonNull
        public Builder samplingRate(float samplingRate) {
            this.mSampleRate = samplingRate;
            return this;
        }

        @NonNull
        public Builder debugFlag(@NonNull String debugFlag) {
            this.mDebugFlag = debugFlag;
            return this;
        }

        @NonNull
        public Builder maxBucketSize(int maxBucketSize) {
            this.mMaxBucketSize = maxBucketSize;
            return this;
        }

        @NonNull
        public Builder blackListedVersionsList(@NonNull String list) {
            this.mBlackListed = list;
            return this;
        }

        @NonNull
        public Builder inSamplingInterval(boolean inSampleInterval) {
            this.mInSampleInterval = inSampleInterval;
            return this;
        }

        public boolean isAnonymized() {
            return this.mAnonymize;
        }

        public boolean isTrackerEnabled() {
            return this.mEnabled;
        }

        public boolean isScreenShotEnabled() {
            return this.mScreenShots;
        }

        public float getSampleRateValue() {
            return this.mSampleRate;
        }

        public int getCsProjectId() {
            return this.mCsProjectId;
        }

        public int getVersion() {
            return this.mVersion;
        }

        public int getMaxBucketSize() {
            return this.mMaxBucketSize;
        }

        public String getCollectorEndpoint() {
            return this.mEndpoint;
        }

        public String getDebugFlag() {
            return this.mDebugFlag;
        }

        public String getBlackListedVersionsList() {
            return this.mBlackListed;
        }

        @NonNull
        public ProjectConfiguration build() {
            return new ProjectConfiguration(this);
        }
    }
}

